/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.duration;

import com.ibm.team.apt.api.common.planning.IPlanDuration;
import com.ibm.team.apt.api.common.workitem.Duration;
import com.ibm.team.apt.api.common.workitem.IDuration;

public class PlanDuration
extends Duration
implements IPlanDuration {
    private final long fOriginalEstimate;
    private final long fCorrectedEstimate;
    private final long fTimeSpent;
    private static final int INVALID_TIME_SPENT_OFFSET = 3;
    public static final IPlanDuration UNSPECIFIED = new PlanDuration(-1L, -1L, -1L, false);

    public PlanDuration(long originalEstimate, long correctedEstimate, long timeSpent, boolean isResolved) {
        super(PlanDuration.calculateDuration(originalEstimate, correctedEstimate, timeSpent, isResolved));
        this.fOriginalEstimate = originalEstimate;
        this.fCorrectedEstimate = correctedEstimate;
        this.fTimeSpent = timeSpent;
    }

    static long calculateDuration(long originalEstimate, long correctedEstimate, long timeSpent, boolean isResolved) {
        long result = originalEstimate;
        if (correctedEstimate >= 0L) {
            result = correctedEstimate;
        }
        if (timeSpent >= 0L) {
            if (!isResolved) {
                if (result >= 0L) {
                    result = (result -= timeSpent) < 0L ? 0L : result;
                }
            } else {
                result = timeSpent;
            }
        }
        return result;
    }

    public IDuration getEstimate() {
        return this.getCorrectedEstimate().isSpecified() ? this.getCorrectedEstimate() : this.getOriginalEstimate();
    }

    public IDuration getCorrectedEstimate() {
        return new Duration(this.fCorrectedEstimate);
    }

    public IDuration getOriginalEstimate() {
        return new Duration(this.fOriginalEstimate);
    }

    public IDuration getTimeSpent() {
        return new Duration(this.fTimeSpent);
    }

    public IDuration getTimeRemaining() {
        long timeSpent = this.getTimeSpent().getMilliseconds();
        if (PlanDuration.isEncodedTimeRemaining(timeSpent)) {
            return new Duration(PlanDuration.decodeTimeSpent2TimeRemaining(timeSpent));
        }
        if (timeSpent >= 0L) {
            long value = this.getEstimate().getMilliseconds() - timeSpent;
            if (value >= 0L) {
                return new Duration(value);
            }
            return Duration.INVALID;
        }
        return new Duration(this.getEstimate().getMilliseconds());
    }

    public static long encodeInvalidTimeRemaining(long value) {
        long result = 0L;
        result += 3L;
        result += value;
        return result *= -1L;
    }

    public static long decodeTimeSpent2TimeRemaining(long value) {
        assert (PlanDuration.isEncodedTimeRemaining(value));
        long result = value;
        result *= -1L;
        return result -= 3L;
    }

    static boolean isEncodedTimeRemaining(long timeSpent) {
        return timeSpent < -2L;
    }
}

