/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.duration;

import com.ibm.jdojo.dojo.date.locale.Locale;
import com.ibm.jdojo.dojo.date.locale.Stamp;
import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.annotations.Inline;
import com.ibm.jdojo.util.JSDate;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.workitem.Duration;
import com.ibm.team.apt.api.common.workitem.IDuration;

public class Instant
extends DojoObject
implements IInstant {
    private final JSDate fDate;

    public static Instant currentTime() {
        return new Instant(new JSDate());
    }

    public static Instant time(Number milliseconds) {
        return new Instant(new JSDate(((Long)milliseconds).longValue()));
    }

    public static Instant fromString(String dateString) {
        return new Instant(Stamp.fromISOString((String)dateString));
    }

    public static Instant fromDate(JSDate date) {
        return new Instant(date);
    }

    private Instant(JSDate date) {
        this.fDate = date;
    }

    public long getTime() {
        return this.fDate.getTime();
    }

    public IInstant setHours(int hour, int min, int sec, int ms) {
        JSDate newDate = new JSDate(this.fDate.getTime());
        newDate.setHours(hour, min, sec, ms);
        return new Instant(newDate);
    }

    public boolean before(IInstant instant) {
        return this.fDate.getTime() < ((Instant)instant).fDate.getTime();
    }

    public boolean beforeEq(IInstant instant) {
        return this.fDate.getTime() <= ((Instant)instant).fDate.getTime();
    }

    public boolean after(IInstant instant) {
        return this.fDate.getTime() > ((Instant)instant).fDate.getTime();
    }

    public boolean afterEq(IInstant instant) {
        return this.fDate.getTime() >= ((Instant)instant).fDate.getTime();
    }

    public boolean eq(IInstant instant) {
        return this.fDate.getTime() == ((Instant)instant).fDate.getTime();
    }

    public IInstant plus(IDuration duration) {
        return new Instant(new JSDate(this.fDate.getTime() + duration.getMilliseconds()));
    }

    public IInstant minus(IDuration duration) {
        return new Instant(new JSDate(this.fDate.getTime() - duration.getMilliseconds()));
    }

    public int compareTo(IInstant o) {
        if (this.before(o)) {
            return -1;
        }
        if (this.after(o)) {
            return 1;
        }
        return 0;
    }

    public IDuration durationUntil(IInstant other) {
        return new Duration(other.getTime() - this.getTime());
    }

    public String toString() {
        return this.fDate.toString();
    }

    public String format(IInstant.InstantFormatOptions options) {
        String format;
        try {
            format = this.doFormat(options);
        }
        catch (Exception e) {
            Locale.FormatOptions lfo = new Locale.FormatOptions();
            lfo.selector = options.selector;
            lfo.formatLength = options.formatLength;
            lfo.datePattern = options.datePattern;
            lfo.timePattern = options.timePattern;
            lfo.locale = "en-us";
            format = Locale.format((JSDate)this.fDate, (Locale.FormatOptions)lfo);
        }
        return format;
    }

    @Inline(value="@{jazz.app.i18n}.date.locale.format(this.fDate, ${options})")
    private native String doFormat(IInstant.InstantFormatOptions var1);
}

