/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.ui.internal.wizard;

import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.setup.ui.internal.wizard.Messages;
import com.ibm.team.apt.setup.ui.internal.wizard.SetupUIPlugin;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.SSLContextUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class WelcomeWizardPage
extends WizardPage {
    private static final String LOCALHOST_URI = "https://localhost:9443/jts/setup";
    private Label fIconLabel;
    private Link fMessageLabel;
    private Composite fContainer;

    protected WelcomeWizardPage() {
        super("com.ibm.team.apt.setup.ui.internal.wizard.welcomePage", Messages.WelcomeWizardPage_TITLE, SetupUIPlugin.WIZARD_BANNER);
        this.setDescription(Messages.WelcomeWizardPage_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).spacing(this.convertWidthInCharsToPixels(3), LayoutConstants.getSpacing().y).applyTo(this.fContainer);
        this.fIconLabel = new Label(this.fContainer, 0);
        GridDataFactory.fillDefaults().grab(false, false).align(16384, 128).applyTo((Control)this.fIconLabel);
        this.fIconLabel.setImage(Display.getCurrent().getSystemImage(2));
        this.fMessageLabel = new Link(this.fContainer, 64);
        GridDataFactory.fillDefaults().grab(true, false).hint(this.convertWidthInCharsToPixels(80), -1).align(4, 0x1000000).applyTo((Control)this.fMessageLabel);
        this.fMessageLabel.setText(NLS.bind((String)Messages.WelcomeWizardPage_MESSAGE, (Object)"openWizard", (Object[])new Object[]{"JazzAdmins"}));
        this.fMessageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WelcomeWizardPage.this.linkClicked(e.text);
            }
        });
        this.setPageComplete(true);
        this.setControl((Control)this.fContainer);
        Dialog.applyDialogFont((Control)this.fContainer);
    }

    protected void linkClicked(String text) {
        final boolean[] isAvailabe = new boolean[1];
        IRunnableWithProgress setup = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.WelcomeWizardPage_MONITOR_OPEN_WIZARD, -1);
                try {
                    TeamFuture<Boolean> connectionChecker = new TeamFuture<Boolean>(){

                        /*
                         * Loose catch block
                         */
                        protected Boolean resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                            monitor.beginTask("", -1);
                            HttpsURLConnection connection = (HttpsURLConnection)new URL(WelcomeWizardPage.LOCALHOST_URI).openConnection();
                            SSLContext sc = SSLContextUtil.createSSLContext((TrustManager)new X509TrustManager(){

                                @Override
                                public X509Certificate[] getAcceptedIssuers() {
                                    return null;
                                }

                                @Override
                                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                                }

                                @Override
                                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                                }
                            });
                            connection.setSSLSocketFactory(sc.getSocketFactory());
                            connection.setHostnameVerifier(new HostnameVerifier(){

                                @Override
                                public boolean verify(String hostname, SSLSession session) {
                                    return true;
                                }
                            });
                            connection.connect();
                            Boolean bl = connection.getResponseCode() < 400 || connection.getResponseCode() == 401;
                            connection.disconnect();
                            monitor.done();
                            return bl;
                            {
                                catch (Throwable throwable) {
                                    try {
                                        try {
                                            connection.disconnect();
                                            throw throwable;
                                        }
                                        catch (Exception exception) {
                                            monitor.done();
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        monitor.done();
                                        throw throwable2;
                                    }
                                }
                            }
                            return false;
                        }
                    };
                    Boolean connectionCheckResult = (Boolean)connectionChecker.joinResult(5000);
                    if (connectionCheckResult != null) {
                        isAvailabe[0] = connectionCheckResult;
                    } else {
                        isAvailabe[0] = true;
                        connectionChecker.cancel();
                    }
                    connectionChecker.cancel();
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, setup);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            SetupUIPlugin.log(e);
        }
        if (isAvailabe[0]) {
            Program.launch((String)LOCALHOST_URI);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.WelcomeWizardPage_NOTFOUND_TITLE, (String)Messages.WelcomeWizardPage_NOTFOUND_MESSAGE);
        }
    }
}

