/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.ui.internal.wizard;

import com.ibm.team.apt.setup.ui.internal.wizard.SetupUIPlugin;
import com.ibm.team.foundation.setup.client.internal.registry.ProjectSetupDefinition;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class SampleRepositorySetupContext {
    private ITeamRepository fTeamRepository;
    private ProjectSetupDefinition fSetupDefinition;
    private boolean fShowGettingStarted = true;
    private boolean fCreateForTVT = false;

    public boolean isComplete() {
        return this.fTeamRepository != null && this.fSetupDefinition != null;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public void setTeamRepository(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
    }

    public ProjectSetupDefinition getSetupDefinition() {
        return this.fSetupDefinition;
    }

    public void setSetupDefinition(ProjectSetupDefinition repositorySetupDefinition) {
        this.fSetupDefinition = repositorySetupDefinition;
    }

    public File getBuildEngineDirectory() {
        Location installLocation = Platform.getInstallLocation();
        if (installLocation != null) {
            try {
                File buildEngineDirectory = new File(String.valueOf(new File(FileLocator.resolve((URL)installLocation.getURL()).getPath()).getAbsolutePath()) + "/../../buildsystem/buildengine/eclipse/");
                if (buildEngineDirectory.exists() && buildEngineDirectory.isDirectory()) {
                    return buildEngineDirectory;
                }
            }
            catch (IOException e) {
                SetupUIPlugin.log(e);
            }
        }
        return null;
    }

    public boolean isBuildPresent() {
        if (this.fSetupDefinition != null) {
            for (String id : this.fSetupDefinition.getRepositorySetupContributionIds()) {
                if (!id.startsWith("com.ibm.team.build.")) continue;
                return true;
            }
        }
        return false;
    }

    public String getBuildUserName() {
        return "build";
    }

    public String getBuildEngineName() {
        return "junit";
    }

    public boolean isShowGettingStarted() {
        return this.fShowGettingStarted;
    }

    public void setShowGettingStarted(boolean selection) {
        this.fShowGettingStarted = selection;
    }

    public boolean isCreateForTVT() {
        return this.fCreateForTVT;
    }

    public void setCreateForTVT(boolean createForTVT) {
        this.fCreateForTVT = createForTVT;
    }
}

