/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.junit.internal;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningClient;
import com.ibm.team.apt.internal.common.resource.model.ContributorAbsence;
import com.ibm.team.apt.internal.common.setup.builders.PlanBuilder;
import com.ibm.team.apt.internal.common.util.ItemQueryResults;
import com.ibm.team.apt.setup.client.util.PlanBuilderUtil;
import com.ibm.team.apt.setup.junit.internal.Messages;
import com.ibm.team.foundation.setup.client.IProjectSetupContribution;
import com.ibm.team.foundation.setup.client.ProcessDescription;
import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.ITeamWorkingCopy;
import com.ibm.team.process.client.workingcopies.IWorkingCopyManager;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.setup.junit.constants.JUnitIteration;
import com.ibm.team.process.setup.junit.constants.JUnitProjectArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.setup.junit.constants.JUnitUser;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.query.BaseWorkItemQueryModel;
import com.ibm.team.workitem.common.internal.util.SequenceValue;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.setup.client.builder.WorkItemBuilder;
import com.ibm.team.workitem.setup.junit.constants.JUnitCategory;
import com.ibm.team.workitem.setup.junit.constants.JUnitWorkItems;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AgilePlanningContribution
implements IProjectSetupContribution {
    private IWorkItem fStoryWorkItem;

    public void contributeToProcessSpec(ISetupContext setup, ProcessDescription processSpec, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            try {
                Document processSpecification = processSpec.getProcessSpecification();
                XPath newXPath = XPathFactory.newInstance().newXPath();
                Node node = (Node)newXPath.compile("//configuration-data[@id='com.ibm.team.apt.configuration.workItemProgressMode']").evaluate(processSpecification, XPathConstants.NODE);
                Element bi = node.getOwnerDocument().createElement("backlogIteration");
                bi.setAttribute("id", "development");
                bi.setAttribute("path", "/development/backlog");
                node.appendChild(bi);
            }
            catch (XPathExpressionException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void contributeArtifacts(ISetupContext setup, ProcessDescription processDescription, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AgilePlanningContribution_MONITOR_SETUP_PLANS_RESOURCE_PLANNING, (int)120);
        try {
            this.setContributorResourceData(setup, progress.newChild(20));
            this.contributeStories(setup, progress.newChild(40));
            this.createPlans(setup, progress.newChild(40));
            this.rankWorkItems(setup, progress.newChild(40));
            this.cleanUpArtifacts(setup, (IProgressMonitor)progress.newChild(20));
        }
        finally {
            monitor.done();
        }
    }

    private void setContributorResourceData(ISetupContext setupContext, SubMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.AgilePlanningContribution_MONITOR_CREATE_ABSENCES, 2);
        try {
            IResourcePlanningClient resourcePlanningClient = PlanningClientPlugin.getResourcePlanningClient((ITeamRepository)setupContext.getTeamRepository());
            ContributorAbsence billAbsence = this.createAbsence("Conference in Europe", this.toTimestamp(this.add(this.getThisWeek(), 3, -1)), 14, (IContributor)setupContext.getArtifact((IPredefinedArtifact)JUnitUser.Bill));
            resourcePlanningClient.saveAbsences((IContributorAbsence[])new ContributorAbsence[]{billAbsence}, (IProgressMonitor)monitor.newChild(1));
            ContributorAbsence markusAbsence = this.createAbsence("Vacation", this.toTimestamp(this.add(this.getThisWeek(), 3, 1)), 3, (IContributor)setupContext.getArtifact((IPredefinedArtifact)JUnitUser.Markus));
            resourcePlanningClient.saveAbsences((IContributorAbsence[])new ContributorAbsence[]{markusAbsence}, (IProgressMonitor)monitor.newChild(1));
        }
        finally {
            monitor.done();
        }
    }

    private void contributeStories(ISetupContext setup, SubMonitor progress) throws TeamRepositoryException {
        progress.beginTask(Messages.AgilePlanningContribution_MONITOR_CREATE_STORIES, 14);
        long HOUR = 3600000L;
        try {
            IAttribute storyPtsAttribute = ((IWorkItemClient)setup.getClientLibrary(IWorkItemClient.class)).findAttribute((IProjectAreaHandle)setup.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit), "com.ibm.team.apt.attribute.complexity", (IProgressMonitor)progress.newChild(1));
            IWorkItem wi1 = (IWorkItem)this.newWI(1, setup).type("defect").category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("AssertEquals is not working for primitive double/float args").duration(1800000L).owner((IPredefinedArtifact)JUnitUser.Bill).creator((IPredefinedArtifact)JUnitUser.Marlene).resolved(true).creationDate(this.time(252031041L)).description("The method AssertEquals(double, double) is not working correctly in version 4.4. Although its working fine for AssertEquals(Double, Double).<br/><br/>e.g.,<br/><br/>This is giving wrong test result:<br/>Assert.assertEquals(16.5, 16.5);<br/><br/>However, this is giving correct result:<br/>Assert.assertEquals(new Double(16.5), new Double(16.5));<br/><br/>This was not a problem in JUnit 3.8, which we were using earlier.<br/><br/>Please rectify it ASAP.<br/><br/>Regards,<br/><br/>Dharmender.<br/>").comment((IPredefinedArtifact)JUnitUser.Bill, this.time(249494592L), "We chose to have JUnit compare floating point numbers with an epsilon:<br/>assertEquals(expected, actual, epsilon). Comparing them for equality results in an error message:<br/>  java.lang.AssertionError: Use assertEquals(expected, actual, delta) to compare floating-point numbers<br/><br/>Regards,<br/><br/>Bill Cassavelli<br/>").build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi21 = (IWorkItem)this.newWI(21, setup).type("defect").category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("assertEquals does not compare float correctly").duration(14400000L).owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Marlene).resolved(true).creationDate(this.time(4348929542L)).description("I believe the issue is in isEquals() and the use of longValue() to make the comparison. Using floatValue() if both of the objects are floats in precedence to Numbers works. Not sure if this is the right thing to do!<br/>").comment((IPredefinedArtifact)JUnitUser.Marlene, this.time(3337237947L), "Can't reproduce in JUnit 4.3.1 -- autoboxing will pass Float Object-s and Java's implementation of .equals kicks in.  Normally you want to use Assert's methods with delta for comparing floats and doubles...<br/>").comment((IPredefinedArtifact)JUnitUser.Markus, this.time(3324612464L), "We've introduced assertEquals(float, float) to prevent the auto-boxing, and remind users to use the delta methods.<br/>").comment((IPredefinedArtifact)JUnitUser.Marlene, this.time(3322916716L), "Indeed -- it turns Eclipse 3.2.2 was using JUnit 4.1...  When will the new build be published?<br/>").build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi22 = (IWorkItem)this.newWI(22, setup).type("defect").category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("assertEquals does not compare java.math.BigDecimal properly").duration(0x6DDD00L).owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Jennifer).resolved(true).creationDate(this.time(4469954642L)).description("When using assertEquals to compare BigDecimals, it appears to only compare the integer portion of the BigDecimal.").comment((IPredefinedArtifact)JUnitUser.Marlene, this.time(3337138213L), "You're doing something wrong -- if you're right it would indicate a problem in Java anyway...<br/>").comment((IPredefinedArtifact)JUnitUser.Markus, this.time(3324940230L), "The original poster was correct.  This has been fixed in the latest check-in, which will go into JUnit 4.4<br/>").comment((IPredefinedArtifact)JUnitUser.Marlene, this.time(3322902482L), "Indeed -- it turns out Eclipse was using JUnit 4.1...  When will the new build be published?<br/>").build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi43 = (IWorkItem)this.newWI(43, setup).type("defect").category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("assertEquals two dimensions int arrays, ClassCastException").owner((IPredefinedArtifact)JUnitUser.Bill).creator((IPredefinedArtifact)JUnitUser.Freddy).resolved(true).creationDate(this.time(7315448142L)).description("Calling assertEquals with two dimensional arrays results in a ClassCastException.<br/><br/>java.lang.ClassCastException: [I<br/>at org.junit.Assert.assertEquals(Assert.java:129)<br/>at org.junit.Assert.assertEquals(Assert.java:144)<br/>............<br/><br/>failed on 4.1 version.<br/><br/>I think it is better to implements with Arrays.deepEquals(),new feature along with jdk1.5<br/><br/><br/>contact me with jingjiang.huang@hp.com<br/>").comment((IPredefinedArtifact)JUnitUser.Bill, this.time(6298270304L), "This is fixed in 4.2<br/>").build((IProgressMonitor)progress.newChild(1));
            IWorkItem storyToResolve = (IWorkItem)this.newWI(61, setup).type("com.ibm.team.apt.workItemType.story").category((IPredefinedArtifact)JUnitCategory.JUnit).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("Revise assertEquals").owner((IPredefinedArtifact)JUnitUser.Bill).creator((IPredefinedArtifact)JUnitUser.Bill).creationDate(this.time(55921976L)).description("We should revise the assertEquals implementation to fix bugs associated with it.").attribute(storyPtsAttribute, (Object)Identifier.create(ILiteral.class, (String)"20")).child(wi1).child(wi21).child(wi22).child(wi43).build((IProgressMonitor)progress.newChild(1));
            this.executeWorkflowAction(setup, (IWorkItemHandle)storyToResolve, "com.ibm.team.apt.storyWorkflow.action.a15", (IProgressMonitor)progress.newChild(1));
            this.executeWorkflowAction(setup, (IWorkItemHandle)storyToResolve, "com.ibm.team.apt.storyWorkflow.action.a7", (IProgressMonitor)progress.newChild(1));
            this.newWI(55, setup).type("com.ibm.team.apt.workItemType.story").category((IPredefinedArtifact)JUnitCategory.JUnit).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM2).summary("Improve documentation for 4.4").owner((IPredefinedArtifact)JUnitUser.Bill).creator((IPredefinedArtifact)JUnitUser.Bill).creationDate(this.time(55921976L)).description("We should do an documentation effort for 4.4.").attribute(storyPtsAttribute, (Object)Identifier.create(ILiteral.class, (String)"8")).child((IPredefinedArtifact)JUnitWorkItems.CookbookTypo).child((IPredefinedArtifact)JUnitWorkItems.JavaDocIgnoreUpdate).child((IPredefinedArtifact)JUnitWorkItems.TestRunnerDoc).build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi59 = (IWorkItem)this.newWI(59, setup).type("defect").category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("Specify new assertThat syntax").duration(28800000L).owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Markus).resolved(true).creationDate(this.time(2296308L)).duration(50400000L).build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi60 = (IWorkItem)this.newWI(60, setup).type("defect").category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("Write test cases for assertThat").duration(86400000L).owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Markus).resolved(true).creationDate(this.time(2187149L)).duration(14400000L).build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi57 = (IWorkItem)this.newWI(57, setup).category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1).summary("Implement new assertThat ").owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Bill).resolved(true).creationDate(this.time(3307906L)).description("Based on Joe Walnes new assertion mechanism we should provide a new assertThat syntax directly on JUnit.").child(wi59).child(wi60).build((IProgressMonitor)progress.newChild(1));
            IWorkItem wi58 = (IWorkItem)this.newWI(58, setup).category((IPredefinedArtifact)JUnitCategory.Framework).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM2).summary("Based on the assertThat syntax we should provide assumptions and theories support").owner((IPredefinedArtifact)JUnitUser.Markus).creator((IPredefinedArtifact)JUnitUser.Bill).creationDate(this.time(3172406L)).duration(57600000L).build((IProgressMonitor)progress.newChild(1));
            this.fStoryWorkItem = (IWorkItem)this.newWI(56, setup).type("com.ibm.team.apt.workItemType.story").category((IPredefinedArtifact)JUnitCategory.JUnit).plannedFor((IPredefinedArtifact)JUnitIteration.dev_FourOhFour).summary("Provide improved Assertion syntax").owner((IPredefinedArtifact)JUnitUser.Bill).creator((IPredefinedArtifact)JUnitUser.Bill).creationDate(this.time(55411617L)).description("The assertion syntax should be enriched with assertThat, assumptions and theories.").attribute(storyPtsAttribute, (Object)Identifier.create(ILiteral.class, (String)"20")).child(wi57).child(wi58).build((IProgressMonitor)progress.newChild(1));
        }
        finally {
            progress.done();
        }
    }

    private void executeWorkflowAction(ISetupContext setup, IWorkItemHandle handle, String workflowAction, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 3);
        IWorkItemClient workItemClient = (IWorkItemClient)setup.getClientLibrary(IWorkItemClient.class);
        IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
        workingCopyManager.connect(handle, IWorkItem.DEFAULT_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        WorkItemWorkingCopy workingCopy = workingCopyManager.getWorkingCopy(handle);
        workingCopy.setWorkflowAction(workflowAction);
        workingCopy.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        workingCopyManager.disconnect(handle);
    }

    private void createPlans(ISetupContext setup, SubMonitor progress) throws TeamRepositoryException {
        progress.beginTask(Messages.AgilePlanningContribution_MONITOR_CREATE_PLANS, 3);
        try {
            PlanBuilder planBuilder = PlanBuilderUtil.createPlanBuilder((ISetupContext)setup);
            planBuilder.name("JUnit Sprint Backlog").type("com.ibm.team.apt.plantype.default").iteration((IIterationHandle)setup.getArtifact((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM1)).owner((IProcessAreaHandle)setup.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit)).planNotes("== JUnit 4.4 Sprint 1\n\nNo additional information is captured for sprint 1.").build();
            planBuilder.save();
            planBuilder = PlanBuilderUtil.createPlanBuilder((ISetupContext)setup);
            planBuilder.name("JUnit Sprint Backlog").type("com.ibm.team.apt.plantype.default").iteration((IIterationHandle)setup.getArtifact((IPredefinedArtifact)JUnitIteration.dev_FourOhFourM2)).owner((IProcessAreaHandle)setup.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit)).planNotes("== JUnit 4.4 Sprint 2\n\nNo additional information is captured for sprint 2").build();
            planBuilder.save();
            StringWriter c = new StringWriter(){

                @Override
                public StringWriter append(CharSequence csq) {
                    return super.append(csq).append('\n');
                }
            };
            c.append("== JUnit 4.4 Plan");
            c.append("=== Staffing");
            c.append('\n');
            c.append("The following contributors will actively work on JUnit 4.4.");
            c.append("* Bill Cassavelli");
            c.append("* Markus Kent");
            c.append("* Jason Mitchell");
            c.append("== New Features");
            c.append('\n');
            c.append("We will investigate in a new assertion syntax to support assertThat, assumptions and theories (see ");
            c.append(String.format("[[ %s %d | %s (%d) ]]", this.fStoryWorkItem.getWorkItemType(), this.fStoryWorkItem.getId(), this.fStoryWorkItem.getHTMLSummary().getPlainText(), this.fStoryWorkItem.getId()));
            c.append("=== Architectural Topics");
            c.append('\n');
            c.append("No architectural changes are planned for 4.4");
            c.append("=== Documentation");
            c.append('\n');
            c.append("We should do a documentation pass and check/update existing Javadoc and examples");
            planBuilder = PlanBuilderUtil.createPlanBuilder((ISetupContext)setup);
            planBuilder.name("JUnit Release Backlog").type("com.ibm.team.apt.plantype.release").iteration((IIterationHandle)setup.getArtifact((IPredefinedArtifact)JUnitIteration.dev_FourOhFour)).owner((IProcessAreaHandle)setup.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit)).planNotes(c.toString()).build();
            planBuilder.save();
            planBuilder = PlanBuilderUtil.createPlanBuilder((ISetupContext)setup);
            planBuilder.name("JUnit Product Backlog").type("com.ibm.team.apt.plantype.release").iteration((IIterationHandle)setup.getArtifact((IPredefinedArtifact)JUnitIteration.dev_backlog)).owner((IProcessAreaHandle)setup.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit)).planNotes("== JUnit Product Backlog\n\nUse this plan to maintain the JUnit product backlog").build();
            planBuilder.save();
        }
        finally {
            progress.done();
        }
    }

    private void rankWorkItems(ISetupContext setup, SubMonitor progress) throws TeamRepositoryException {
        BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        IItemHandleInputArg[] args = new IItemHandleInputArg[]{query.newItemHandleArg(), query.newItemHandleArg(), query.newItemHandleArg(), query.newItemHandleArg()};
        Object[] params = new Object[]{((ICategory)setup.getArtifact((IPredefinedArtifact)JUnitCategory.JUnit)).getItemHandle(), ((ICategory)setup.getArtifact((IPredefinedArtifact)JUnitCategory.Framework)).getItemHandle(), ((ICategory)setup.getArtifact((IPredefinedArtifact)JUnitCategory.Doc)).getItemHandle(), ((ICategory)setup.getArtifact((IPredefinedArtifact)JUnitCategory.Tests)).getItemHandle()};
        IPredicate p = model.category()._in(args);
        query.filter(p);
        query.orderByDsc((IField)model.internalPriority()).orderByDsc((IField)model.id());
        IQueryService queryService = ((IterationPlanClient)setup.getClientLibrary(IIterationPlanClient.class)).getQueryService();
        IWorkItemClient workItemClient = (IWorkItemClient)setup.getClientLibrary(IWorkItemClient.class);
        IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
        ItemQueryResults resultIterator = new ItemQueryResults(queryService, query, params);
        List workItemHandles = resultIterator.getAllItems();
        progress.setWorkRemaining(1 + workItemHandles.size() * 2);
        SequenceValue sequenceValue = SequenceValue.INITIAL;
        String rankingAttributeId = String.valueOf(PlanItem.NEW_RANKING.getId()) + '.' + "_pm7NmRYUEd6L1tNIGdz5qQ";
        IAttribute rankingAttribute = workItemClient.findAttribute((IProjectAreaHandle)setup.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit), rankingAttributeId, (IProgressMonitor)progress.newChild(1));
        for (IWorkItemHandle workItemHandle : workItemHandles) {
            workingCopyManager.connect(workItemHandle, IWorkItem.LARGE_PROFILE, (IProgressMonitor)progress.newChild(1));
            WorkItemWorkingCopy workingCopy = workingCopyManager.getWorkingCopy(workItemHandle);
            IWorkItem workItem = workingCopy.getWorkItem();
            if (!workItem.hasAttribute(rankingAttribute)) {
                workItem.addCustomAttribute(rankingAttribute);
            }
            workItem.setValue(rankingAttribute, (Object)sequenceValue.serializeSequenceValue(PlanItem.NEW_RANKING.getId()));
            workingCopy.save((IProgressMonitor)progress.newChild(1));
            workingCopyManager.disconnect(workItemHandle);
            sequenceValue = SequenceValue.FACTORY.successor(sequenceValue);
        }
        progress.done();
    }

    private ContributorAbsence createAbsence(String summary, Timestamp start, int days, IContributor owner) {
        ContributorAbsence result = (ContributorAbsence)IContributorAbsence.ITEM_TYPE.createItem();
        result.setSummary(summary);
        result.setStartDate(start);
        result.setEndDate(new Timestamp(start.getTime() + (long)days * 86400000L));
        result.setContributor((IContributorHandle)owner);
        return result;
    }

    private Calendar getNow() {
        return Calendar.getInstance();
    }

    private Calendar getToday() {
        Calendar calendar = this.getNow();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private Calendar getThisWeek() {
        Calendar calendar = this.getToday();
        calendar.set(7, 2);
        return calendar;
    }

    private Calendar add(Calendar calendar, int field, int delta) {
        calendar.add(field, delta);
        return calendar;
    }

    private Timestamp toTimestamp(Calendar calendar) {
        return new Timestamp(calendar.getTimeInMillis());
    }

    private WorkItemBuilder newWI(int workItemId, ISetupContext setupContext) {
        return WorkItemBuilder.create((ISetupContext)setupContext, (IProjectAreaHandle)((IProjectAreaHandle)setupContext.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit)));
    }

    private Timestamp time(long relative) {
        return new Timestamp(System.currentTimeMillis() - relative);
    }

    private void cleanUpArtifacts(ISetupContext setup, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 3);
        IAuditableCommon auditableClient = (IAuditableCommon)setup.getClientLibrary(IAuditableCommon.class);
        IItemManager itemManager = setup.getTeamRepository().itemManager();
        IContributor loggedInUser = (IContributor)itemManager.fetchCompleteItem((IItemHandle)auditableClient.getUser(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IProcessItemService processItemService = (IProcessItemService)setup.getClientLibrary(IProcessItemService.class);
        IWorkingCopyManager workingCopyManager = processItemService.getWorkingCopyManager();
        IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)setup.getArtifact((IPredefinedArtifact)JUnitProjectArea.JUnit), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IProcessAreaWorkingCopy processAreaWorkingCopy = (IProcessAreaWorkingCopy)workingCopyManager.createPrivateWorkingCopy((IProcessItem)projectArea);
        ITeamWorkingCopy teamWorkingCopy = processAreaWorkingCopy.getTeam();
        teamWorkingCopy.removeContributors(new IContributorHandle[]{loggedInUser});
        processAreaWorkingCopy.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }
}

