/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.client.util;

import com.ibm.team.apt.internal.common.setup.builders.IPlanBuilderContext;
import com.ibm.team.apt.internal.common.setup.builders.PlanBuilder;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;

public class PlanBuilderUtil {
    public static PlanBuilder createPlanBuilder(ISetupContext setupContext) {
        IPlanBuilderContext context = PlanBuilderUtil.createPlanBuilderContext(setupContext);
        return new PlanBuilder(context);
    }

    private static IPlanBuilderContext createPlanBuilderContext(final ISetupContext setupContext) {
        IPlanBuilderContext builderContext = new IPlanBuilderContext(){

            public <T> T getLibrary(Class<T> library) {
                Class<?> clazz;
                Object object = setupContext.getTeamRepository().getClientLibrary(library);
                if (object == null) {
                    object = ((TeamRepository)setupContext.getTeamRepository()).getServiceInterface(library);
                }
                return (T)(library.isAssignableFrom(clazz = object.getClass()) ? object : null);
            }

            public IItem resolve(IItemHandle handle) throws TeamRepositoryException {
                return setupContext.getTeamRepository().itemManager().fetchCompleteItem(handle, 2, null);
            }

            public IContent storeContent(String type, String encoding, byte[] byteArray) throws TeamRepositoryException {
                return setupContext.getTeamRepository().contentManager().storeContent(type, new String(byteArray), null);
            }
        };
        return builderContext;
    }
}

