/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanSaveResult;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.IStore;
import com.ibm.team.apt.internal.common.PlanConfigurationStore;
import com.ibm.team.apt.internal.ide.core.PlanAddedEvent;
import com.ibm.team.apt.internal.ide.core.PlanEvent;
import com.ibm.team.apt.internal.ide.core.PlanModel;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.navigator.AbstractIterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.DevelopmentLineFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomainFolder;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.wizards.AbstractIterationPlanWizard;
import com.ibm.team.apt.internal.ide.ui.wizards.AbstractIterationPlanWizardPage;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.apt.internal.ide.ui.wizards.NewIterationPlanWizardPage;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemTemplateClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.template.AttributeVariable;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.ITemplateAttributeIdentifiers;
import com.ibm.team.workitem.common.template.ITemplateTypeIdentifiers;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.INewWorkItemsFromTemplateWizard;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.SelectWorkItemTemplatePage;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.TemplateInstantiationHistory;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewIterationPlanWizard
extends AbstractIterationPlanWizard
implements INewWizard,
INewWorkItemsFromTemplateWizard {
    private AbstractIterationPlanWizardPage fNewIterationPlanPage;
    private IWorkbench fWorkbench;
    private IWorkItemTemplateHandle fSelectedTemplate;
    private IProjectAreaHandle fProjectAreaHandle;
    private IIterationPlanRecord fPlanIterationRecord;
    private boolean fCanFinish = true;

    public NewIterationPlanWizard() {
        this(new IterationPlanWizardContext(ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true)));
    }

    public NewIterationPlanWizard(IterationPlanWizardContext context) {
        super(context);
        this.setWindowTitle(Messages.NewIterationPlanWizard_NEW_PLAN);
    }

    @Override
    public boolean needsProgressMonitor() {
        return true;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        if (selection != null) {
            this.processSelection(selection);
        }
        super.init(workbench, selection);
        if (!this.hasTeamRepository()) {
            this.fRepositorySelectionPage.setMessage(Messages.NewIterationPlanWizard_MSG_CONNECT_TO_REPOSITORY, 2);
        }
        if (!this.hasProjectArea() && this.hasMultipleTeamRepositories()) {
            this.fRepositorySelectionPage.setMessage(Messages.NewIterationPlanWizard_MSG_CONNECT_TO_PROJECT_AREA_SELECTION_REPOSITORY, 2);
        }
        if (!this.hasProjectArea() && !this.hasMultipleTeamRepositories()) {
            this.fProjectAreaSelectionPage.setMessage(Messages.NewIterationPlanWizard_MSG_CONNECT_TO_PROJECT_AREA, 2);
        }
        this.fNewIterationPlanPage = new NewIterationPlanWizardPage(this.fWizardContext);
        this.addPage((IWizardPage)this.fNewIterationPlanPage);
        SelectWorkItemTemplatePage selectTemplatePage = new SelectWorkItemTemplatePage("selectWorkItemTemplatePage", Messages.NewIterationPlanWizard_SELECT_TEMPLATE_PAGE_TITLE, null);
        selectTemplatePage.setEnableProjectCombo(false);
        this.addPage((IWizardPage)selectTemplatePage);
        this.setImageForAllPages(ImagePool.WIZBAN_CRT_ITERATION_PLAN);
    }

    private void processSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof AbstractIterationFolder) {
            this.fWizardContext.clear();
            IIteration interval = ((AbstractIterationFolder)element).getIteration();
            this.fWizardContext.setIteration((IIterationHandle)interval);
        } else if (element instanceof DevelopmentLineFolder) {
            this.fWizardContext.clear();
            DevelopmentLineFolder folder = (DevelopmentLineFolder)element;
            this.fWizardContext.setDevelopmentLineHandle((IDevelopmentLineHandle)folder.getDevelopmentLine());
        } else if (element instanceof PlanningDomainFolder) {
            this.fWizardContext.clear();
            Object categoryElement = ((PlanningDomainFolder)element).getRoot().getDomainSubtreeRoot().getCategoryElement();
            this.processCategoryElement(categoryElement);
        } else if (element instanceof IProjectAreaHandle) {
            this.fWizardContext.clear();
            IProjectAreaHandle projectArea = (IProjectAreaHandle)element;
            this.fWizardContext.setProjectArea(projectArea);
        } else if (element instanceof DomainSubtreeRoot) {
            this.fWizardContext.clear();
            Object categoryElement = ((DomainSubtreeRoot)element).getCategoryElement();
            this.processCategoryElement(categoryElement);
        } else if (element instanceof ITeamArea) {
            this.fWizardContext.clear();
            ITeamArea teamArea = (ITeamArea)element;
            this.fWizardContext.setProjectArea(teamArea.getProjectArea());
            this.fWizardContext.setTeamMemberArea((IProcessAreaHandle)teamArea);
        } else if (element instanceof IIterationPlanRecord) {
            this.fWizardContext.clear();
            IIterationPlanRecord plan = (IIterationPlanRecord)element;
            IProcessArea pa = (IProcessArea)((ITeamRepository)plan.getOrigin()).itemManager().getSharedItemIfKnown((IItemHandle)plan.getOwner());
            if (pa != null) {
                this.fWizardContext.setIteration(plan.getIteration());
                this.fWizardContext.setProjectArea(pa.getProjectArea());
                this.fWizardContext.setTeamMemberArea((IProcessAreaHandle)pa);
            }
        }
    }

    private void processCategoryElement(Object categoryElement) {
        ITeamAreaHandle handle;
        ITeamArea teamArea;
        if (categoryElement instanceof IProjectAreaHandle) {
            this.fWizardContext.setProjectArea((IProjectAreaHandle)categoryElement);
        } else if (categoryElement instanceof ITeamAreaHandle && (teamArea = (ITeamArea)((ITeamRepository)(handle = (ITeamAreaHandle)categoryElement).getOrigin()).itemManager().getSharedItemIfKnown((IItemHandle)handle)) != null) {
            this.fWizardContext.setProjectArea(teamArea.getProjectArea());
            this.fWizardContext.setTeamMemberArea((IProcessAreaHandle)teamArea);
        }
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (!page.isPageComplete() && !(page instanceof SelectWorkItemTemplatePage)) {
                return false;
            }
            ++n2;
        }
        return this.fCanFinish;
    }

    @Override
    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                @Override
                protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                    block6: {
                        monitor.beginTask(Messages.NewIterationPlanWizard_MONITOR_CREATE_PLAN, -1);
                        final Shell shell = NewIterationPlanWizard.this.getShell();
                        try {
                            try {
                                if (NewIterationPlanWizard.this.getContainer().getCurrentPage() instanceof SelectWorkItemTemplatePage && NewIterationPlanWizard.this.fSelectedTemplate != null) {
                                    NewIterationPlanWizard.this.instantiateWorkItemTemplate(monitor);
                                }
                                NewIterationPlanWizard.this.createPlan(monitor);
                                NewIterationPlanWizard.this.fCanFinish = true;
                            }
                            catch (TeamRepositoryException e) {
                                NewIterationPlanWizard.this.fCanFinish = false;
                                UI.asyncExec((Control)shell, new Runnable(){

                                    @Override
                                    public void run() {
                                        ExceptionHandler.handle(e, shell, Messages.NewIterationPlanWizard_ERR_PLAN_CREATION, null);
                                    }
                                });
                                monitor.done();
                                UI.asyncExec((Control)shell, new Runnable(){

                                    @Override
                                    public void run() {
                                        if (NewIterationPlanWizard.this.fPlanIterationRecord != null) {
                                            PlanningUI.openIterationPlanEditor((IIterationPlanRecordHandle)NewIterationPlanWizard.this.fPlanIterationRecord, NewIterationPlanWizard.this.fWorkbench.getActiveWorkbenchWindow().getActivePage());
                                        }
                                        NewIterationPlanWizard.this.getContainer().updateButtons();
                                    }
                                });
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.done();
                            UI.asyncExec((Control)shell, new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                        monitor.done();
                        UI.asyncExec((Control)shell, new /* invalid duplicate definition of identical inner class */);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), Messages.NewIterationPlanWizard_ERR_PLAN_CREATION, e.getLocalizedMessage());
            this.fCanFinish = false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.fCanFinish;
    }

    private void createPlan(IProgressMonitor monitor) throws TeamRepositoryException {
        IIterationPlanRecord plan = this.fNewIterationPlanPage.getResult();
        ITeamRepository teamRepository = this.fNewIterationPlanPage.getContext().getTeamRepository();
        IItemManager itemManager = teamRepository.itemManager();
        IProcessAreaHandle teamMemberAreaHandle = this.fNewIterationPlanPage.getContext().getTeamMemberArea();
        IProcessArea teamMemberArea = (IProcessArea)itemManager.fetchCompleteItem((IItemHandle)teamMemberAreaHandle, 0, monitor);
        this.fProjectAreaHandle = teamMemberArea.getProjectArea();
        IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)this.fProjectAreaHandle, 0, monitor);
        if (!ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(teamRepository, false).contains(this.fProjectAreaHandle)) {
            ConnectedProjectAreaRegistry.getDefault().addConnectedProjectArea(projectArea);
        }
        IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((ITeamRepository)teamRepository);
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)this.fProjectAreaHandle);
        IStore store = this.fNewIterationPlanPage.getContext().getAuxiliaryDataStore();
        if (store == null) {
            IContent content = null;
            store = IStore.FACTORY.createStore(content, (IAuditableCommon)auditableClient, monitor);
        }
        PlanConfigurationStore planConfigurationStore = new PlanConfigurationStore(store);
        planConfigurationStore.setRankingMode("explicit");
        final IterationPlanSaveResult saveResult = ((IterationPlanClient)client).create(plan, store, monitor);
        if (saveResult.getStatus().getSeverity() == 0) {
            IIterationPlanRecord savedPlan = saveResult.getPlanRecord();
            PlanModel.INSTANCE.firePlanEvent((PlanEvent)new PlanAddedEvent(teamRepository, savedPlan));
            this.fPlanIterationRecord = savedPlan;
        } else if (saveResult.getStatus().getSeverity() == 4) {
            UI.syncExec(this.fNewIterationPlanPage.getControl(), new Runnable(){

                @Override
                public void run() {
                    NewIterationPlanWizard.this.fNewIterationPlanPage.setPageComplete(false);
                    NewIterationPlanWizard.this.fNewIterationPlanPage.setMessage(saveResult.getStatus().getDetails(), 3);
                }
            });
        }
    }

    private void instantiateWorkItemTemplate(IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.subTask(Messages.NewIterationPlanWizard_MSG_INSTANTIATE_WORK_ITEM_TEMPLATE);
            Map<IAttributeVariable, Object> vars = this.initAttributeVariableValues(monitor);
            ITeamRepository repository = this.fNewIterationPlanPage.getContext().getTeamRepository();
            IWorkItemTemplateClient templateClient = (IWorkItemTemplateClient)repository.getClientLibrary(IWorkItemTemplateClient.class);
            templateClient.instantiateTemplate(this.fSelectedTemplate, vars, null, monitor);
            TemplateInstantiationHistory.getInstance((IProjectAreaHandle)this.fProjectAreaHandle).addEntry(new TemplateInstantiationHistory.TemplateHistoryEntry(this.fSelectedTemplate));
        }
        catch (TeamRepositoryException e) {
            String reason = e.getLocalizedMessage();
            String message = reason == null ? Messages.NewIterationPlanWizard_ERROR_ON_INSTANTIATE_TEMPLATE : NLS.bind((String)Messages.NewIterationPlanWizard_ERROR_REASON_INSTANTIATE_TEMPLATE, (Object)Messages.NewIterationPlanWizard_ERROR_ON_INSTANTIATE_TEMPLATE, (Object[])new Object[]{reason});
            throw new TeamRepositoryException(message);
        }
    }

    private Map<IAttributeVariable, Object> initAttributeVariableValues(IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<IAttributeVariable, Object> varValues = new HashMap<IAttributeVariable, Object>();
        AttributeVariable categoryAttribute = new AttributeVariable(ITemplateAttributeIdentifiers.WORKITEM_CATEGORY, ITemplateTypeIdentifiers.CATEGORY);
        AttributeVariable iterationAttribute = new AttributeVariable(ITemplateAttributeIdentifiers.WORKITEM_ITERATION, ITemplateTypeIdentifiers.ITERATION);
        ICategory categoryValue = this.getCategoryValue();
        IIterationHandle iterationHandle = this.fNewIterationPlanPage.getContext().getIteration();
        IIteration iterationValue = (IIteration)this.resolveItem((IItemHandle)iterationHandle, monitor);
        varValues.put((IAttributeVariable)categoryAttribute, categoryValue);
        varValues.put((IAttributeVariable)iterationAttribute, iterationValue);
        return varValues;
    }

    private ICategory getCategoryValue() throws TeamRepositoryException {
        ICategory categoryValue = null;
        IterationPlanWizardContext context = this.fNewIterationPlanPage.getContext();
        IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((ITeamRepository)context.getTeamRepository());
        List categories = workItemClient.findCategoriesOfProcessArea(context.getTeamMemberArea(), ICategory.DEFAULT_PROFILE, null);
        for (ICategory category : categories) {
            if (categoryValue == null || categoryValue.isUnassigned()) {
                categoryValue = category;
                continue;
            }
            if (category.getCategoryId().compareTo(categoryValue.getCategoryId()) >= 0) continue;
            categoryValue = category;
        }
        if (categoryValue == null) {
            throw new TeamRepositoryException(Messages.NewIterationPlanWizard_TEMPLATE_FAIL_NO_CATEGORIES);
        }
        return categoryValue;
    }

    private IItem resolveItem(IItemHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IItem resolvedItem = null;
        monitor.subTask(Messages.NewIterationPlanWizard_MSG_RESOLVE_ITEM_HANDLE);
        ITeamRepository teamRepository = this.fNewIterationPlanPage.getContext().getTeamRepository();
        IItemManager itemManager = teamRepository.itemManager();
        resolvedItem = itemManager.fetchCompleteItem(itemHandle, 0, monitor);
        return resolvedItem;
    }

    public IProjectAreaHandle getProjectArea() {
        IProcessArea teamMemberArea = this.getTeamMemberArea();
        if (teamMemberArea != null) {
            this.fProjectAreaHandle = teamMemberArea.getProjectArea();
        }
        return this.fProjectAreaHandle;
    }

    private IProcessArea getTeamMemberArea() {
        IProcessArea teamMemberArea = null;
        try {
            class GetTeamMemberAreaRunnable
            extends TeamRunnable {
                IProcessArea teamMemberAreaResult;

                GetTeamMemberAreaRunnable() {
                }

                @Override
                protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (NewIterationPlanWizard.this.fNewIterationPlanPage.isPageComplete()) {
                        try {
                            monitor.subTask(Messages.NewIterationPlanWizard_MSG_FETCH_TEAM_MEMBER_AREA);
                            IProcessAreaHandle teamMemberAreaHandle = NewIterationPlanWizard.this.fNewIterationPlanPage.getContext().getTeamMemberArea();
                            this.teamMemberAreaResult = (IProcessArea)NewIterationPlanWizard.this.resolveItem((IItemHandle)teamMemberAreaHandle, monitor);
                        }
                        catch (TeamRepositoryException tre) {
                            ExceptionHandler.handle(tre, NewIterationPlanWizard.this.getShell(), Messages.NewIterationPlanWizard_ERR_PLAN_CREATION, tre.getLocalizedMessage());
                        }
                    }
                }

                public IProcessArea getResult() {
                    return this.teamMemberAreaResult;
                }
            }
            GetTeamMemberAreaRunnable runnable = new GetTeamMemberAreaRunnable();
            this.getContainer().run(true, true, (IRunnableWithProgress)runnable);
            teamMemberArea = runnable.getResult();
        }
        catch (Exception e) {
            PlanningUIPlugin.log(e);
        }
        return teamMemberArea;
    }

    public void setProjectArea(IProjectAreaHandle projectArea) {
    }

    public boolean getPromptForAttributeVariableValues() {
        return false;
    }

    public void setPromptForAttributeVariableValues(boolean mustPrompt) {
    }

    public IWorkItemTemplateHandle getSelectedTemplate() {
        return this.fSelectedTemplate;
    }

    public void setSelectedTemplate(IWorkItemTemplateHandle template) {
        this.fSelectedTemplate = template;
    }
}

