/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.NewIterationPlanData;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.core.util.Resolver;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.wizards.AbstractIterationPlanWizardPage;
import com.ibm.team.apt.internal.ide.ui.wizards.EditIterationPlanData;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.ProcessNatureSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class EditIterationPlanWizardPage
extends AbstractIterationPlanWizardPage<EditIterationPlanData> {
    private IIterationHandle fOriginalInterval;
    private static final String PAGE_NAME = String.valueOf(PlanningUIPlugin.getPluginId()) + ".ConfigureIterationPlan";

    public EditIterationPlanWizardPage(IterationPlanWizardContext context) {
        super(context, PAGE_NAME, Messages.EditIterationPlanWizardPage_CONFIGURE_PLAN, "com.ibm.team.apt.ide.ui.dialog_configIterationPlan");
        this.setDescription(Messages.EditIterationPlanWizardPage_DSC_CONFIGURE_PLAN);
        this.setImageDescriptor(ImagePool.WIZBAN_CONF_ITERATION_PLAN);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setPageComplete(true);
    }

    @Override
    public void computeResult() {
        this.fResult = (IIterationPlanRecord)this.fCurrentRecord.getWorkingCopy();
        this.fResult.setName(this.fContext.getName());
        this.fResult.setPlanType(this.fContext.getSelectedPlanType());
        this.fResult.setOwner(this.fContext.getTeamMemberArea());
        this.fResult.setIteration(this.fContext.getIteration());
    }

    @Override
    protected TeamFuture<EditIterationPlanData> computeFuture() {
        TeamFuture future = new TeamFuture((Resolver)new Resolver<EditIterationPlanData>(){

            public EditIterationPlanData resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    monitor.beginTask(Messages.EditIterationPlanWizardPage_MONITOR_LOADING_PLAN_DATA, 5);
                    IItemManager manager = EditIterationPlanWizardPage.this.fContext.getTeamRepository().itemManager();
                    IIterationPlanRecord iterationPlan = (IIterationPlanRecord)manager.fetchCompleteItem((IItemHandle)EditIterationPlanWizardPage.this.fContext.getIterationPlanHandle(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    EditIterationPlanWizardPage.this.fOriginalInterval = iterationPlan.getIteration();
                    IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)EditIterationPlanWizardPage.this.fContext.getTeamRepository());
                    EditIterationPlanWizardPage.this.fContext = client.completeAndValidateContext(EditIterationPlanWizardPage.this.fContext, monitor);
                    NewIterationPlanData newIterationPlanData = client.fetchEditIterationPlanData(EditIterationPlanWizardPage.this.fContext.getProjectArea(), iterationPlan.getOwner(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    IIteration iteration = (IIteration)manager.fetchCompleteItem((IItemHandle)EditIterationPlanWizardPage.this.fOriginalInterval, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    newIterationPlanData.setIteration(iteration);
                    IDevelopmentLine devLine = (IDevelopmentLine)manager.fetchCompleteItem((IItemHandle)iteration.getDevelopmentLine(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    newIterationPlanData.setDevelopmentLine(devLine);
                    if (EditIterationPlanWizardPage.this.fContext.getProjectArea() != null) {
                        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)EditIterationPlanWizardPage.this.fContext.getProjectArea());
                        ProcessNatureSupport support = new ProcessNatureSupport(EditIterationPlanWizardPage.this.fContext.getProjectArea(), (IAuditableCommon)auditableClient);
                        support.initialize(monitor);
                        EditIterationPlanWizardPage.this.fIsTraditional = !support.hidePredecessorLinks();
                    }
                    EditIterationPlanData editIterationPlanData = new EditIterationPlanData(iterationPlan, newIterationPlanData);
                    return editIterationPlanData;
                }
                finally {
                    monitor.done();
                }
            }
        });
        return future;
    }

    @Override
    protected void futureResolved(EditIterationPlanData result) {
        this.setInput(result.getNewIterationPlanData(), result.getIterationPlan());
    }

    @Override
    public void updateStatus() {
        if (!this.fHasPermission) {
            this.setMessage(Messages.EditIterationPlanWizardPage_MSG_NO_PERMISSIONS, 1);
            this.setPageComplete(false);
        } else {
            super.updateStatus();
        }
    }

    public IIterationHandle getOriginalInterval() {
        return this.fOriginalInterval;
    }
}

