/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanSaveResult;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.core.PlanChangedEvent;
import com.ibm.team.apt.internal.ide.core.PlanEvent;
import com.ibm.team.apt.internal.ide.core.PlanModel;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.wizards.EditIterationPlanWizardPage;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class EditIterationPlanWizard
extends Wizard {
    private boolean fCanFinish = true;
    private EditIterationPlanWizardPage fEditIterationPlanPage;

    public EditIterationPlanWizard(IterationPlanWizardContext context) {
        this.setWindowTitle(Messages.EditIterationPlanWizardPage_CONFIGURE_PLAN);
        this.fEditIterationPlanPage = new EditIterationPlanWizardPage(context);
        this.addPage((IWizardPage)this.fEditIterationPlanPage);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        final boolean[] success = new boolean[]{true};
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                @Override
                public void execute(IProgressMonitor monitor) throws TeamRepositoryException {
                    monitor.beginTask(Messages.EditIterationPlanWizard_MONITOR_SAVE_CHANGES, 4);
                    IIterationPlanRecord result = EditIterationPlanWizard.this.fEditIterationPlanPage.getResult();
                    boolean intervalChanged = false;
                    IIterationHandle oldInterval = EditIterationPlanWizard.this.fEditIterationPlanPage.getOriginalInterval();
                    if (oldInterval == null || !oldInterval.sameItemId((IItemHandle)result.getIteration())) {
                        intervalChanged = true;
                    }
                    monitor.worked(1);
                    ITeamRepository repository = EditIterationPlanWizard.this.fEditIterationPlanPage.getContext().getTeamRepository();
                    IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((ITeamRepository)repository);
                    final IterationPlanSaveResult saveResult = ((IterationPlanClient)client).save(result, EditIterationPlanWizard.this.fEditIterationPlanPage.getContext().getAuxiliaryDataStore(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    boolean bl = success[0] = saveResult.getStatus().getSeverity() == 0;
                    if (success[0]) {
                        IIterationPlanRecord savedPlan = saveResult.getPlanRecord();
                        PlanModel.INSTANCE.firePlanEvent((PlanEvent)new PlanChangedEvent(repository, savedPlan, intervalChanged));
                    } else {
                        UI.syncExec(EditIterationPlanWizard.this.fEditIterationPlanPage.getControl(), new Runnable(){

                            @Override
                            public void run() {
                                EditIterationPlanWizard.this.fEditIterationPlanPage.setErrorMessage(saveResult.getStatus().getDetails());
                                EditIterationPlanWizard.this.fCanFinish = false;
                            }
                        });
                    }
                    monitor.worked(2);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), Messages.EditIterationPlanWizard_FAILURE_EDIT_PLAN, e.getLocalizedMessage());
            this.fCanFinish = false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getContainer().updateButtons();
        return success[0];
    }

    public boolean canFinish() {
        return this.fCanFinish && super.canFinish();
    }
}

