/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.wizards.DuplicateIterationPlanData;
import com.ibm.team.apt.internal.ide.ui.wizards.DuplicateIterationPlanWizardPage;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.CollatorCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DuplicatePagesFoldersPage
extends WizardPage {
    private static final String PAGE_NAME = String.valueOf(PlanningUIPlugin.getPluginId()) + DuplicatePagesFoldersPage.class.getSimpleName();
    private CheckboxTableViewer fViewer;
    private List<CopyContentWikiPage> fResult = new ArrayList<CopyContentWikiPage>(5);

    protected DuplicatePagesFoldersPage() {
        super(PAGE_NAME);
        this.setTitle(Messages.DuplicatePagesFoldersPage_DUPLICATE_PLAN);
        this.setMessage(Messages.DuplicatePagesFoldersPage_DSC_DUPLICATE_ADDITIONAL_DATA);
        this.setImageDescriptor(ImagePool.WIZBAN_DUP_ITERATION_PLAN);
        this.setPageComplete(false);
    }

    public boolean shouldCreateCopy(IWikiPage page) {
        Iterator<CopyContentWikiPage> iter = this.fResult.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getPage().sameItemId((IItemHandle)page)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldCopyContent(IWikiPage page) {
        for (CopyContentWikiPage next : this.fResult) {
            if (!next.getPage().sameItemId((IItemHandle)page)) continue;
            return next.isCopyContent();
        }
        return false;
    }

    public void createControl(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67584);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setColumnProperties(new String[]{"__name", "__copy__content"});
        ComboBoxCellEditor cellEditor = new ComboBoxCellEditor((Composite)this.fViewer.getTable(), new String[]{Messages.DuplicatePagesFoldersPage_OPTION_YES, Messages.DuplicatePagesFoldersPage_OPTION_NO}, 8);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = cellEditor;
        this.fViewer.setCellEditors(cellEditorArray);
        this.fViewer.setCellModifier((ICellModifier)new TableCellModifier((TableViewer)this.fViewer));
        this.fViewer.setSorter(new ViewerSorter(){
            private final Collator fCollator = CollatorCache.getInstance();

            public int compare(Viewer viewer, Object e1, Object e2) {
                return this.fCollator.compare(((CopyContentWikiPage)e1).getPage().getLabel(), ((CopyContentWikiPage)e2).getPage().getLabel());
            }
        });
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] elements = DuplicatePagesFoldersPage.this.fViewer.getCheckedElements();
                DuplicatePagesFoldersPage.this.fResult.clear();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    DuplicatePagesFoldersPage.this.fResult.add((CopyContentWikiPage)object);
                    ++n2;
                }
            }
        });
        Table table = this.fViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.DuplicatePagesFoldersPage_ASSOCIATED_DATA_LABEL;
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.DuplicatePagesFoldersPage_COLUMN_PAGE);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        column = new TableColumn(table, 16384);
        column.setText(Messages.DuplicatePagesFoldersPage_COLUMN_COPY_CONTENT);
        this.setControl((Control)parent);
        UI.hookHelpListener((Control)parent, "com.ibm.team.apt.ide.ui.dialog_duplicateIterationPlan");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fViewer.getInput() == null) {
            DuplicateIterationPlanWizardPage page = (DuplicateIterationPlanWizardPage)this.getWizard().getPreviousPage((IWizardPage)this);
            ItemList wikiPages = ((DuplicateIterationPlanData)page.getTeamFuture().getResult()).getOrginalIterationPlanData().getWikiPages();
            ArrayList<CopyContentWikiPage> input = new ArrayList<CopyContentWikiPage>(wikiPages.size());
            for (IWikiPage next : wikiPages) {
                CopyContentWikiPage element = new CopyContentWikiPage(next);
                input.add(element);
            }
            this.fViewer.setInput(input);
            this.fViewer.setAllChecked(true);
            this.fViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    CopyContentWikiPage page;
                    Object element = event.getElement();
                    if (element instanceof CopyContentWikiPage && "overview".equals((page = (CopyContentWikiPage)element).getPage().getWikiID())) {
                        DuplicatePagesFoldersPage.this.fViewer.setChecked(element, true);
                    }
                }
            });
            this.fResult.addAll(input);
            this.setPageComplete(true);
        }
    }

    private class CopyContentWikiPage {
        private final IWikiPage fPage;
        private boolean fCopyContent;

        public CopyContentWikiPage(IWikiPage page) {
            this.fPage = page;
            this.fCopyContent = false;
        }

        public IWikiPage getPage() {
            return this.fPage;
        }

        public boolean isCopyContent() {
            return this.fCopyContent;
        }

        public void setCopyContent(boolean copyContent) {
            this.fCopyContent = copyContent;
        }
    }

    private static class TableCellModifier
    implements ICellModifier {
        public static final String NAME = "__name";
        public static final String COPY = "__copy__content";
        private TableViewer fViewer;

        public TableCellModifier(TableViewer viewer) {
            this.fViewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return COPY.equals(property);
        }

        public Object getValue(Object element, String property) {
            if (!COPY.equals(property)) {
                return null;
            }
            if (!(element instanceof CopyContentWikiPage)) {
                return null;
            }
            return ((CopyContentWikiPage)element).isCopyContent() ? 0 : 1;
        }

        public void modify(Object element, String property, Object value) {
            if (!COPY.equals(property)) {
                return;
            }
            if (!(element instanceof TableItem)) {
                return;
            }
            if (!(value instanceof Integer)) {
                return;
            }
            boolean copyContent = ((Integer)value).equals(0);
            CopyContentWikiPage page = (CopyContentWikiPage)((TableItem)element).getData();
            page.setCopyContent(copyContent);
            this.fViewer.update((Object)page, null);
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof CopyContentWikiPage)) {
                return null;
            }
            CopyContentWikiPage page = (CopyContentWikiPage)element;
            switch (columnIndex) {
                case 0: {
                    if ("overview".equals(page.getPage().getWikiID())) {
                        return IterationPlanData.OVERVIEW_PAGE_NAME;
                    }
                    return page.getPage().getLabel();
                }
                case 1: {
                    return page.isCopyContent() ? Messages.DuplicatePagesFoldersPage_OPTION_YES : Messages.DuplicatePagesFoldersPage_OPTION_NO;
                }
            }
            return null;
        }
    }
}

