/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.NewIterationPlanData;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.core.util.Resolver;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.wizards.AbstractIterationPlanWizardPage;
import com.ibm.team.apt.internal.ide.ui.wizards.DuplicateIterationPlanData;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.ProcessNatureSupport;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DuplicateIterationPlanWizardPage
extends AbstractIterationPlanWizardPage<DuplicateIterationPlanData> {
    private static final String PAGE_NAME = String.valueOf(PlanningUIPlugin.getPluginId()) + ".DuplicateIterationPlan";
    private IIterationHandle fCurrentInterval;

    public DuplicateIterationPlanWizardPage(IterationPlanWizardContext context) {
        super(context, PAGE_NAME, Messages.DuplicateIterationPlanWizardPage_DUPLICATE_PLAN, "com.ibm.team.apt.ide.ui.dialog_duplicateIterationPlan");
        this.setDescription(Messages.DuplicateIterationPlanWizardPage_DSC_DUPLICATE_PLAN);
        this.setImageDescriptor(ImagePool.WIZBAN_DUP_ITERATION_PLAN);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setPageComplete(true);
    }

    @Override
    public void computeResult() {
        this.fResult = (IIterationPlanRecord)IIterationPlanRecord.ITEM_TYPE.createItem();
        this.fResult.setName(this.fContext.getName());
        this.fResult.setPlanType(this.fContext.getSelectedPlanType());
        this.fResult.setOwner(this.fContext.getTeamMemberArea());
        this.fResult.setIteration(this.fContext.getIteration());
    }

    @Override
    protected TeamFuture<DuplicateIterationPlanData> computeFuture() {
        TeamFuture future = new TeamFuture((Resolver)new Resolver<DuplicateIterationPlanData>(){

            public DuplicateIterationPlanData resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    monitor.beginTask(Messages.DuplicateIterationPlanWizardPage_MONITOR_LOADING_PLAN_DATA, 100);
                    IItemManager manager = DuplicateIterationPlanWizardPage.this.fContext.getTeamRepository().itemManager();
                    IIterationPlanRecord iterationPlan = (IIterationPlanRecord)manager.fetchCompleteItem((IItemHandle)DuplicateIterationPlanWizardPage.this.fContext.getIterationPlanHandle(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
                    IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)DuplicateIterationPlanWizardPage.this.fContext.getTeamRepository());
                    IterationPlanData data = client.fetchIterationPlanData(DuplicateIterationPlanWizardPage.this.fContext.getIterationPlanHandle(), monitor);
                    DuplicateIterationPlanWizardPage.this.fContext = client.completeAndValidateContext(DuplicateIterationPlanWizardPage.this.fContext, monitor);
                    NewIterationPlanData newIterationPlanData = client.fetchEditIterationPlanData(DuplicateIterationPlanWizardPage.this.fContext.getProjectArea(), iterationPlan.getOwner(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (DuplicateIterationPlanWizardPage.this.fContext.getProjectArea() != null) {
                        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)DuplicateIterationPlanWizardPage.this.fContext.getProjectArea());
                        ProcessNatureSupport support = new ProcessNatureSupport(DuplicateIterationPlanWizardPage.this.fContext.getProjectArea(), (IAuditableCommon)auditableClient);
                        support.initialize(monitor);
                        DuplicateIterationPlanWizardPage.this.fIsTraditional = !support.hidePredecessorLinks();
                    }
                    DuplicateIterationPlanData duplicateIterationPlanData = new DuplicateIterationPlanData(iterationPlan, newIterationPlanData, data);
                    return duplicateIterationPlanData;
                }
                finally {
                    monitor.done();
                }
            }
        });
        return future;
    }

    @Override
    protected void futureResolved(DuplicateIterationPlanData result) {
        this.fCurrentInterval = result.getIterationPlan().getIteration();
        this.setInput(result.getNewIterationPlanData(), result.getIterationPlan());
    }

    @Override
    protected void processSplittedItervals(List<IIteration>[] split) {
        IIteration nextInterval = this.getNextInterval(split);
        if (nextInterval != null) {
            this.fContext.setIteration((IIterationHandle)nextInterval);
        }
    }

    private IIteration getNextInterval(List<IIteration>[] splitted) {
        boolean isCurrent;
        boolean isPast = DuplicateIterationPlanWizardPage.contains(splitted[0], this.fCurrentInterval);
        if (isPast) {
            if (!splitted[1].isEmpty()) {
                return splitted[1].get(0);
            }
            if (!splitted[2].isEmpty()) {
                return splitted[2].get(0);
            }
        }
        if (isCurrent = DuplicateIterationPlanWizardPage.contains(splitted[1], this.fCurrentInterval)) {
            if (!splitted[2].isEmpty()) {
                return splitted[2].get(0);
            }
            return DuplicateIterationPlanWizardPage.getNextInterval(splitted[1], this.fCurrentInterval);
        }
        return DuplicateIterationPlanWizardPage.getNextInterval(splitted[2], this.fCurrentInterval);
    }

    private static boolean contains(List<IIteration> intervals, IIterationHandle interval) {
        int i = 0;
        while (i < intervals.size()) {
            if (interval.sameItemId((IItemHandle)intervals.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IIteration getNextInterval(List<IIteration> intervals, IIterationHandle interval) {
        int i = 0;
        while (i < intervals.size()) {
            if (interval.sameItemId((IItemHandle)intervals.get(i)) && i < intervals.size() - 1) {
                return intervals.get(i + 1);
            }
            ++i;
        }
        return null;
    }
}

