/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.wizards;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.NewIterationPlanData;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.util.IterationClient;
import com.ibm.team.apt.internal.common.IterationPlanNoTeamAreaException;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.ui.util.DisplayRunnable;
import com.ibm.team.apt.internal.ide.ui.util.IterationSelectionDialog;
import com.ibm.team.apt.internal.ide.ui.util.Result;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.util.WizardTeamCallable;
import com.ibm.team.apt.internal.ide.ui.wizards.Messages;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.util.ProcessNatureSupport;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public abstract class AbstractIterationPlanWizardPage<T>
extends WizardPage {
    private static final String TEAM_AREA_KEY = "teamArea";
    private static final String DEV_LINE_KEY = "developmentLine";
    private static final String ITERATION_KEY = "iteration";
    private LocalResourceManager fResources;
    private Text fName;
    private ComboViewer fPlanType;
    private Text fProcessArea;
    private Button fBrowseProcessArea;
    private Text fIteration;
    private Button fBrowseIterations;
    private ExpandableComposite fAdvancedOptions;
    private volatile boolean fInitial = true;
    private boolean fInitialCategorySelection = true;
    protected boolean fHasPermission = true;
    protected IterationPlanWizardContext fContext;
    protected IIterationPlanRecord fResult;
    protected NewIterationPlanData fNewIterationPlanData;
    protected IIterationPlanRecord fCurrentRecord;
    protected TeamFuture<T> fTeamFuture;
    protected boolean fIsTraditional;
    private String fHelpContextId;
    private Button fAlwaysLoadExecutionItems;

    public AbstractIterationPlanWizardPage(IterationPlanWizardContext context, String pageName, String title, String helpContextId) {
        super(pageName, title, null);
        this.fContext = context;
        if (this.fContext.isValid()) {
            this.fTeamFuture = this.computeFuture();
        }
        this.fHelpContextId = helpContextId;
    }

    public IIterationPlanRecord getResult() {
        if (this.fResult == null) {
            new DisplayRunnable(this.getShell().getDisplay()){

                @Override
                public void execute() {
                    AbstractIterationPlanWizardPage.this.computeResult();
                }
            }.syncExec();
        }
        return this.fResult;
    }

    public boolean getAlwaysShowAllExecutionItems() {
        return this.fContext.getAlwaysLoadAllExecutionItems();
    }

    public NewIterationPlanData getInput() {
        return this.fNewIterationPlanData;
    }

    public IterationPlanWizardContext getContext() {
        return this.fContext;
    }

    public abstract void computeResult();

    protected void processSplittedItervals(List<IIteration>[] split) {
    }

    protected void setInput(NewIterationPlanData input, IIterationPlanRecord iterationPlan) {
        IDevelopmentLine contextTimeline;
        List primaryTeamAreaPath;
        Assert.isNotNull((Object)input);
        this.fNewIterationPlanData = input;
        this.fCurrentRecord = iterationPlan;
        if (this.fContext.getName() != null) {
            this.fName.setText(this.fContext.getName());
        }
        this.fHasPermission = input.hasPermission();
        this.fContext.setProjectArea((IProjectAreaHandle)input.getProjectArea());
        List planTypes = input.getPlanTypes();
        if (planTypes != null) {
            this.fContext.setPlanTypes(planTypes);
            this.updatePlanType();
        }
        if ((primaryTeamAreaPath = input.getPrimaryTeamAreaPath()) != null && primaryTeamAreaPath.size() > 0) {
            String buffer = AbstractIterationPlanWizardPage.teamAreaPathToString(primaryTeamAreaPath);
            ITeamArea teamMemberArea = (ITeamArea)primaryTeamAreaPath.get(primaryTeamAreaPath.size() - 1);
            this.fContext.setTeamMemberArea((IProcessAreaHandle)teamMemberArea);
            this.updateProcessArea((IProcessArea)teamMemberArea, String.valueOf(this.getProjectAreaName((IProjectAreaHandle)input.getProjectArea())) + "/" + buffer);
        } else {
            IProjectArea projectArea = input.getProjectArea();
            this.fContext.setTeamMemberArea((IProcessAreaHandle)projectArea);
            this.updateProcessArea((IProcessArea)projectArea, this.getProjectAreaName((IProjectAreaHandle)projectArea));
        }
        IIteration contextIteration = this.fContext.getIteration() instanceof IIteration ? (IIteration)this.fContext.getIteration() : null;
        IDevelopmentLine iDevelopmentLine = contextTimeline = this.fContext.getDevelopmentLineHandle() instanceof IDevelopmentLine ? (IDevelopmentLine)this.fContext.getDevelopmentLineHandle() : null;
        if (contextIteration != null && contextTimeline != null) {
            this.updateSelectedIteration(contextIteration);
        } else {
            IIteration inputIteration = input.getCurrentIteration();
            IDevelopmentLine inputTimeline = input.getDevelopmentLine();
            if (inputIteration != null && inputTimeline != null && contextTimeline != null && contextTimeline.sameItemId((IItemHandle)inputTimeline)) {
                this.fContext.setDevelopmentLineHandle((IDevelopmentLineHandle)inputTimeline);
                this.fContext.setIteration((IIterationHandle)inputIteration);
                this.updateSelectedIteration(inputIteration);
            }
        }
        this.fAlwaysLoadExecutionItems.setSelection(this.fContext.getAlwaysLoadAllExecutionItems());
        this.fName.setFocus();
        this.updateStatus();
    }

    public void setVisible(boolean visible) {
        if (this.fInitial) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractIterationPlanWizardPage.this.updateFromContext();
                    AbstractIterationPlanWizardPage.this.fInitial = false;
                }
            });
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.createNamePart(composite);
        this.createProcessArea(composite);
        this.createIterationPart(composite);
        this.createAdvancedPart(composite);
        this.updateStatus();
        Dialog.applyDialogFont((Control)parent);
        if (this.fHelpContextId != null) {
            UI.hookHelpListener((Control)composite, this.fHelpContextId);
        }
    }

    private void createNamePart(Composite result) {
        this.createLabel(result, Messages.AbstractIterationPlanWizardPage_PLAN_NAME);
        this.fName = new Text(result, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        this.fName.setLayoutData((Object)gd);
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractIterationPlanWizardPage.this.fContext.setName(AbstractIterationPlanWizardPage.this.fName.getText());
                AbstractIterationPlanWizardPage.this.updateStatus();
            }
        });
    }

    private void createProcessArea(Composite parent) {
        this.createLabel(parent, Messages.AbstractIterationPlanWizardPage_OWNER);
        this.fProcessArea = new Text(parent, 2056);
        this.fProcessArea.setBackground(parent.getBackground());
        GridData gd = new GridData(768);
        this.fProcessArea.setLayoutData((Object)gd);
        this.fBrowseProcessArea = new Button(parent, 0);
        this.fBrowseProcessArea.setText(Messages.AbstractIterationPlanWizardPage_BROWSE_PROJECT_AREA);
        this.fBrowseProcessArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessAreaSelectionDialog tasd = new ProcessAreaSelectionDialog(AbstractIterationPlanWizardPage.this.getShell(), false);
                tasd.setInput((Object)AbstractIterationPlanWizardPage.this.fContext.getTeamRepository());
                if (tasd.open() == 0) {
                    AbstractIterationPlanWizardPage.this.deferredUpdateProcessArea((IProcessAreaHandle)tasd.getSelectedProcessArea());
                }
            }
        });
    }

    private void createIterationPart(Composite parent) {
        this.createLabel(parent, Messages.AbstractIterationPlanWizardPage_LABEL_ITERATION);
        this.fIteration = new Text(parent, 2056);
        this.fIteration.setBackground(parent.getBackground());
        this.fIteration.setLayoutData((Object)new GridData(768));
        this.fBrowseIterations = new Button(parent, 8);
        this.fBrowseIterations.setText(Messages.AbstractIterationPlanWizardPage_BROWSE_ITERATION);
        this.fBrowseIterations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IterationSelectionDialog dialog = new IterationSelectionDialog(AbstractIterationPlanWizardPage.this.getShell(), AbstractIterationPlanWizardPage.this.fContext.getIteration(), true);
                dialog.setInput(AbstractIterationPlanWizardPage.this.fContext.getTeamMemberArea());
                switch (dialog.open()) {
                    case 0: {
                        AbstractIterationPlanWizardPage.this.deferredUpdateSelectedIteration((IIteration)dialog.getResult()[0]);
                    }
                }
            }
        });
    }

    private void createAdvancedPart(Composite parent) {
        this.fAdvancedOptions = new ExpandableComposite(parent, 0, 18);
        this.fAdvancedOptions.setText(Messages.AbstractIterationPlanWizardPage_ADVANCED_OPTIONS);
        Composite client = new Composite((Composite)this.fAdvancedOptions, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).margins(0, 0).applyTo(client);
        this.fAdvancedOptions.setClient((Control)client);
        this.createPlanTypePart(client);
        this.fAlwaysLoadExecutionItems = new Button(client, 32);
        this.fAlwaysLoadExecutionItems.setText(Messages.AbstractIterationPlanWizardPage_ALWAYS_LOAD_EXECUTION_ITEMS);
        this.fAlwaysLoadExecutionItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractIterationPlanWizardPage.this.fContext.setAlwaysLoadAllExecutionItems(AbstractIterationPlanWizardPage.this.fAlwaysLoadExecutionItems.getSelection());
            }
        });
        GridDataFactory.swtDefaults().span(3, 0).applyTo((Control)this.fAlwaysLoadExecutionItems);
        this.fAdvancedOptions.setExpanded(true);
        Point size = this.fAdvancedOptions.computeSize(-1, -1);
        GridDataFactory.fillDefaults().span(3, 0).grab(true, true).hint(-1, size.y).applyTo((Control)this.fAdvancedOptions);
        this.fAdvancedOptions.setExpanded(false);
    }

    private void createPlanTypePart(Composite result) {
        this.createLabel(result, Messages.AbstractIterationPlanWizardPage_LABEL_PLAN_TYPE);
        Composite parent = new Composite(result, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        final Label image = new Label(parent, 0);
        GridDataFactory.swtDefaults().hint(16, 16).applyTo((Control)image);
        this.fPlanType = new ComboViewer(parent, 12);
        GridDataFactory.fillDefaults().hint(this.convertWidthInCharsToPixels(40), -1).grab(true, false).applyTo(this.fPlanType.getControl());
        this.fPlanType.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                List planType = (List)inputElement;
                ArrayList<IPlanType> result = new ArrayList<IPlanType>();
                if (planType != null) {
                    for (IPlanType type : planType) {
                        if (type.isDeprecated() != null && type.isDeprecated().length() > 0 && (AbstractIterationPlanWizardPage.this.fIsTraditional || !"com.ibm.team.tempo.plantype.iteration".equals(type.getId()))) continue;
                        result.add(type);
                    }
                }
                return result.toArray();
            }
        });
        this.fPlanType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IPlanType)element).getDisplayName();
            }
        });
        this.fPlanType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof IPlanType) {
                    IPlanType planType = (IPlanType)element;
                    image.setImage(AbstractIterationPlanWizardPage.this.fResources.createImage(PlanningUI.getImageDescriptor(planType)));
                    AbstractIterationPlanWizardPage.this.fContext.setSelectedPlanType(planType.getId());
                    AbstractIterationPlanWizardPage.this.updateStatus();
                }
            }
        });
    }

    private Label createLabel(Composite result, String text) {
        Label label = new Label(result, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(text);
        return label;
    }

    private String getProjectAreaName(IProjectAreaHandle projectArea) {
        return ProjectAreaPicker.getUnambiguousProjectName((List)ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true), (IProjectAreaHandle)projectArea);
    }

    private void updateFromContext() {
        this.updatePlanType();
        this.resolveFuture();
    }

    protected void updateStatus() {
        boolean pageComplete;
        String message = null;
        int type = 3;
        boolean forceError = false;
        if (this.fContext.getName() == null || this.fContext.getName().length() == 0) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_PROVIDE_NAME;
            type = 0;
        } else if (this.fContext.getName().trim().length() == 0) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_NAME_NOT_EMPTY;
        } else if (this.fContext.getSelectedPlanType() == null) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_SELECT_PLAN_TYPE;
        } else if (this.fContext.getProjectArea() == null) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_PROVIDE_PROJECT_AREA;
        } else if (this.fContext.getTeamMemberArea() == null) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_PROVIDE_TEAM_AREA;
        } else if (this.fContext.getIteration() == null) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_PROVIDE_ITERATION;
        } else {
            IIteration iteration = this.fContext.getIteration() instanceof IIteration ? (IIteration)this.fContext.getIteration() : null;
            IDevelopmentLineHandle devLine = this.fContext.getDevelopmentLineHandle();
            if (iteration != null && devLine != null && !devLine.sameItemId((IItemHandle)iteration.getDevelopmentLine())) {
                forceError = true;
                message = this.fContext.getTeamMemberArea() instanceof ITeamAreaHandle ? Messages.AbstractIterationPlanWizardPage_MSG_ITERATION_TEAM_AREA_MISMATCH : Messages.AbstractIterationPlanWizardPage_MSG_ITERATION_TIMELINE_MISMATCH;
            }
        }
        boolean bl = pageComplete = message == null;
        if (!this.fHasPermission && message == null) {
            message = Messages.AbstractIterationPlanWizardPage_MSG_NO_PERMISSIONS;
            type = 1;
            pageComplete = true;
        } else if ((this.fInitial || this.fInitialCategorySelection) && !forceError) {
            type = 0;
        }
        this.setMessage(message, type);
        this.setPageComplete(pageComplete);
    }

    public void setErrorMessage(String msg) {
        this.setMessage(msg, 3);
    }

    public TeamFuture<T> getTeamFuture() {
        return this.fTeamFuture;
    }

    protected abstract TeamFuture<T> computeFuture();

    protected abstract void futureResolved(T var1);

    protected void resolveFuture() {
        Result result = new WizardTeamCallable<T>(){

            @Override
            protected T execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.AbstractIterationPlanWizardPage_MONITOR_FETCHING_DATA, -1);
                if (AbstractIterationPlanWizardPage.this.fTeamFuture == null) {
                    AbstractIterationPlanWizardPage.this.fTeamFuture = AbstractIterationPlanWizardPage.this.computeFuture();
                }
                Object result = AbstractIterationPlanWizardPage.this.fTeamFuture.joinResult(0);
                monitor.done();
                return result;
            }

            @Override
            public void handleTeamRepositoryException(IStatus status, TeamRepositoryException e) {
                if (e instanceof IterationPlanNoTeamAreaException) {
                    AbstractIterationPlanWizardPage.this.setMessage(e.getMessage(), 3);
                    ControlEnableState.disable((Control)AbstractIterationPlanWizardPage.this.getControl());
                    AbstractIterationPlanWizardPage.this.setPageComplete(false);
                } else {
                    super.handleTeamRepositoryException(status, e);
                }
            }
        }.execute(this, true, true, Messages.AbstractIterationPlanWizardPage_VALIDATING_PROJECT_AREA);
        if (result.isOK()) {
            this.futureResolved(result.getResult());
            this.updateStatus();
        }
    }

    private void updateProcessArea(IProcessArea area, String hoverLabel) {
        this.fContext.setTeamMemberArea((IProcessAreaHandle)area);
        if (area == null) {
            this.fProcessArea.setText("");
            this.fProcessArea.setToolTipText("");
        } else {
            this.fProcessArea.setText(area.getName());
            this.fProcessArea.setToolTipText(hoverLabel);
        }
    }

    private void deferredUpdateProcessArea(final IProcessAreaHandle handle) {
        this.fContext.setTeamMemberArea(handle);
        new WizardTeamCallable<1Result>(){

            @Override
            protected 1Result execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                class Result {
                    public volatile List<IPlanType> planTypes;
                    public volatile IProcessArea processArea;
                    public volatile boolean hasPermission;
                    public volatile String hoverLabel;
                    public volatile IDevelopmentLine timeline;
                    public volatile IIteration iteration;
                    public volatile IPlanType planType;
                    public volatile boolean isTraditional;

                    Result() {
                    }
                }
                Result result = new Result();
                ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)handle);
                IItemManager manager = repository.itemManager();
                result.processArea = (IProcessArea)manager.fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IProjectArea pa = (IProjectArea)manager.fetchCompleteItem((IItemHandle)result.processArea.getProjectArea(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)handle);
                IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)result.processArea);
                IAuditableCommonProcess processCommon = auditableClient.getProcess((IProcessAreaHandle)pa, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ProcessNatureSupport support = new ProcessNatureSupport((IProjectAreaHandle)pa, (IAuditableCommon)auditableClient);
                support.initialize(monitor);
                result.isTraditional = !support.hidePredecessorLinks();
                result.planTypes = client.findPlanTypes(processCommon, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                result.hasPermission = client.checkPermission((IProcessAreaHandle)result.processArea, "com.ibm.team.apt.server.saveIterationPlan", "modify/plan", monitor);
                String paName = AbstractIterationPlanWizardPage.this.getProjectAreaName((IProjectAreaHandle)pa);
                IDevelopmentLine line = null;
                if (result.processArea instanceof IProjectArea) {
                    result.hoverLabel = paName;
                    IDevelopmentLineHandle handle2 = null;
                    if (pa.getProjectDevelopmentLine() != null) {
                        handle2 = pa.getProjectDevelopmentLine();
                    } else if (pa.getDevelopmentLines().length == 1) {
                        handle2 = pa.getDevelopmentLines()[0];
                    }
                    if (handle2 != null) {
                        line = (IDevelopmentLine)manager.fetchCompleteItem((IItemHandle)handle2, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                } else {
                    ITeamArea teamArea = (ITeamArea)result.processArea;
                    result.hoverLabel = String.valueOf(paName) + "/" + AbstractIterationPlanWizardPage.teamAreaToString(teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ITeamAreaHierarchy teamAreaHierarchy = pa.getTeamAreaHierarchy();
                    line = (IDevelopmentLine)manager.fetchCompleteItem((IItemHandle)teamAreaHierarchy.getDevelopmentLine((ITeamAreaHandle)teamArea), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (line != null) {
                    result.timeline = line;
                    result.iteration = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (result.iteration != null) {
                    result.planType = client.fetchPlanType(AbstractIterationPlanWizardPage.this.fContext.getTeamMemberArea(), (IIterationHandle)result.iteration, monitor);
                }
                return result;
            }

            @Override
            protected void processResult(1Result result) {
                if (!result.processArea.getProjectArea().sameItemId((IItemHandle)AbstractIterationPlanWizardPage.this.fContext.getProjectArea())) {
                    AbstractIterationPlanWizardPage.this.fContext.setPlanTypes(result.planTypes);
                    AbstractIterationPlanWizardPage.this.updatePlanType();
                }
                AbstractIterationPlanWizardPage.this.fHasPermission = result.hasPermission;
                AbstractIterationPlanWizardPage.this.fIsTraditional = result.isTraditional;
                AbstractIterationPlanWizardPage.this.updateProcessArea(result.processArea, result.hoverLabel);
                AbstractIterationPlanWizardPage.this.fContext.setDevelopmentLineHandle((IDevelopmentLineHandle)result.timeline);
                AbstractIterationPlanWizardPage.this.updateSelectedIteration(result.iteration);
                AbstractIterationPlanWizardPage.this.updatePlanType(result.planType);
                AbstractIterationPlanWizardPage.this.updateStatus();
            }
        }.execute(this, true, true, Messages.AbstractIterationPlanWizardPage_JOB_UPDATE_PROJECT_AREA);
    }

    private void updateSelectedIteration(IIteration iteration) {
        if (iteration == null) {
            this.fContext.setIteration(null);
            this.fIteration.setData(null);
            this.fIteration.setText("");
        } else {
            this.fContext.setIteration((IIterationHandle)iteration);
            this.fIteration.setData((Object)iteration);
            this.fIteration.setText(iteration.getLabel());
        }
    }

    private void deferredUpdateSelectedIteration(final IIteration iteration) {
        this.updateSelectedIteration(iteration);
        new WizardTeamCallable<2Result>(){

            @Override
            protected 2Result execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                class Result {
                    public volatile IPlanType planType;

                    Result() {
                    }
                }
                Result result = new Result();
                IIterationPlanClient iterationPlanClient = PlanningClientPlugin.getIterationPlanClient((IItemHandle)iteration);
                result.planType = iterationPlanClient.fetchPlanType(AbstractIterationPlanWizardPage.this.fContext.getTeamMemberArea(), (IIterationHandle)iteration, monitor);
                return result;
            }

            @Override
            protected void processResult(2Result result) {
                AbstractIterationPlanWizardPage.this.updatePlanType(result.planType);
                AbstractIterationPlanWizardPage.this.updateStatus();
            }
        }.execute(this, true, true, Messages.AbstractIterationPlanWizardPage_JOB_UPDATE_ITERATION);
    }

    private void updatePlanType() {
        List planTypes = this.fContext.getPlanTypes();
        String selectedPlanType = this.fContext.getSelectedPlanType();
        if (planTypes != null && !planTypes.isEmpty()) {
            this.fPlanType.setInput((Object)this.fContext.getPlanTypes());
            StructuredSelection selection = null;
            if (selectedPlanType != null) {
                for (IPlanType planType : planTypes) {
                    if (!planType.getId().equals(selectedPlanType)) continue;
                    selection = new StructuredSelection((Object)planType);
                    break;
                }
            }
            if (selection != null) {
                this.fPlanType.setSelection(selection);
            } else {
                this.fContext.setSelectedPlanType(null);
            }
        } else {
            this.fPlanType.setInput(null);
        }
    }

    private void updatePlanType(IPlanType planType) {
        if (planType == null) {
            this.fContext.setSelectedPlanType(null);
            this.fPlanType.setSelection(null);
        } else {
            this.fContext.setSelectedPlanType(planType.getId());
            StructuredSelection selection = new StructuredSelection((Object)planType);
            this.fPlanType.setSelection((ISelection)selection);
        }
    }

    private static String teamAreaPathToString(List<ITeamArea> primaryTeamAreaPath) {
        StringBuffer buffer = new StringBuffer();
        for (ITeamArea teamArea : primaryTeamAreaPath) {
            buffer.append(teamArea.getName()).append('/');
        }
        return buffer.deleteCharAt(buffer.length() - 1).toString();
    }

    private static String teamAreaToString(ITeamArea teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        StringBuilder result = new StringBuilder();
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)teamArea).itemManager();
        IProjectArea projectArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 0, monitor);
        ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
        AbstractIterationPlanWizardPage.teamAreaToString(result, teamArea, hierarchy, manager, monitor);
        result.trimToSize();
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    private static void teamAreaToString(StringBuilder result, ITeamArea teamArea, ITeamAreaHierarchy hierarchy, IItemManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamAreaHandle parent = hierarchy.getParent((ITeamAreaHandle)teamArea);
        if (parent != null) {
            ITeamArea resolvedParent = (ITeamArea)manager.fetchCompleteItem((IItemHandle)parent, 0, monitor);
            AbstractIterationPlanWizardPage.teamAreaToString(result, resolvedParent, hierarchy, manager, monitor);
        }
        result.append(teamArea.getName());
        result.append("/");
    }
}

