/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class Transformation {
    private int fOffsetX;
    private int fOffsetY;

    public Transformation(int offsetX, int offsetY) {
        this.fOffsetX = offsetX;
        this.fOffsetY = offsetY;
    }

    void set(int x, int y) {
        this.fOffsetX = x;
        this.fOffsetY = y;
    }

    void setX(int x) {
        this.fOffsetX = x;
    }

    void moveX(int deltaX) {
        this.fOffsetX = Math.max(0, this.fOffsetX + deltaX);
    }

    void setY(int y) {
        this.fOffsetY = y;
    }

    void moveY(int deltaY) {
        this.fOffsetY = Math.max(0, this.fOffsetY + deltaY);
    }

    public int getX() {
        return this.fOffsetX;
    }

    public int getY() {
        return this.fOffsetY;
    }

    public int toPaneX(int x) {
        return x + this.fOffsetX;
    }

    public int toPaneY(int y) {
        return y + this.fOffsetY;
    }

    public Point toPane(int x, int y) {
        return new Point(x + this.fOffsetX, y + this.fOffsetY);
    }

    public Point toPane(Point p) {
        return new Point(p.x + this.fOffsetX, p.y + this.fOffsetY);
    }

    public Rectangle toPane(Rectangle r) {
        return new Rectangle(r.x + this.fOffsetX, r.y + this.fOffsetY, r.width, r.height);
    }

    public Rectangle toPane(int x, int y, int width, int height) {
        return new Rectangle(x + this.fOffsetX, y + this.fOffsetY, width, height);
    }

    public Point toViewPort(int x, int y) {
        return new Point(x - this.fOffsetX, y - this.fOffsetY);
    }

    public Point toViewPort(Point p) {
        return new Point(p.x - this.fOffsetX, p.y - this.fOffsetY);
    }

    public Rectangle toViewPort(Rectangle r) {
        return new Rectangle(r.x - this.fOffsetX, r.y - this.fOffsetY, r.width, r.height);
    }

    public Rectangle toViewPort(int x, int y, int width, int height) {
        return new Rectangle(x - this.fOffsetX, y - this.fOffsetY, width, height);
    }

    public Object beginOverlay(int x, int y) {
        int[] result = new int[]{this.fOffsetX, this.fOffsetY};
        this.set(x, y);
        return result;
    }

    public void endOverlay(Object stateObject) {
        int[] state = (int[])stateObject;
        this.set(state[0], state[1]);
    }
}

