/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class TextFonts {
    private Device fDevice;
    private Font fNormalFont;
    private Font fBoldFont;
    private Font fItalicFont;
    private Font fBoldItalicFont;

    public TextFonts(Font normalFont) {
        this.fDevice = normalFont.getDevice();
        this.fNormalFont = normalFont;
    }

    public void dispose() {
        if (this.fBoldFont != null) {
            this.fBoldFont.dispose();
        }
        if (this.fItalicFont != null) {
            this.fItalicFont.dispose();
        }
        if (this.fBoldItalicFont != null) {
            this.fBoldItalicFont.dispose();
        }
    }

    public Font getNormalFont() {
        return this.fNormalFont;
    }

    public Font getBoldFont() {
        if (this.fBoldFont != null) {
            return this.fBoldFont;
        }
        FontData[] bold = this.getModifiedFontData(1);
        this.fBoldFont = new Font(this.fDevice, bold);
        return this.fBoldFont;
    }

    public Font getItalicFont() {
        if (this.fItalicFont != null) {
            return this.fItalicFont;
        }
        FontData[] italic = this.getModifiedFontData(2);
        this.fItalicFont = new Font(this.fDevice, italic);
        return this.fItalicFont;
    }

    public Font getBoldItalicFont() {
        if (this.fBoldItalicFont != null) {
            return this.fBoldItalicFont;
        }
        FontData[] boldItalic = this.getModifiedFontData(3);
        this.fBoldItalicFont = new Font(this.fDevice, boldItalic);
        return this.fBoldItalicFont;
    }

    public Font getStyledFont(int style) {
        boolean isItalic;
        boolean isBold = (style & 1) != 0;
        boolean bl = isItalic = (style & 2) != 0;
        if (isBold && isItalic) {
            return this.getBoldItalicFont();
        }
        if (isBold) {
            return this.getBoldFont();
        }
        if (isItalic) {
            return this.getItalicFont();
        }
        return this.getNormalFont();
    }

    private FontData[] getModifiedFontData(int style) {
        FontData[] baseData = this.fNormalFont.getFontData();
        FontData[] styleData = new FontData[baseData.length];
        int i = 0;
        while (i < styleData.length) {
            FontData base = baseData[i];
            styleData[i] = new FontData(base.getName(), base.getHeight(), base.getStyle() | style);
            ++i;
        }
        return styleData;
    }
}

