/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextFonts;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public class OutlineResources {
    private LocalResourceManager fResourceManager;
    private FormColors fFormColors;
    private StandardLabelProvider fStandardLabelProvider;
    private TextFonts fTextFonts;
    private TextLayout fTextLayout;
    private int fSpaceWidth;
    private FontMetrics fFontMetrics;
    private Rectangle fPaintPaneBounds;
    private Insets fTreeNodeInsets;
    private Color fLinkColor;
    private Color fSelectionColor;
    private int fSelectionAlpha;
    private int fDropUnderFeedbackAlpha;
    private Color fSelectionBorderColor;
    private Color fInsertionMarkColor;
    private Color fTwistieColor;
    private int fInsertionMarkLineWidth;
    private int fInsertionMarkEndingWidth;
    private final Color fGroupStroke1Color;
    private final Color fGroupHighlightColor;
    private final Color fGroupGradientStartColor;
    private final Color fGroupGradientEndColor;
    private final Color fGroupStroke2Color;
    private final Color fGroupStroke3Color;
    private final Color[] fProbabilityColors;
    private final Color fSubHeadingStart;
    private final Color fSubHeadingMain;
    private final Color fSubHeadingEnd;
    private Color fDropDownTriangleColor;
    private Color fHoverHightlightColor;
    private Image fFatalErrorImage;
    private Image fErrorImage;
    private Image fWarningImage;
    private Image fInfoImage;
    private Image fDoesNotBelongToImage;
    private Image fPinnedItemImage;
    public boolean debugLayout = false;

    public OutlineResources(Control control) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), control);
        this.fFormColors = new FormColors(control.getDisplay());
        this.fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        Font font = control.getFont();
        GC gc = null;
        try {
            gc = new GC((Drawable)control);
            gc.setFont(font);
            this.fFontMetrics = gc.getFontMetrics();
            this.fSpaceWidth = gc.getCharWidth(' ');
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        this.fTextFonts = new TextFonts(font);
        this.fTextLayout = new TextLayout((Device)control.getDisplay());
        this.fTextLayout.setFont(this.fTextFonts.getNormalFont());
        int topBottom = (int)((double)this.getFontMetrics().getHeight() * 0.333);
        this.fTreeNodeInsets = new Insets(topBottom, 4, topBottom, 4);
        RGB listSelection = this.getSystemColor(26);
        this.fSelectionColor = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)this.getSystemColor(26));
        this.fSelectionAlpha = FormColors.testTwoPrimaryColors((RGB)listSelection, (int)0, (int)120) ? 60 : 50;
        this.fDropUnderFeedbackAlpha = this.fSelectionAlpha / 2;
        this.fSelectionBorderColor = JazzResources.getColor((ResourceManager)this.fResourceManager, (ColorDescriptor)ColorDescriptor.createFrom((RGB)FormColors.blend((RGB)listSelection, (RGB)new RGB(255, 255, 255), (int)60)));
        this.fInsertionMarkColor = this.fResourceManager.getDevice().getSystemColor(2);
        this.fInsertionMarkLineWidth = 2;
        this.fInsertionMarkEndingWidth = 6;
        this.fDropDownTriangleColor = this.getFormColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fHoverHightlightColor = this.blend(26, 25, 50);
        this.fLinkColor = JFaceColors.getHyperlinkText((Display)control.getDisplay());
        this.fFatalErrorImage = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.FATALERROR_OVR);
        this.fErrorImage = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.ERROR_ANNOTATION);
        this.fWarningImage = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.WARNING_ANNOTATION);
        this.fInfoImage = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.INFO_ANNOTATION);
        this.fDoesNotBelongToImage = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.DOES_NOT_BELONG_TO);
        this.fPinnedItemImage = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.PINNED_ITEM);
        this.fTwistieColor = this.getFormColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fGroupStroke1Color = this.blend(18, 22, 60);
        this.fGroupHighlightColor = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)this.getSystemColor(1));
        this.fGroupGradientStartColor = this.blend(22, 25, 70);
        this.fGroupGradientEndColor = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)this.getSystemColor(22));
        this.fGroupStroke2Color = this.blend(18, 22, 80);
        this.fGroupStroke3Color = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)this.getSystemColor(25));
        this.fProbabilityColors = new Color[]{this.fResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(250, 233, 233))), this.fResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(242, 198, 198))), this.fResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(234, 163, 163))), this.fResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(226, 128, 128))), this.fResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(219, 93, 93))), this.fResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(211, 58, 58))), this.fResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(202, 23, 23))), this.fResourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(198, 0, 0)))};
        this.fSubHeadingStart = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)this.getSystemColor(22));
        this.fSubHeadingMain = this.blend(22, 25, 20);
        this.fSubHeadingEnd = JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)this.getSystemColor(25));
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OutlineResources.this.dispose();
            }
        });
    }

    protected void dispose() {
        this.fTextLayout.dispose();
        this.fTextFonts.dispose();
        this.fFormColors.dispose();
        this.fStandardLabelProvider.dispose();
    }

    public LocalResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    public Image getImage(ImageDescriptor descriptor) {
        return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)descriptor);
    }

    protected FormColors getFormColors() {
        return this.fFormColors;
    }

    public StandardLabelProvider getStandardLabelProvider() {
        return this.fStandardLabelProvider;
    }

    public Rectangle getPaintPaneBounds() {
        return this.fPaintPaneBounds;
    }

    public void setPaintPaneBounds(Rectangle paintPaneBounds) {
        this.fPaintPaneBounds = paintPaneBounds;
    }

    public int getSpaceWidth() {
        return this.fSpaceWidth;
    }

    public FontMetrics getFontMetrics() {
        return this.fFontMetrics;
    }

    public TextFonts getTextFonts() {
        return this.fTextFonts;
    }

    public TextLayout getTextLayout() {
        this.fTextLayout.setAscent(-1);
        this.fTextLayout.setDescent(-1);
        this.fTextLayout.setWidth(-1);
        this.fTextLayout.setText("");
        this.fTextLayout.setFont(this.fTextFonts.getNormalFont());
        this.fTextLayout.setAlignment(16384);
        return this.fTextLayout;
    }

    public Insets getTreeNodeInsets() {
        return this.fTreeNodeInsets;
    }

    public int getTwistieSpacing() {
        return 4;
    }

    public int getMinimalTextWidth() {
        return 150;
    }

    public Color getBulletColor() {
        return this.getFormColors().getBorderColor();
    }

    public Color getHoverHightlightColor() {
        return this.fHoverHightlightColor;
    }

    public Color getDropDownTriangleColor() {
        return this.fDropDownTriangleColor;
    }

    public Color getSubHeadingStart() {
        return this.fSubHeadingStart;
    }

    public Color getSubHeadingMain() {
        return this.fSubHeadingMain;
    }

    public Color getSubHeadingEnd() {
        return this.fSubHeadingEnd;
    }

    public Color getGroupStroke1Color() {
        return this.fGroupStroke1Color;
    }

    public Color getGroupHighlightColor() {
        return this.fGroupHighlightColor;
    }

    public Color getGroupGradientStartColor() {
        return this.fGroupGradientStartColor;
    }

    public Color getGroupGradientEndColor() {
        return this.fGroupGradientEndColor;
    }

    public Color getGroupStroke2Color() {
        return this.fGroupStroke2Color;
    }

    public Color getGroupStroke3Color() {
        return this.fGroupStroke3Color;
    }

    public Color getSelectionColor() {
        return this.fSelectionColor;
    }

    public int getSelectionAlpha() {
        return this.fSelectionAlpha;
    }

    public int getDropUnderFeedbackAlpha() {
        return this.fDropUnderFeedbackAlpha;
    }

    public Color getSelectionBorderColor() {
        return this.fSelectionBorderColor;
    }

    public Color getInsertionMarkColor() {
        return this.fInsertionMarkColor;
    }

    public int getInsertionMarkLineWidth() {
        return this.fInsertionMarkLineWidth;
    }

    public int getInsertionMarkEndingLength() {
        return this.fInsertionMarkEndingWidth;
    }

    public Color getLinkColor() {
        return this.fLinkColor;
    }

    public Image getFatalErrorImage() {
        return this.fFatalErrorImage;
    }

    public Image getErrorImage() {
        return this.fErrorImage;
    }

    public Image getWarningImage() {
        return this.fWarningImage;
    }

    public Image getInfoImage() {
        return this.fInfoImage;
    }

    public Image getDoesNotBelongToImage() {
        return this.fDoesNotBelongToImage;
    }

    public Image getPinnedItemImage() {
        return this.fPinnedItemImage;
    }

    public Color getTwistieColor() {
        return this.fTwistieColor;
    }

    public Point getTwistieSize() {
        return new Point(7, 4);
    }

    protected RGB getSystemColor(int code) {
        return this.fResourceManager.getDevice().getSystemColor(code).getRGB();
    }

    public Color blend(int c1, int c2, int ratio) {
        return this.fResourceManager.createColor(FormColors.blend((RGB)this.getSystemColor(c1), (RGB)this.getSystemColor(c2), (int)ratio));
    }

    public int getChildIndent() {
        return 16;
    }

    public final boolean isSingleClickMode() {
        return (OpenStrategy.getOpenMethod() & 1) != 0;
    }

    public Color[] getProbabilityColors() {
        return this.fProbabilityColors;
    }
}

