/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.RedrawContext;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ResizeMode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.RootItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Transformation;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public abstract class OutlineItem
extends Item
implements IEventHandler,
IGObject {
    static final int UNUSED = Integer.MIN_VALUE;
    static final OutlineItem[] NO_ITEMS = new OutlineItem[0];
    OutlineItem fParent;
    OutlineItem[] fChildren;
    boolean fExpanded;
    Rectangle fBounds = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    private boolean fShowTreeUnderlay;

    public OutlineItem(Outline outline, int style) {
        this(outline.getRootItem(), style, -1);
    }

    public OutlineItem(Outline outline, int style, int index) {
        this(outline.getRootItem(), style, index);
    }

    public OutlineItem(OutlineItem parent, int style) {
        this(parent, style, -1);
    }

    public OutlineItem(OutlineItem parent, int style, int index) {
        super((Widget)parent, style);
        this.fParent = parent;
        this.fChildren = NO_ITEMS;
        parent.addItem(this, index, true);
    }

    protected OutlineItem(Outline outline, int style, Class clazz) {
        super((Widget)outline, style);
        this.fChildren = NO_ITEMS;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        int deltaHeight = 0;
        if (this.isLayouted() && this.getHeight() > 0 && !this.getOutline().isLayoutDeferred()) {
            deltaHeight = -this.getHeight();
            RedrawContext redraw = new RedrawContext();
            redraw.add(this);
            this.fBounds.width = 0;
            this.fBounds.height = 0;
            this.fParent.resized(this, 0, deltaHeight, this, redraw);
        }
        this.fParent.destroyItem(this);
        this.disposeItem();
    }

    protected void disposeItem() {
        if (this.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.fChildren.length) {
            this.fChildren[i].disposeItem();
            ++i;
        }
        super.dispose();
        this.fParent = null;
        this.fChildren = NO_ITEMS;
        this.fBounds = null;
    }

    @Override
    public Object getElement() {
        return this.getData();
    }

    public TreePath getTreePath() {
        ArrayList<Object> reverseSegmentList = new ArrayList<Object>();
        OutlineItem item = this;
        while (item != null) {
            reverseSegmentList.add(item.getData());
            item = item.getParent();
        }
        Object[] segments = new Object[reverseSegmentList.size()];
        int i = 0;
        while (i < reverseSegmentList.size()) {
            segments[segments.length - i - 1] = reverseSegmentList.get(i);
            ++i;
        }
        return new TreePath(segments);
    }

    public boolean isLabelProperty(String property) {
        GShell content = this.getContent();
        return content != null ? content.isLabelProperty(property) : true;
    }

    public OutlineItem getRoot() {
        OutlineItem result = this;
        while (result.fParent != null) {
            result = result.fParent;
        }
        return result;
    }

    public Outline getOutline() {
        OutlineItem root = this.getRoot();
        if (root != this) {
            return root.getOutline();
        }
        return this.getOutline();
    }

    public OutlineItem getParent() {
        if (this.fParent instanceof RootItem) {
            return null;
        }
        return this.fParent;
    }

    @Override
    public IEventHandler getParentHandler() {
        return this.fParent;
    }

    protected OutlineItem getParentIncludingRoot() {
        return this.fParent;
    }

    @Override
    public OutlineItem getOutlineItem() {
        return this;
    }

    public OutlineItem[] getItems() {
        return (OutlineItem[])this.fChildren.clone();
    }

    public OutlineItem getItem(int index) {
        return this.fChildren[index];
    }

    public int getItemCount() {
        return this.fChildren.length;
    }

    public int indexOf(OutlineItem child) {
        int i = 0;
        while (i < this.fChildren.length) {
            if (child == this.fChildren[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isFirstChild(OutlineItem child) {
        if (this.fChildren.length == 0) {
            return false;
        }
        return this.fChildren[0] == child;
    }

    public boolean isLastChild(OutlineItem child) {
        if (this.fChildren.length == 0) {
            return false;
        }
        return this.fChildren[this.fChildren.length - 1] == child;
    }

    private void addItem(OutlineItem item, int index, boolean layout) {
        int width;
        Assert.isLegal((item.fParent == this ? 1 : 0) != 0);
        OutlineItem[] newChildren = new OutlineItem[this.fChildren.length + 1];
        if (index == -1) {
            System.arraycopy(this.fChildren, 0, newChildren, 0, this.fChildren.length);
            index = this.fChildren.length;
            newChildren[index] = item;
            this.fChildren = newChildren;
        } else {
            System.arraycopy(this.fChildren, 0, newChildren, 0, index);
            newChildren[index] = item;
            System.arraycopy(this.fChildren, index, newChildren, index + 1, this.fChildren.length - index);
            this.fChildren = newChildren;
        }
        if (!layout || !this.isLayouted() || !this.fExpanded || this.getOutline().isLayoutDeferred()) {
            return;
        }
        if (this.fChildren.length == 1 && this.getContent() != null) {
            this.getOutline().redraw(this.getContent(), false);
        }
        if ((width = item.computeMinimumWidth()) <= this.getWidth()) {
            if (index == 0) {
                Insets insets = this.getInsets();
                GShell content = this.getContent();
                int contentHeight = content != null && content.isLayouted() ? content.getHeight() : 0;
                item.layout(this.fBounds.x + insets.left(), this.fBounds.y + contentHeight + insets.top(), this.fBounds.width - insets.left() - insets.right(), -1);
            } else {
                Rectangle topSibling = this.fChildren[index - 1].getBounds();
                item.layout(topSibling.x, topSibling.y + topSibling.height, topSibling.width, -1);
            }
            if (item.getWidth() > 0 || item.getHeight() > 0) {
                RedrawContext redraw = new RedrawContext();
                redraw.add(item);
                this.resized(item, 0, item.getHeight(), item, redraw);
            }
        }
        this.itemAdded(item);
    }

    protected void itemAdded(OutlineItem item) {
    }

    private void destroyItem(OutlineItem item) {
        this.removeItem(this.indexOf(item));
        if (!this.isLayouted() || this.getOutline().isLayoutDeferred()) {
            return;
        }
        if (this.fChildren.length == 0 && this.getContent() != null) {
            this.getOutline().redraw(this.getContent(), false);
        }
    }

    private OutlineItem removeItem(int index) {
        OutlineItem result = this.fChildren[index];
        if (index + 1 == this.fChildren.length) {
            if (index == 0) {
                this.fChildren = NO_ITEMS;
            } else {
                OutlineItem[] newChildren = new OutlineItem[this.fChildren.length - 1];
                System.arraycopy(this.fChildren, 0, newChildren, 0, newChildren.length);
                this.fChildren = newChildren;
            }
        } else {
            OutlineItem[] newChildren = new OutlineItem[this.fChildren.length - 1];
            System.arraycopy(this.fChildren, 0, newChildren, 0, index);
            System.arraycopy(this.fChildren, index + 1, newChildren, index, newChildren.length - index);
            this.fChildren = newChildren;
        }
        this.itemRemoved(result);
        return result;
    }

    protected void itemRemoved(OutlineItem item) {
    }

    public void removeAll() {
        OutlineItem[] outlineItemArray = this.fChildren;
        int n = this.fChildren.length;
        int n2 = 0;
        while (n2 < n) {
            OutlineItem child = outlineItemArray[n2];
            child.disposeItem();
            ++n2;
        }
        this.fChildren = NO_ITEMS;
    }

    public void setSortedChildren(OutlineItem[] sortedChildren) {
        int childCount = this.fChildren.length;
        Assert.isLegal((sortedChildren.length == childCount ? 1 : 0) != 0);
        if (this.isLayouted() && childCount > 0 && this.fChildren[0].isLayouted()) {
            Outline outline = this.getOutline();
            int y = this.fChildren[0].getBounds().y;
            int i = 0;
            while (i < childCount) {
                Assert.isTrue((sortedChildren[i].getParentIncludingRoot() == this ? 1 : 0) != 0);
                this.fChildren[i] = sortedChildren[i];
                int moveDelta = y - this.fChildren[i].getBounds().y;
                if (moveDelta != 0) {
                    this.fChildren[i].move(0, moveDelta);
                    outline.redraw(this.fChildren[i], true);
                }
                y += this.fChildren[i].getHeight();
                ++i;
            }
        } else {
            int i = 0;
            while (i < childCount) {
                Assert.isTrue((sortedChildren[i].getParent() == this ? 1 : 0) != 0);
                this.fChildren[i] = sortedChildren[i];
                ++i;
            }
        }
    }

    public OutlineItem findItemUnder(Point panePoint) {
        if (!this.fBounds.contains(panePoint)) {
            return null;
        }
        GShell shell = this.getContent();
        if (shell != null && shell.contains(panePoint)) {
            return this;
        }
        if (this.fExpanded) {
            int i = 0;
            while (i < this.fChildren.length) {
                OutlineItem result = this.fChildren[i].findItemUnder(panePoint);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return this;
    }

    public OutlineItem findItemUnderY(int y) {
        if (!this.isLayouted() || y < this.fBounds.y || this.fBounds.y + this.fBounds.height <= y) {
            return null;
        }
        GShell shell = this.getContent();
        if (shell != null && shell.containsY(y)) {
            return this;
        }
        if (this.fExpanded) {
            int i = 0;
            while (i < this.fChildren.length) {
                OutlineItem result = this.fChildren[i].findItemUnderY(y);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return this;
    }

    @Override
    public IGObject findGObjectUnder(Point panePoint) {
        IGObject result;
        if (!this.getBounds().contains(panePoint)) {
            return null;
        }
        GShell content = this.getContent();
        if (content != null && (result = content.findGObjectUnder(panePoint)) != null) {
            return result;
        }
        if (this.fExpanded) {
            int i = 0;
            while (i < this.fChildren.length) {
                result = this.fChildren[i].findGObjectUnder(panePoint);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return this;
    }

    public abstract GShell getContent();

    public boolean getExpanded() {
        return this.fExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, false);
    }

    protected void setExpanded(boolean expanded, boolean notify) {
        if (expanded == this.fExpanded) {
            return;
        }
        if (!this.isLayouted() || this.getOutline().isLayoutDeferred()) {
            this.fExpanded = expanded;
            return;
        }
        if (notify) {
            Event event = new Event();
            event.item = this;
            if (expanded) {
                this.getOutline().notifyListeners(17, event);
            } else {
                this.getOutline().notifyListeners(18, event);
            }
        }
        this.toggleExpandState();
    }

    private void toggleExpandState() {
        OutlineItem next = null;
        if (!this.fExpanded) {
            next = this.getOutline().getNextVisibleItem(this);
        }
        this.fExpanded = !this.fExpanded;
        Rectangle oldBounds = Rectangles.create(this.getBounds());
        this.clearBounds();
        int newWidth = this.computeMinimumWidth();
        if (newWidth > oldBounds.width) {
            this.getOutline().relayout();
        } else {
            RedrawContext redraw = new RedrawContext();
            if (!this.fExpanded) {
                redraw.add(oldBounds);
            }
            this.layout(oldBounds.x, oldBounds.y, oldBounds.width, -1);
            Rectangle newBounds = this.getBounds();
            if (this.fExpanded) {
                redraw.add(newBounds);
            }
            int deltaWidth = newBounds.width - oldBounds.width;
            int deltaHeight = newBounds.height - oldBounds.height;
            this.fParent.resized(this, deltaWidth, deltaHeight, this, redraw);
            if (!this.fExpanded) {
                next = this.getOutline().getNextVisibleItem(this);
            }
            if (next == null) {
                return;
            }
            Rectangle nextBounds = Rectangles.create(next.getBounds());
            next.layout(nextBounds.x, nextBounds.y, nextBounds.width, -1);
            Rectangle newNextBounds = next.getBounds();
            deltaHeight = newNextBounds.height - nextBounds.height;
            if (deltaHeight == 0) {
                return;
            }
            redraw = new RedrawContext();
            if (deltaHeight < 0) {
                redraw.add(nextBounds);
            } else {
                redraw.add(newNextBounds);
            }
            next.getParentIncludingRoot().resized(next, 0, deltaHeight, next, redraw);
        }
    }

    void setShowTreeUnderlay(boolean show) {
        if (show != this.fShowTreeUnderlay) {
            this.fShowTreeUnderlay = show;
            this.getOutline().redraw(this, true);
        }
    }

    void setSelectionMode(int mode) {
        GShell content = this.getContent();
        if (content == null) {
            return;
        }
        content.setSelectionMode(mode);
        if (this.isLayouted()) {
            this.getOutline().redraw(this, false);
        }
    }

    int getSelectionMode() {
        GShell content = this.getContent();
        if (content == null) {
            return 0;
        }
        return content.getSelectionMode();
    }

    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isOpenable() {
        return false;
    }

    protected OutlineResources getResources() {
        return this.getOutline().getOutlineResources();
    }

    protected Transformation getTransformation() {
        return this.getOutline().getTransformation();
    }

    @Override
    public Rectangle getBounds() {
        this.checkBounds();
        return this.fBounds;
    }

    public int getHeight() {
        this.checkBounds();
        return this.fBounds.height;
    }

    public int getWidth() {
        this.checkBounds();
        return this.fBounds.width;
    }

    public void move(int deltaX, int deltaY) {
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        this.checkBounds();
        Rectangles.move(this.fBounds, deltaX, deltaY);
        if (this.fExpanded) {
            int i = 0;
            while (i < this.fChildren.length) {
                this.fChildren[i].move(deltaX, deltaY);
                ++i;
            }
        }
    }

    public void resize(int deltaWidth, int deltaHeight, ResizeMode mode) {
        this.checkBounds();
        if (deltaWidth == 0 && deltaHeight == 0) {
            this.getOutline().redraw(this, true);
            return;
        }
        if (this.fBounds.width < -deltaWidth) {
            deltaWidth = -this.fBounds.width;
        }
        if (this.fBounds.height < -deltaHeight) {
            deltaHeight = -this.fBounds.height;
        }
        RedrawContext redraw = new RedrawContext();
        if (deltaHeight <= 0) {
            redraw.add(this.getBounds());
        }
        Rectangles.resize(this.fBounds, deltaWidth, deltaHeight);
        if (deltaHeight > 0) {
            redraw.add(this.getBounds());
        }
        if (this.fExpanded && mode == ResizeMode.CONTENT) {
            int i = 0;
            while (i < this.fChildren.length) {
                this.fChildren[i].move(deltaWidth, deltaHeight);
                ++i;
            }
        }
        this.fParent.resized(this, deltaWidth, deltaHeight, this, redraw);
    }

    protected void checkBounds() {
        if (this.isDisposed() || this.fBounds.y == Integer.MIN_VALUE || this.fBounds.height == Integer.MIN_VALUE) {
            throw new IllegalStateException();
        }
    }

    public boolean isLayouted() {
        return !this.isDisposed() && this.fBounds.x != Integer.MIN_VALUE;
    }

    public int computeMinimumWidth() {
        int result = 0;
        if (this.fExpanded) {
            int i = 0;
            while (i < this.fChildren.length) {
                result = Math.max(result, this.fChildren[i].computeMinimumWidth());
                ++i;
            }
        }
        Insets insets = this.getInsets();
        return result + insets.left() + insets.right();
    }

    public void layout(int x, int y, int wHint, int hHint) {
        Insets insets = this.getInsets();
        Point size = this.arrangeContent(x + insets.left(), y + insets.top(), wHint != -1 ? Math.max(0, wHint - insets.left() - insets.right()) : wHint, hHint != -1 ? Math.max(0, hHint - insets.top() - insets.bottom()) : hHint);
        Rectangles.assign(this.fBounds, x, y, Math.max(size.x + insets.left() + insets.right(), wHint), Math.max(size.y + insets.top() + insets.bottom(), hHint));
    }

    protected abstract Point arrangeContent(int var1, int var2, int var3, int var4);

    protected void resized(OutlineItem resizedChild, int deltaWidth, int deltaHeight, OutlineItem origin, RedrawContext redraw) {
        this.checkBounds();
        boolean process = false;
        int i = 0;
        while (i < this.fChildren.length) {
            OutlineItem child = this.fChildren[i];
            if (process) {
                if (deltaHeight <= 0) {
                    redraw.add(child.getBounds());
                }
                child.move(0, deltaHeight);
                if (deltaHeight > 0) {
                    redraw.add(child.getBounds());
                }
            } else if (resizedChild == child) {
                process = true;
            }
            ++i;
        }
        if (process) {
            Rectangles.resize(this.fBounds, deltaWidth, deltaHeight);
            if (this.fParent != null) {
                this.fParent.resized(this, deltaWidth, deltaHeight, origin, redraw);
            }
        }
    }

    void clearBounds() {
        this.fBounds = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        int i = 0;
        while (i < this.fChildren.length) {
            this.fChildren[i].clearBounds();
            ++i;
        }
    }

    protected Insets getInsets() {
        return Insets.NULL_INSETS;
    }

    public void paint(PaintEvent event, OutlineResources resources) {
        if (!resources.getPaintPaneBounds().intersects(this.fBounds)) {
            return;
        }
        this.paintContent(event, resources);
        if (this.fExpanded) {
            int i = 0;
            while (i < this.fChildren.length) {
                this.fChildren[i].paint(event, resources);
                ++i;
            }
        }
        if (this.fShowTreeUnderlay) {
            Rectangle bounds = this.getTransformation().toViewPort(this.getBounds());
            GC gc = event.gc;
            GCState state = GCState.save(gc, 10);
            if (!PlatformUI.getWorkbench().getDisplay().getHighContrast()) {
                gc.setAlpha(resources.getDropUnderFeedbackAlpha());
            }
            gc.setBackground(resources.getSelectionColor());
            gc.fillRectangle(bounds);
            state.restore();
        }
        if (resources.debugLayout) {
            GC gc = event.gc;
            Rectangle bounds = this.getTransformation().toViewPort(this.fBounds);
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
    }

    protected abstract void paintContent(PaintEvent var1, OutlineResources var2);

    @Override
    public IEventHandler findEventHandlerUnder(Point panePoint, int mode) {
        GShell content;
        IEventHandler result;
        if (!this.getBounds().contains(panePoint)) {
            return null;
        }
        if (this.fExpanded) {
            int i = 0;
            while (i < this.fChildren.length) {
                result = this.fChildren[i].findEventHandlerUnder(panePoint, mode);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        if ((content = this.getContent()) != null && (result = content.findEventHandlerUnder(panePoint, mode)) != null) {
            return result;
        }
        if (mode == 1) {
            return this;
        }
        return null;
    }

    protected Rectangle getContentBounds() {
        GShell content = this.getContent();
        if (content != null) {
            return content.getContentBounds();
        }
        if (!this.isLayouted()) {
            return this.fBounds;
        }
        Insets insets = this.getInsets();
        if (insets == Insets.NULL_INSETS) {
            return this.fBounds;
        }
        Rectangle result = Rectangles.create(this.fBounds);
        result.x += insets.left();
        result.width -= insets.left() + insets.right();
        result.y += insets.top();
        result.height -= insets.top() + insets.bottom();
        return result;
    }

    @Override
    public IGadgetEditor handleMouseDown(MouseEvent e) {
        if (this.isDisposed()) {
            return null;
        }
        return this.handleMouseDown(this, e);
    }

    protected IGadgetEditor handleMouseDown(IEventHandler receiver, MouseEvent e) {
        return this.fParent.handleMouseDown(receiver, e);
    }

    @Override
    public void handleMouseUp(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseUp(this, e);
    }

    protected void handleMouseUp(IEventHandler receiver, MouseEvent e) {
        this.fParent.handleMouseUp(receiver, e);
    }

    @Override
    public void handleMouseDoubleClick(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseDoubleClick(this, e);
    }

    protected void handleMouseDoubleClick(IEventHandler receiver, MouseEvent e) {
        this.fParent.handleMouseDoubleClick(receiver, e);
    }

    @Override
    public void handleMouseMove(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseMove(this, e);
    }

    protected void handleMouseMove(IEventHandler receiver, MouseEvent e) {
        this.fParent.handleMouseMove(receiver, e);
    }

    @Override
    public void handleMouseEnter(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseEnter(this, e);
    }

    protected void handleMouseEnter(IEventHandler receiver, MouseEvent e) {
        this.fParent.handleMouseEnter(receiver, e);
    }

    @Override
    public void handleMouseExit(MouseEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleMouseExit(this, e);
    }

    protected void handleMouseExit(IEventHandler handler, MouseEvent e) {
        this.fParent.handleMouseExit(this, e);
    }

    @Override
    public void handleContextMenuShown(Menu menu, MenuEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.handleContextMenuShown(this, menu, e);
    }

    protected void handleContextMenuShown(IEventHandler receiver, Menu menu, MenuEvent e) {
        this.fParent.handleContextMenuShown(receiver, menu, e);
    }

    @Override
    public void stop() {
        if (this.isDisposed()) {
            return;
        }
        this.stop(this);
    }

    protected void stop(IEventHandler receiver) {
        this.fParent.stop(receiver);
    }

    @Override
    public boolean requestsSelection() {
        return true;
    }
}

