/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.AbstractTextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class OutlineDropTargetEffect
extends DropTargetEffect {
    public static final int FEEDBACK_UNDERLAY_CHILDREN = 32;
    static final int SCROLL_HYSTERESIS = 200;
    static final int EXPAND_HYSTERESIS = 1000;
    public static final int DEFAULT_SCROLL_DELIMITER = 40;
    public static final int DEFAULT_SCROLL_DELIMITER_FAST = 20;
    public static final int DEFAULT_SCROLL_SPEED_SLOW = 5;
    public static final int DEFAULT_SCROLL_SPEED_FAST = 15;
    public static final int SCROLL_FREQUENCY = 50;
    OutlineItem fScrollItem = null;
    long fScrollBeginTime;
    long fScrollActualTime;
    int fScrollSpeed = 1;
    ScrollDirection fScrollDirection = ScrollDirection.NONE;
    OutlineItem fExpandItem = null;
    long fExpandBeginTime = 0L;
    OutlineItem fInsertItem;
    OutlineItem fUnderlayItem;
    OutlineItem[] fSelectedItems;
    private int fScrollZone = 40;
    private int fScrollZoneFast = 20;
    private int fMaxScrollSpeed = 5;
    private int fMaxScrollSpeedFast = 15;

    public OutlineDropTargetEffect(Outline outline) {
        super((Control)outline);
    }

    public void setScrollZone(int normal, int fast) {
        Assert.isLegal((normal >= fast ? 1 : 0) != 0);
        this.fScrollZone = normal;
        this.fScrollZoneFast = fast;
    }

    public void setScrollSpeed(int normal, int fast) {
        Assert.isLegal((normal <= fast ? 1 : 0) != 0);
        this.fMaxScrollSpeed = normal;
        this.fMaxScrollSpeedFast = fast;
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 0x20) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    public void dragEnter(DropTargetEvent event) {
        this.clearFields();
        this.fSelectedItems = ((Outline)this.getControl()).getSelection();
    }

    private void clearFields() {
        this.fScrollBeginTime = 0L;
        this.fScrollItem = null;
        this.fExpandBeginTime = 0L;
        this.fExpandItem = null;
        this.fInsertItem = null;
        this.fSelectedItems = null;
    }

    public void dragLeave(DropTargetEvent event) {
        Outline outline = (Outline)this.getControl();
        this.clearSelection(outline);
        this.clearFields();
        outline.setInsertMark(null, false);
        if (this.fUnderlayItem != null) {
            this.fUnderlayItem.setShowTreeUnderlay(false);
            this.fUnderlayItem = null;
        }
    }

    public void dragOver(DropTargetEvent event) {
        boolean underlayChildren;
        Outline outline = (Outline)this.getControl();
        int effect = this.checkEffect(event.feedback);
        OutlineItem item = (OutlineItem)event.item;
        if ((effect & 8) == 0) {
            this.fScrollBeginTime = 0L;
            this.fScrollItem = null;
        } else {
            int relativeEventY = outline.toControl((int)event.x, (int)event.y).y;
            if (this.fScrollDirection == ScrollDirection.NONE && item != null && this.fScrollItem == item && this.fScrollBeginTime != 0L) {
                if (System.currentTimeMillis() >= this.fScrollBeginTime) {
                    if (relativeEventY < this.fScrollZone) {
                        this.fScrollDirection = ScrollDirection.UP;
                        this.fScrollSpeed = Math.min(1, outline.getTransformation().getY());
                        outline.scroll(0, -this.fScrollSpeed);
                    } else if (relativeEventY > outline.getBounds().height - this.fScrollZone) {
                        this.fScrollDirection = ScrollDirection.DOWN;
                        this.fScrollSpeed = outline.getTransformation().getY() + outline.getClientArea().height - outline.getRootItem().getHeight() > 0 ? 0 : 1;
                        outline.scroll(0, this.fScrollSpeed);
                    }
                    this.fScrollActualTime = System.currentTimeMillis();
                }
            } else if (item != null && this.fScrollDirection == ScrollDirection.UP && relativeEventY < this.fScrollZone || this.fScrollDirection == ScrollDirection.DOWN && relativeEventY > outline.getBounds().height - this.fScrollZone) {
                if (System.currentTimeMillis() >= this.fScrollActualTime + 50L) {
                    if (relativeEventY < this.fScrollZoneFast || relativeEventY > outline.getBounds().height - this.fScrollZoneFast) {
                        if (this.fScrollSpeed < this.fMaxScrollSpeedFast) {
                            this.fScrollSpeed += 5;
                        }
                    } else {
                        if (this.fScrollSpeed > this.fMaxScrollSpeed) {
                            this.fScrollSpeed = this.fMaxScrollSpeed;
                        }
                        if (this.fScrollSpeed < this.fMaxScrollSpeed) {
                            ++this.fScrollSpeed;
                        }
                    }
                    if (this.fScrollDirection == ScrollDirection.UP) {
                        this.fScrollSpeed = Math.min(this.fScrollSpeed, outline.getTransformation().getY());
                        outline.scroll(0, -this.fScrollSpeed);
                    } else {
                        if (outline.getTransformation().getY() + outline.getClientArea().height - outline.getRootItem().getHeight() > 0) {
                            this.fScrollSpeed = 0;
                        }
                        outline.scroll(0, this.fScrollSpeed);
                    }
                    this.fScrollActualTime = System.currentTimeMillis();
                }
            } else {
                this.fScrollSpeed = 0;
                this.fScrollBeginTime = System.currentTimeMillis() + 200L;
                this.fScrollItem = item;
                this.fScrollDirection = ScrollDirection.NONE;
            }
        }
        if ((effect & 0x10) == 0) {
            this.fExpandBeginTime = 0L;
            this.fExpandItem = null;
        } else if (item != null && this.fExpandItem == item && this.fExpandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.fExpandBeginTime) {
                if (!item.getExpanded()) {
                    item.setExpanded(true, true);
                }
                this.fExpandBeginTime = 0L;
                this.fExpandItem = null;
            }
        } else {
            this.fExpandBeginTime = System.currentTimeMillis() + 1000L;
            this.fExpandItem = item;
        }
        boolean bl = underlayChildren = (effect & 0x20) != 0;
        if ((effect & 1) != 0) {
            OutlineItem selectedItem = outline.getLastSelectedItem();
            Point transfEventPoint = outline.getTransformation().toPane(outline.toControl(event.x, event.y));
            if (selectedItem != null && item != selectedItem && item != null && item.getContent() != null && (underlayChildren || item.getContent().getBounds().contains(transfEventPoint.x, transfEventPoint.y))) {
                this.clearSelection(outline);
                OutlineItem[] selection = new OutlineItem[this.fSelectedItems.length];
                System.arraycopy(this.fSelectedItems, 0, selection, 0, this.fSelectedItems.length);
                selection[selection.length - 1] = selectedItem;
                outline.setSelection(selection);
            }
        } else {
            this.clearSelection(outline);
        }
        if (underlayChildren) {
            if (this.fUnderlayItem != item && item != null) {
                if (this.fUnderlayItem != null) {
                    this.fUnderlayItem.setShowTreeUnderlay(false);
                    this.fUnderlayItem = null;
                }
                item.setShowTreeUnderlay(true);
                this.fUnderlayItem = item;
            }
        } else if (this.fUnderlayItem != null) {
            this.fUnderlayItem.setShowTreeUnderlay(false);
            this.fUnderlayItem = null;
        }
        if ((effect & 6) != 0 && item != null && item != outline.getRootItem()) {
            outline.setInsertMark(item, (effect & 2) != 0);
        } else {
            outline.setInsertMark(null, false);
        }
    }

    private void clearSelection(Outline outline) {
        AbstractTextEditor currentTextEditor;
        OutlineItem selection = outline.getLastSelectedItem();
        if (selection != null && (currentTextEditor = outline.getCurrentTextEditor()) != null) {
            currentTextEditor.stopEditSession();
            Object var3_3 = null;
        }
        if (this.fSelectedItems != null) {
            outline.setSelection(this.fSelectedItems);
        }
    }

    public Widget getItem(int x, int y) {
        if (this.getControl() instanceof Outline) {
            return ((Outline)this.getControl()).getItem(x, y);
        }
        return super.getItem(x, y);
    }

    private static enum ScrollDirection {
        NONE,
        UP,
        DOWN;

    }
}

