/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.client.teamload.AbstractLoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadItems;
import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarPainters;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class LoadBarPainter {
    private BarResources fResources;

    public LoadBarPainter(BarResources resources) {
        Assert.isNotNull((Object)resources);
        this.fResources = resources;
    }

    public BarResources getBarResources() {
        return this.fResources;
    }

    public int computeMinimalHeight() {
        FontMetrics metrics = this.fResources.getMessageFontMetrics();
        return this.computeTrimHeight(metrics.getHeight() - metrics.getLeading());
    }

    public int computeTrimHeight(int height) {
        return height <= 12 ? height + 8 : (int)(1.8f * (float)height);
    }

    public int computeTopSpacing(int height) {
        return (height <= 20 ? 4 : height / 5) - 2;
    }

    public void paint(GC gc, Rectangle bounds, AbstractLoadItem item) {
        GCState state = GCState.save(gc, 266);
        try {
            boolean drawMsg;
            int indent = bounds.height <= 20 ? 4 : bounds.height / 5;
            Rectangle outerBar = Rectangles.create(bounds);
            int delta = Math.max(0, indent - 2);
            Rectangles.move(outerBar, 0, delta);
            Rectangles.resize(outerBar, -indent - 2, -2 * delta);
            gc.setBackground(this.fResources.getWhite());
            gc.fillRectangle(outerBar);
            gc.setForeground(this.fResources.getOutline());
            gc.drawRectangle(outerBar);
            Rectangle innerBar = Rectangles.create(outerBar);
            Rectangles.resize(innerBar, -3, -3);
            Rectangles.move(innerBar, 2, 2);
            long workTimeLeft = Math.max(0L, item.getWorkTimeLeft());
            long workTimeBooked = Math.max(0L, item.getSumOfEstimates());
            int quality = LoadItems.getQualityOfPlanning((AbstractLoadItem)item);
            boolean overbooked = LoadItems.isOverbooked((AbstractLoadItem)item);
            int greenRedSeparator = (int)((float)innerBar.width * (overbooked ? (float)workTimeLeft / (float)workTimeBooked : (float)workTimeBooked / (float)workTimeLeft));
            int goodBadSeparator = (int)((float)innerBar.height / 100.0f * (float)quality);
            Message msg = LoadItems.getMessage((AbstractLoadItem)item);
            boolean drawBar = msg == null || msg.getSeverity() == Severity.INFO;
            boolean bl = drawMsg = msg != null;
            if (drawBar) {
                Rectangle backgroundLeft = Rectangles.create(innerBar);
                backgroundLeft.width = greenRedSeparator;
                gc.setForeground(this.fResources.getGradientStart());
                gc.setBackground(this.fResources.getGradientEnd());
                gc.fillGradientRectangle(backgroundLeft.x, backgroundLeft.y, backgroundLeft.width, backgroundLeft.height, true);
                Rectangle greenGood = Rectangles.create(backgroundLeft);
                greenGood.y = innerBar.y + (innerBar.height - goodBadSeparator);
                greenGood.height = goodBadSeparator;
                int alpha = gc.getAlpha();
                gc.setAlpha(this.fResources.getAlpha(alpha));
                gc.setBackground(this.fResources.getGreen());
                gc.fillRectangle(greenGood);
                gc.setAlpha(alpha);
                if (overbooked) {
                    Rectangle backgroundRight = Rectangles.create(backgroundLeft);
                    backgroundRight.x = backgroundLeft.x + greenRedSeparator + 1;
                    backgroundRight.width = innerBar.width - (greenRedSeparator + 1);
                    gc.setForeground(this.fResources.getGradientStart());
                    gc.setBackground(this.fResources.getGradientEnd());
                    gc.fillGradientRectangle(backgroundRight.x, backgroundRight.y, backgroundRight.width, backgroundRight.height, true);
                    Rectangle redGood = Rectangles.create(backgroundRight);
                    redGood.y = innerBar.y + (innerBar.height - goodBadSeparator);
                    redGood.height = goodBadSeparator;
                    alpha = gc.getAlpha();
                    gc.setAlpha((int)((float)alpha / 100.0f) * 33);
                    gc.setBackground(gc.getDevice().getSystemColor(3));
                    gc.fillRectangle(redGood);
                    gc.setAlpha(alpha);
                }
                gc.setBackground(this.fResources.getTwistie());
                int x1 = outerBar.x + outerBar.width + 2;
                int y1 = innerBar.y + innerBar.height - goodBadSeparator;
                BarPainters.paintTwistie(gc, BarPainters.Direction.Left, x1, y1, indent);
            }
            if (drawMsg) {
                gc.setFont(this.fResources.getMessageFont());
                int alpha = gc.getAlpha();
                gc.setAlpha(150);
                gc.setBackground(this.fResources.getWhite());
                gc.fillRectangle(innerBar);
                gc.setAlpha(alpha);
                gc.setForeground(this.fResources.getTwistie());
                Point extent = gc.stringExtent(msg.getMessage());
                Rectangle textBox = Rectangles.create(outerBar);
                Rectangles.resize(textBox, -2, -2);
                Rectangles.move(textBox, 1, 1);
                Point point = BarPainters.align(textBox, extent.x, extent.y, BarPainters.Alignment.Center, new BarPainters.Alignment[0]);
                BarPainters.drawString(gc, textBox, msg.getMessage(), point);
            }
        }
        finally {
            state.restore();
        }
    }
}

