/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GExpandButton;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GVoid;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.SimpleGadget;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GTreeNode<C extends GTreeNodeContent>
extends GShell {
    protected int fStyle;
    private SimpleGadget fExpandButton;
    private C fContent;
    private int fContentIndent;

    public GTreeNode(ContentOutlineItem item, int style) {
        super(item);
        if (style == 0) {
            this.fExpandButton = new GVoid(this);
            this.fStyle = 128;
        } else {
            this.fExpandButton = new GExpandButton(this);
            this.fStyle = style;
        }
        this.fExpandButton.setExclude(GTreeNode.hasStyle(this.fStyle, 1024));
    }

    @Override
    public boolean isLabelProperty(String property) {
        return this.fContent != null ? ((GTreeNodeContent)this.fContent).isLabelProperty(property) : false;
    }

    @Override
    public Object getElement() {
        return ((Gadget)this.fContent).getElement();
    }

    public void setContent(C content) {
        this.fContent = content;
    }

    public Gadget getExpandButton() {
        return this.fExpandButton;
    }

    public C getContent() {
        return this.fContent;
    }

    public void setContentIndent(int indent) {
        this.fContentIndent = indent;
    }

    public int getContentIndent() {
        return this.fContentIndent;
    }

    @Override
    public int computeMinimalWidth() {
        Insets insets = ((GTreeNodeContent)this.fContent).getInsets();
        return this.fExpandButton.computeMinimalWidth() + insets.left() + ((Gadget)this.fContent).computeMinimalWidth() + insets.right();
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        Insets insets = ((GTreeNodeContent)this.fContent).getInsets();
        int startX = x;
        int startY = y;
        int twistieSpacing = this.getOutlineResources().getTwistieSpacing();
        int indent = this.getContentIndent();
        x += indent;
        this.fExpandButton.layout(x += insets.left(), y += insets.top(), -1, -1);
        if (wHint != -1) {
            wHint -= insets.left() + indent + this.fExpandButton.getWidth() + twistieSpacing + insets.right();
        }
        ((Gadget)this.fContent).layout(x += this.fExpandButton.getWidth() + twistieSpacing, y, wHint, hHint);
        x += ((Gadget)this.fContent).getWidth();
        this.arrangeExpandButton();
        return new Point((x += insets.right()) - startX, (y += this.max(this.fExpandButton.getHeight(), ((Gadget)this.fContent).getHeight()) + insets.bottom()) - startY);
    }

    protected void arrangeExpandButton() {
        if ((this.fStyle & 0x1000000) != 0) {
            int delta = this.max(0, ((Gadget)this.fContent).getHeight() - this.fExpandButton.getHeight()) / 2;
            this.fExpandButton.move(0, delta);
        }
    }

    @Override
    public void move(int deltaX, int deltaY) {
        boolean excluded = this.fExpandButton.isExcluded();
        try {
            this.fExpandButton.setExclude(false);
            super.move(deltaX, deltaY);
        }
        finally {
            this.fExpandButton.setExclude(excluded);
        }
    }

    @Override
    public Rectangle getSelectionBounds() {
        return this.getBounds();
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        super.paint(gc, resources);
        if (resources.debugLayout) {
            Rectangle bounds = this.getTransformation().toViewPort(this.getBounds());
            Rectangles.resize(bounds, -1, -1);
            gc.drawRectangle(bounds);
        }
    }

    @Override
    protected void selectionGained() {
        if (GTreeNode.hasStyle(this.fStyle, 1024)) {
            this.fExpandButton.setExclude(false);
            if (this.isLayouted()) {
                this.redraw(false);
            }
        }
    }

    @Override
    protected void selectionLost() {
        if (GTreeNode.hasStyle(this.fStyle, 1024)) {
            this.fExpandButton.setExclude(true);
            if (this.isLayouted()) {
                this.redraw(false);
            }
        }
    }

    @Override
    public IGadgetEditor handleMouseDown(IEventHandler handler, MouseEvent e) {
        if (handler == this.fExpandButton && this.getOutlineItem().getItemCount() > 0) {
            this.toggleExpandState(this.getOutlineItem());
            return null;
        }
        return super.handleMouseDown(handler, e);
    }

    private void toggleExpandState(OutlineItem outlineItem) {
        boolean expanded = outlineItem.getExpanded();
        outlineItem.setExpanded(!expanded, true);
    }
}

