/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLink;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;

public class GText
extends GLink {
    private String fId;
    private String fAlternateText;
    private Color fColor;
    private Color fAlternateColor;
    private int fMaximumWidth;
    private Integer fCachedMaximalWidth = null;

    public GText(CompositeGadget parent, int style) {
        super(parent, "", style | 0x40);
        this.setColor(null);
    }

    @Override
    public boolean isOpenable() {
        return GText.hasStyle(this.fStyle, 2048);
    }

    @Override
    public void handleMouseEnter(MouseEvent e) {
        if (GText.hasStyle(this.fStyle, 2048)) {
            super.setColor(this.getOutlineResources().getLinkColor());
            super.handleMouseEnter(e);
        }
    }

    @Override
    public void handleMouseExit(MouseEvent e) {
        if (GText.hasStyle(this.fStyle, 2048)) {
            super.setColor(this.fColor);
            super.handleMouseExit(e);
        }
    }

    @Override
    public void setColor(Color color) {
        this.fColor = color;
        super.setColor(color);
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.fCachedMaximalWidth = null;
    }

    @Override
    public String getText() {
        if (this.shouldUseAlternateText()) {
            return this.fAlternateText;
        }
        return super.getText();
    }

    private boolean shouldUseAlternateText() {
        String text = super.getText();
        return this.fAlternateText != null && (text == null || GText.whitespaceCharOnly(text));
    }

    private static boolean whitespaceCharOnly(String string) {
        int len = string.length();
        int i = 0;
        while (i < len) {
            char ch = string.charAt(i);
            if (ch != ' ' && ch != '\t') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setAlternateText(String text) {
        this.fAlternateText = text;
        this.clearCache();
    }

    public void setAlternateColor(Color color) {
        this.fAlternateColor = color;
    }

    public int getMaximumWidth() {
        return this.fMaximumWidth;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.fMaximumWidth = maximumWidth;
    }

    @Override
    public int computeMinimalWidth() {
        return this.getOutlineResources().getMinimalTextWidth();
    }

    public int computeMaximumWidth() {
        if (this.fCachedMaximalWidth == null) {
            TextLayout layout = this.getTextLayout(-1);
            this.fCachedMaximalWidth = layout.getBounds().width;
        }
        return this.fCachedMaximalWidth;
    }

    protected void updateColorsAndFonts() {
        if (this.shouldUseAlternateText()) {
            this.setColor(this.fAlternateColor);
        }
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        this.updateColorsAndFonts();
        super.paint(gc, resources);
    }

    @Override
    public IGadgetEditor handleMouseDown(MouseEvent e) {
        IGadgetEditor result = null;
        if (this.shouldUseAlternateText()) {
            result = this.getShell().getOutline().startEditSession(this);
        }
        return result;
    }

    public void startEditSession(IGadgetEditor editor) {
    }

    public void stopEditSession(IGadgetEditor editor) {
        if (this.shouldUseAlternateText() && !this.isDisposed()) {
            Point size = this.arrangeContent(0, 0, -1, -1);
            this.resize(size.x - this.getBounds().width, 0);
        }
    }
}

