/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressBarDrawingStrategy;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.util.HtmlStyle;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GProgressBar
extends BarGadget {
    private GLabel fHours;
    private GLabel fEstimated;
    private int fMinimumWidth;
    private final ProgressBarDrawingStrategy fDrawingStragtegy;
    private final IProgressInformation fProgressInformation;

    public GProgressBar(CompositeGadget parent, IProgressLabelProvider labelProvider, IProgressInformation progressInformation) {
        super(parent);
        PlanOutlineResources resources = (PlanOutlineResources)this.getOutlineResources();
        Color color = parent.getDisplay().getSystemColor(17);
        BarResources barResources = resources.getBarResources();
        Font font = barResources.getMessageFont();
        this.fProgressInformation = progressInformation;
        this.fDrawingStragtegy = new ProgressBarDrawingStrategy(barResources);
        this.fDrawingStragtegy.setLabelProvider(labelProvider);
        this.fDrawingStragtegy.setInput(this.fProgressInformation);
        HtmlStyle style = HtmlStyle.parse(labelProvider.getProgressText(progressInformation), barResources.getStyles());
        this.fHours = new GLabel(this, style.getTextValue(), 0);
        this.fHours.setTextStyleRanges(style.getStyleRanges());
        this.fHours.setColor(color);
        this.fHours.setFont(font);
        this.fEstimated = new GLabel(this, labelProvider.getQualityText(progressInformation), 0);
        this.fEstimated.setColor(color);
        this.fEstimated.setFont(font);
        this.fMinimumWidth = barResources.getMessageFontMetrics().getAverageCharWidth() * 55;
    }

    @Override
    public void refresh() {
    }

    @Override
    public int computeMinimalWidth() {
        return this.max(this.computeBarHeight() * 6, this.fMinimumWidth, this.fHours.computeMinimalWidth() + this.getResources().getSpaceWidth() + this.fEstimated.computeMinimalWidth());
    }

    @Override
    public int computeTopSpacing() {
        return this.fDrawingStragtegy.computeTopSpacing(this.getBounds().height);
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        int x1 = x;
        int y1 = y;
        this.fHours.layout(x1, y1 += this.computeBarHeight(), -1, -1);
        x1 = wHint != -1 ? x + wHint - this.fEstimated.computeMinimalWidth() : (this.fMinimumWidth != -1 ? (x1 += this.fMinimumWidth - this.fEstimated.computeMinimalWidth()) : (x1 += this.fHours.getWidth() + this.getResources().getSpaceWidth()));
        this.fEstimated.layout(x1, y1, -1, -1);
        int width = this.max(this.computeBarHeight() * 6, this.fMinimumWidth, this.fHours.getWidth() + this.getResources().getSpaceWidth() + this.fEstimated.getWidth());
        int height = y1 + this.max(this.fHours.getHeight(), this.fEstimated.getHeight()) - y;
        if (hHint != -1) {
            height = hHint;
        }
        if (wHint != -1) {
            width = wHint;
        }
        return new Point(width, height);
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        GCState state = GCState.save(gc, 392);
        try {
            Rectangle rect = this.getTransformation().toViewPort(this.getBounds());
            rect.height = this.computeBarHeight();
            this.fDrawingStragtegy.paint(gc, rect);
        }
        finally {
            state.restore();
        }
        super.paint(gc, resources);
    }

    @Override
    public Object getElement() {
        return this.fProgressInformation;
    }

    @Override
    public IEventHandler findEventHandlerUnder(Point panePoint, int mode) {
        return this;
    }

    @Override
    public IGObject findGObjectUnder(Point pane) {
        return this;
    }

    private PlanOutlineResources getResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }

    private int computeBarHeight() {
        return this.fDrawingStragtegy.computeMinimalHeight();
    }
}

