/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;

public class GProbability
extends GLabel {
    private Color fBackgoundColor;
    private Integer fWidth;

    public GProbability(CompositeGadget parent, PlanItem planItem, IPlanningAttribute<PlanItem, ?> attribute, int style) {
        super(parent, GProbability.getLabel(planItem, attribute), style);
        Color[] probabilityColors = this.getOutlineResources().getProbabilityColors();
        double value = (Double)planItem.getAttributeValue(attribute);
        this.fBackgoundColor = value <= 0.2 ? probabilityColors[7] : (value <= 0.3 ? probabilityColors[6] : (value <= 0.4 ? probabilityColors[5] : (value <= 0.5 ? probabilityColors[4] : (value <= 0.6 ? probabilityColors[3] : (value <= 0.7 ? probabilityColors[2] : (value <= 0.8 ? probabilityColors[1] : (value <= 0.9 ? probabilityColors[0] : null)))))));
        this.setToolTipText(attribute.getDisplayName());
    }

    private static String getLabel(PlanItem planItem, IPlanningAttribute<PlanItem, ?> attribute) {
        Double attributeValue = (Double)planItem.getAttributeValue(attribute);
        return String.valueOf(Integer.toString((int)(attributeValue * 100.0))) + "%";
    }

    @Override
    public int computeMinimalWidth() {
        if (this.fWidth == null) {
            String text = this.getText();
            this.setText("100%");
            this.fWidth = super.computeMinimalWidth() + 6;
            this.setText(text);
        }
        return this.fWidth;
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        Point result = super.arrangeContent(x, y, wHint, hHint);
        result.x = this.fWidth;
        return result;
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        if (this.fBounds.width == 0) {
            return;
        }
        GCState state = GCState.save(gc, 392);
        try {
            TextLayout textLayout;
            Font font;
            Rectangle view = this.getTransformation().toViewPort(this.fBounds);
            if (this.fBackgoundColor != null) {
                gc.setBackground(this.fBackgoundColor);
                gc.fillRoundRectangle(view.x, view.y, view.width, view.height, 5, 5);
            }
            if ((font = (textLayout = this.getTextLayout((this.fStyle & 0x40) != 0 ? view.width : -1)).getFont()) == null) {
                font = gc.getFont();
            }
            TextStyle[] textStyleArray = textLayout.getStyles();
            int n = textStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextStyle style = textStyleArray[n2];
                if (style.foreground == null) {
                    style.foreground = gc.getForeground();
                }
                if (style.font == null && font != null) {
                    style.font = font;
                }
                ++n2;
            }
            int width = textLayout.getBounds().width;
            textLayout.draw(gc, view.x + Math.max(0, view.width - width) / 2, view.y);
            if (this.getOutlineResources().debugLayout) {
                gc.drawRectangle(view.x, view.y, view.width - 1, view.height - 1);
            }
        }
        finally {
            state.restore();
        }
    }

    @Override
    public Rectangle getBounds() {
        return super.getBounds();
    }
}

