/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.client.teamload.AbstractLoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadItems;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.LoadBarPainter;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextStyleRange;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;

public class GLoadBar
extends BarGadget {
    private LoadItem fLoadItem;
    private LoadBarPainter fBarPainter;
    private GLabel fHours;
    private GLabel fEstimated;
    private int fMinimumWidth;

    public GLoadBar(CompositeGadget parent, LoadItem loadItem) {
        super(parent);
        PlanOutlineResources resources = (PlanOutlineResources)this.getOutlineResources();
        this.fBarPainter = new LoadBarPainter(new BarResources((ResourceManager)resources.getResourceManager(), resources.getLoadStatusFont()));
        this.fLoadItem = loadItem;
        Color color = parent.getDisplay().getSystemColor(17);
        Font font = resources.getBarResources().getMessageFont();
        String textHours = LoadItems.getTextHours((AbstractLoadItem)this.fLoadItem);
        this.fHours = new GLabel(this, textHours, 0);
        this.fHours.setColor(color);
        this.fHours.setFont(font);
        this.applyHourTextStyle(textHours);
        this.fEstimated = new GLabel(this, LoadItems.getTextEstimate((AbstractLoadItem)this.fLoadItem), 0);
        this.fEstimated.setColor(color);
        this.fEstimated.setFont(font);
        TextLayout layout = resources.getTextLayout();
        layout.setFont(font);
        layout.setText(String.valueOf(LoadItems.getMaxTextHours()) + " " + LoadItems.getMaxTextEstimate());
        this.fMinimumWidth = layout.getBounds().width;
    }

    @Override
    public void refresh() {
        if (this.isDisposed()) {
            return;
        }
        String textHours = LoadItems.getTextHours((AbstractLoadItem)this.fLoadItem);
        this.fHours.setText(textHours);
        this.applyHourTextStyle(textHours);
        Rectangle hourBounds = this.fHours.getBounds();
        this.fHours.layout(hourBounds.x, hourBounds.y, -1, -1);
        this.fEstimated.setText(LoadItems.getTextEstimate((AbstractLoadItem)this.fLoadItem));
        Rectangle estimateBounds = this.fEstimated.getBounds();
        this.fEstimated.layout(estimateBounds.x, estimateBounds.y, -1, -1);
        this.redraw(true);
    }

    private void applyHourTextStyle(String textHours) {
        int s1 = textHours.lastIndexOf(124);
        int e1 = textHours.lastIndexOf(104);
        if (e1 == -1) {
            e1 = textHours.length();
        }
        if (s1 != -1) {
            Color textColor = LoadItems.isOverbooked((AbstractLoadItem)this.fLoadItem) ? this.fBarPainter.getBarResources().getRed() : this.fBarPainter.getBarResources().getGreen();
            TextStyleRange[] ranges = new TextStyleRange[]{new TextStyleRange(s1 + 1, Math.max(0, e1 - s1 - 2), new TextStyle(null, textColor, null))};
            this.fHours.setTextStyleRanges(ranges);
        }
    }

    public LoadBarPainter getBarPainter() {
        return this.fBarPainter;
    }

    @Override
    public int computeMinimalWidth() {
        return this.max(this.computeBarHeight() * 6, this.fMinimumWidth, this.fHours.computeMinimalWidth() + this.getResources().getSpaceWidth() + this.fEstimated.computeMinimalWidth());
    }

    @Override
    public int computeTopSpacing() {
        return this.fBarPainter.computeTopSpacing(this.getBounds().height);
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        int x1 = x;
        int y1 = y;
        this.fHours.layout(x1, y1 += this.computeBarHeight(), -1, -1);
        x1 = wHint != -1 ? x + wHint - this.fEstimated.computeMinimalWidth() : (this.fMinimumWidth != -1 ? (x1 += this.fMinimumWidth - this.fEstimated.computeMinimalWidth()) : (x1 += this.fHours.getWidth() + this.getResources().getSpaceWidth()));
        this.fEstimated.layout(x1, y1, -1, -1);
        int width = this.max(this.computeBarHeight() * 6, this.fMinimumWidth, this.fHours.getWidth() + this.getResources().getSpaceWidth() + this.fEstimated.getWidth());
        int height = y1 + this.max(this.fHours.getHeight(), this.fEstimated.getHeight()) - y;
        if (hHint != -1) {
            height = hHint;
        }
        if (wHint != -1) {
            width = wHint;
        }
        return new Point(width, height);
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        if (this.fLoadItem == null || this.fLoadItem.getLoadInformation().getMode() == LoadInformation.Mode.COUNT) {
            return;
        }
        GCState state = GCState.save(gc, 392);
        try {
            Rectangle rect = this.getTransformation().toViewPort(this.getBounds());
            rect.height = this.computeBarHeight();
            this.fBarPainter.paint(gc, rect, (AbstractLoadItem)this.fLoadItem);
        }
        finally {
            state.restore();
        }
        super.paint(gc, resources);
    }

    @Override
    public Object getElement() {
        if (this.fLoadItem == null) {
            return null;
        }
        if (this.fLoadItem.getLoadInformation().getMode() == LoadInformation.Mode.COUNT) {
            return null;
        }
        return this.fLoadItem;
    }

    @Override
    public IEventHandler findEventHandlerUnder(Point panePoint, int mode) {
        return this;
    }

    @Override
    public IGObject findGObjectUnder(Point pane) {
        return this;
    }

    private PlanOutlineResources getResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }

    private int computeBarHeight() {
        return this.fBarPainter.computeMinimalHeight();
    }
}

