/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;

public class GLink
extends GLabel {
    private IAction fAction;

    public GLink(CompositeGadget parent, String text, int style) {
        super(parent, text, style);
        this.setColor(parent.getOutlineResources().getLinkColor());
    }

    public void setAction(IAction action) {
        this.fAction = action;
    }

    @Override
    public void handleMouseEnter(MouseEvent e) {
        this.setUnderline(true);
        this.getOutline().setCursor(this.getDisplay().getSystemCursor(21));
        this.redraw(true);
    }

    @Override
    public void handleMouseExit(MouseEvent e) {
        this.setUnderline(false);
        this.getOutline().setCursor(this.getDisplay().getSystemCursor(0));
        this.redraw(true);
    }

    @Override
    public void handleMouseUp(MouseEvent e) {
        if (this.fAction == null || e.button != 1) {
            return;
        }
        this.fAction.run();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.isUnderline()) {
            this.setUnderline(false);
            this.getOutline().setCursor(this.getDisplay().getSystemCursor(0));
            this.redraw(false);
        }
    }

    @Override
    public void dispose() {
        if (this.isUnderline()) {
            this.setUnderline(false);
            this.getOutline().setCursor(this.getDisplay().getSystemCursor(0));
        }
        super.dispose();
    }

    @Override
    protected TextLayout getTextLayout(int width) {
        TextLayout result = super.getTextLayout(width);
        TextStyle[] textStyleArray = result.getStyles();
        int n = textStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextStyle style = textStyleArray[n2];
            style.underline = this.isUnderline();
            style.strikeout = this.isStrikeOut();
            style.foreground = super.getColor();
            ++n2;
        }
        return result;
    }
}

