/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.SimpleGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextStyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;

public class GLabel
extends SimpleGadget {
    protected int fStyle;
    private String fText;
    private Font fFont;
    private Color fColor;
    private boolean fUnderline;
    private boolean fStrikeOut;
    private Integer fCachedMinimalWidth = null;
    private Point fCachedSize = null;
    private Point fCachedSizeHint = null;
    private TextStyleRange[] fStyles;

    public GLabel(CompositeGadget parent, String text, int style) {
        super(parent);
        this.setText(text);
        this.fStyle = style;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.fText == null) {
            this.fText = "";
        }
        this.fStyles = null;
        this.clearCache();
    }

    public String getText() {
        return this.fText;
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font font) {
        this.fFont = font;
        this.clearCache();
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color color) {
        this.fColor = color;
        this.clearCache();
    }

    public boolean isUnderline() {
        return this.fUnderline;
    }

    public void setUnderline(boolean underline) {
        this.fUnderline = underline;
        this.clearCache();
    }

    public boolean isStrikeOut() {
        return this.fStrikeOut;
    }

    public void setStrikeOut(boolean strikeOut) {
        this.fStrikeOut = strikeOut;
        this.clearCache();
    }

    public TextStyleRange[] getStyles() {
        return this.fStyles;
    }

    public void setTextStyleRanges(TextStyleRange[] styles) {
        this.fStyles = styles;
        this.clearCache();
    }

    @Override
    public int computeMinimalWidth() {
        if (this.fCachedMinimalWidth == null) {
            this.fCachedMinimalWidth = this.getTextLayout((int)-1).getBounds().width;
        }
        return this.fCachedMinimalWidth;
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        Point cacheSizeHint = new Point(wHint, hHint);
        if (!cacheSizeHint.equals((Object)this.fCachedSizeHint)) {
            int width = wHint == 0 ? -1 : Math.max(wHint, -1);
            Rectangle bounds = this.getTextLayout(GLabel.hasStyle(this.fStyle, 64) ? width : -1).getBounds();
            this.fCachedSize = new Point(bounds.width, bounds.height);
            this.fCachedSizeHint = cacheSizeHint;
        }
        return this.fCachedSize;
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        if (this.fBounds.width == 0) {
            return;
        }
        GCState state = GCState.save(gc, 384);
        try {
            Rectangle view = this.getTransformation().toViewPort(this.fBounds);
            TextLayout textLayout = this.getTextLayout((this.fStyle & 0x40) != 0 ? view.width : -1);
            Font font = textLayout.getFont();
            if (font == null) {
                font = gc.getFont();
            }
            TextStyle[] textStyleArray = textLayout.getStyles();
            int n = textStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextStyle style = textStyleArray[n2];
                if (style.foreground == null) {
                    style.foreground = gc.getForeground();
                }
                if (style.font == null && font != null) {
                    style.font = font;
                }
                ++n2;
            }
            textLayout.draw(gc, view.x, view.y);
            if (this.getOutlineResources().debugLayout) {
                gc.drawRectangle(view.x, view.y, view.width - 1, view.height - 1);
            }
        }
        finally {
            state.restore();
        }
    }

    public int getDescent() {
        FontMetrics lineMetrics = this.getTextLayout(-1).getLineMetrics(0);
        return lineMetrics.getDescent();
    }

    protected TextLayout getTextLayout(int width) {
        TextLayout result = this.getOutlineResources().getTextLayout();
        String text = GLabel.safeGetText(this);
        text = text.replace("\r\n", "\n");
        result.setText(text);
        result.setWidth(width);
        if (this.fFont != null) {
            result.setFont(this.fFont);
        }
        this.getDefaultStyleRange().addTo(result);
        TextStyleRange[] styles = this.getStyles();
        if (styles != null) {
            TextStyleRange[] textStyleRangeArray = styles;
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                TextStyleRange style = textStyleRangeArray[n2];
                style.addTo(result);
                ++n2;
            }
        }
        return result;
    }

    private static String safeGetText(GLabel label) {
        String text = label.getText();
        if (text == null) {
            return "";
        }
        return text;
    }

    protected TextStyleRange getDefaultStyleRange() {
        TextStyle result = new TextStyle(this.fFont, this.fColor, null);
        result.underline = this.fUnderline;
        result.strikeout = this.fStrikeOut;
        return new TextStyleRange(0, this.fText.length(), result);
    }

    protected void clearCache() {
        this.fCachedSize = null;
        this.fCachedSizeHint = null;
    }
}

