/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.SimpleGadget;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GImage
extends SimpleGadget {
    private Image fImage;

    public GImage(CompositeGadget parent, Image image) {
        super(parent);
        this.fImage = image;
    }

    public Image getImage() {
        return this.fImage;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    @Override
    public int computeMinimalWidth() {
        if (this.fImage == null) {
            return 0;
        }
        return this.fImage.getBounds().width;
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        if (this.fImage == null) {
            return new Point(0, 0);
        }
        Rectangle bounds = this.fImage.getBounds();
        if (wHint != -1) {
            bounds.width = wHint;
        }
        if (hHint != -1) {
            bounds.height = hHint;
        }
        return new Point(bounds.width, bounds.height);
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        if (this.fImage == null) {
            return;
        }
        Rectangle view = this.getTransformation().toViewPort(this.fBounds);
        Rectangle image = this.fImage.getBounds();
        gc.drawImage(this.fImage, 0, 0, image.width, image.height, view.x, view.y, view.width, view.height);
        if (this.getOutlineResources().debugLayout) {
            gc.drawRectangle(view.x, view.y, view.width - 1, view.height - 1);
        }
    }
}

