/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GHBox
extends CompositeGadget {
    private int[] fWidthHints;
    private boolean fEnabled;

    public GHBox(CompositeGadget parent) {
        super(parent);
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        Gadget[] gadgetArray = this.fChildren;
        int n = this.fChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Gadget child = gadgetArray[n2];
            GStatusLineItem item = (GStatusLineItem)child;
            item.setEnabled(enabled);
            ++n2;
        }
    }

    public void setWidthHints(int[] widthHints) {
        this.fWidthHints = widthHints;
    }

    @Override
    public int computeMinimalWidth() {
        if (this.fWidthHints != null) {
            Assert.isTrue((this.fWidthHints.length == this.getGadgetCount() ? 1 : 0) != 0);
        }
        int spacing = this.getSpacing();
        int result = 0;
        boolean needsSpacing = false;
        int i = 0;
        while (i < this.fChildren.length) {
            if (!this.fChildren[i].isExcluded()) {
                int wHint = this.getWidthHint(i);
                result = wHint == -1 ? (result += this.fChildren[i].computeMinimalWidth()) : (result += this.fWidthHints[i]);
                if (needsSpacing) {
                    result += spacing;
                }
                needsSpacing = true;
            }
            ++i;
        }
        return result;
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        if (this.fWidthHints != null) {
            Assert.isTrue((this.fWidthHints.length == this.getGadgetCount() ? 1 : 0) != 0);
        }
        int width = 0;
        int height = 0;
        int totalHeight = 0;
        int maxWidth = 0;
        int posX = x;
        int startElement = 0;
        int spacing = this.getSpacing();
        boolean needsSpacing = false;
        int i = 0;
        while (i < this.fChildren.length) {
            Gadget child = this.fChildren[i];
            if (!child.isExcluded()) {
                int toAdd;
                int hint;
                if (needsSpacing) {
                    posX += spacing;
                    width += spacing;
                }
                child.layout(posX, y, (hint = this.getWidthHint(i)) > 0 ? hint : -1, hHint);
                int n = toAdd = hint != -1 ? hint : child.getWidth();
                if ((width += toAdd) > wHint) {
                    int j = startElement;
                    while (j < i) {
                        if (!this.fChildren[j].isExcluded()) {
                            this.fChildren[j].move(0, height - this.fChildren[j].getHeight());
                        }
                        ++j;
                    }
                    maxWidth = this.max(width - toAdd, maxWidth);
                    child.move(-(posX - x), height);
                    posX = x + toAdd;
                    y += height;
                    totalHeight += height;
                    width = toAdd;
                    height = child.getHeight();
                    startElement = i;
                    needsSpacing = false;
                } else {
                    posX += toAdd;
                    height = this.max(height, child.getHeight());
                    needsSpacing = true;
                }
            }
            ++i;
        }
        i = startElement;
        while (i < this.fChildren.length) {
            if (!this.fChildren[i].isExcluded()) {
                this.fChildren[i].move(0, height - this.fChildren[i].getHeight());
            }
            ++i;
        }
        return new Point(this.max(width, maxWidth), height + totalHeight);
    }

    protected int getSpacing() {
        return this.getOutlineResources().getFontMetrics().getHeight();
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        if (resources.debugLayout) {
            Rectangle view = this.getTransformation().toViewPort(this.getBounds());
            Rectangles.resize(view, -1, -1);
            gc.drawRectangle(view);
        }
        super.paint(gc, resources);
    }

    private int getWidthHint(int index) {
        return this.fWidthHints != null && this.fWidthHints.length > index ? this.fWidthHints[index] : -1;
    }
}

