/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.util.UITeamFutureAdapter;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.SimpleGadget;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GDeferredImage
extends SimpleGadget {
    private Image fImage;
    private int fWidthHint;
    private int fHeightHint;

    public GDeferredImage(CompositeGadget parent, TeamFuture<Image> future) {
        this(parent, future, 0, 0);
    }

    public GDeferredImage(CompositeGadget parent, TeamFuture<Image> future, Image defaultImage) {
        this(parent, future, defaultImage, defaultImage.getBounds().width, defaultImage.getBounds().height);
    }

    public GDeferredImage(CompositeGadget parent, TeamFuture<Image> future, Image defaultImage, int widthHint, int heightHint) {
        this(parent, future, widthHint, heightHint);
        if (this.fImage == null) {
            this.fImage = defaultImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDeferredImage(CompositeGadget parent, TeamFuture<Image> future, int widthHint, int heightHint) {
        super(parent);
        this.fWidthHint = widthHint;
        this.fHeightHint = heightHint;
        TeamFuture<Image> teamFuture = future;
        synchronized (teamFuture) {
            if (future.isResolved()) {
                this.fImage = (Image)future.getResult();
            } else {
                future.addListener(UITeamFutureAdapter.create(parent.getOutlineItem().getDisplay(), new TeamFutureAdapter<Image>(){

                    public void resolvingDone(TeamFutureEvent<Image> event) {
                        Image result = (Image)event.getTeamFuture().getResult();
                        if (result != null) {
                            GDeferredImage.this.fImage = result;
                            if (GDeferredImage.this.isLayouted()) {
                                Rectangle bounds = GDeferredImage.this.fImage.getBounds();
                                int deltaX = bounds.width - GDeferredImage.this.fWidthHint;
                                int deltaY = bounds.height - GDeferredImage.this.fHeightHint;
                                if (deltaX != 0 || deltaY != 0) {
                                    GDeferredImage.this.resize(deltaX, deltaY);
                                } else {
                                    GDeferredImage.this.redraw(true);
                                }
                            }
                        }
                    }

                    public void resolvingFailed(TeamFutureEvent<Image> event) {
                        PlanningUIPlugin.log(event.getTeamFuture().getStatus());
                    }

                    public void resolvingCanceled(TeamFutureEvent<Image> event) {
                        PlanningUIPlugin.log(event.getTeamFuture().getStatus());
                    }
                }));
            }
        }
    }

    public Image getImage() {
        return this.fImage;
    }

    @Override
    public int computeMinimalWidth() {
        if (this.fImage == null) {
            return this.fWidthHint;
        }
        return this.fImage.getBounds().width;
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        if (this.fImage == null) {
            return new Point(this.fWidthHint, this.fHeightHint);
        }
        Rectangle bounds = this.fImage.getBounds();
        if (wHint != -1) {
            bounds.width = wHint;
        }
        if (hHint != -1) {
            bounds.height = hHint;
        }
        return new Point(bounds.width, bounds.height);
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        if (this.fImage == null) {
            return;
        }
        Rectangle view = this.getTransformation().toViewPort(this.fBounds);
        Rectangle image = this.fImage.getBounds();
        gc.drawImage(this.fImage, 0, 0, image.width, image.height, view.x, view.y, view.width, view.height);
        if (this.getOutlineResources().debugLayout) {
            gc.drawRectangle(view.x, view.y, view.width - 1, view.height - 1);
        }
    }
}

