/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GDeferredImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.core.session.CollaborationSessionEvent;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public final class GContributorPhoto
extends GDeferredImage
implements ICollaborationPresenceListener,
ICollaborationSessionListener {
    private final IContributorHandle fOwner;
    private CollaborationPresenceStatus fStatus = CollaborationPresenceStatus.STATUS_UNKNOWN;

    public GContributorPhoto(CompositeGadget parent, IContributorHandle owner, TeamFuture<Image> future, OutlineResources resources) {
        super(parent, future, resources.getImage(ImagePool.TEAM_UNKNOWN), 32, 32);
        Assert.isNotNull((Object)owner);
        this.fOwner = owner;
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.addPresenceListener((ICollaborationPresenceListener)this);
        service.addSessionListener((ICollaborationSessionListener)this);
        this.fStatus = service.getPresenceStatus(owner);
    }

    @Override
    public void dispose() {
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.removePresenceListener((ICollaborationPresenceListener)this);
        service.removeSessionListener((ICollaborationSessionListener)this);
        super.dispose();
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        super.paint(gc, resources);
        Rectangle viewPort = this.getTransformation().toViewPort(this.fBounds);
        Image image = JazzResources.getImageWithDefault((ResourceManager)resources.getResourceManager(), (ImageDescriptor)CollaborationUI.getOverlayDescriptor((CollaborationPresenceStatus)this.fStatus));
        Rectangle bounds = image.getBounds();
        gc.drawImage(image, viewPort.x + 32 - bounds.width, viewPort.y + 32 - bounds.height);
        ImageDescriptor descriptor = CollaborationUI.getOverlayDescriptor((IContributorHandle)this.fOwner);
        if (descriptor != null) {
            image = JazzResources.getImageWithDefault((ResourceManager)resources.getResourceManager(), (ImageDescriptor)descriptor);
            gc.drawImage(image, viewPort.x + 24 - bounds.width, viewPort.y + 32 - bounds.height);
        }
    }

    public void presenceNotification(final CollaborationPresenceEvent event) {
        Assert.isNotNull((Object)event);
        if (this.fOwner.getItemId().equals((Object)event.getUser().getUUID())) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!GContributorPhoto.this.isDisposed()) {
                        GContributorPhoto.this.fStatus = event.getPresence().getStatus();
                        GContributorPhoto.this.redraw(true);
                    }
                }
            });
        }
    }

    public void sessionNotification(CollaborationSessionEvent event) {
        Assert.isNotNull((Object)event);
        CollaborationUser user = event.getUser();
        if (user != null && this.fOwner.getItemId().equals((Object)event.getUser().getUUID())) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GContributorPhoto.this.fStatus = CollaborationCore.getCollaborationService().getPresenceStatus(GContributorPhoto.this.fOwner);
                    GContributorPhoto.this.redraw(true);
                }
            });
        }
    }
}

