/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.common.gadgets.GroupGadget;
import com.ibm.team.apt.internal.ide.ui.common.structure.ColumnElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.RowElement;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IDropTargetOverride;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.TimeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.RedrawContext;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ResizeMode;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.ArrayList;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class ContentOutlineItem
extends OutlineItem {
    private GShell fContent;

    public ContentOutlineItem(Outline outline, int style) {
        super(outline, style);
    }

    public ContentOutlineItem(Outline outline, int style, int index) {
        super(outline, style, index);
    }

    public ContentOutlineItem(OutlineItem parent, int style) {
        super(parent, style);
    }

    public ContentOutlineItem(OutlineItem parent, int style, int index) {
        super(parent, style, index);
    }

    @Override
    public boolean isSelectable() {
        return !this.isRowItem() && !this.isColumnItem();
    }

    public abstract int getMinimalWidth();

    @Override
    protected void disposeItem() {
        if (this.fContent != null) {
            this.fContent.dispose();
        }
        super.disposeItem();
    }

    public void setContent(GShell content) {
        Rectangle oldBounds;
        GShell oldContent = this.fContent;
        this.fContent = content;
        if (!this.isLayouted() || this.getOutline().isLayoutDeferred()) {
            if (oldContent != null) {
                oldContent.dispose();
            }
            return;
        }
        if (oldContent != null) {
            oldBounds = Rectangles.create(oldContent.getBounds());
            this.fContent.internalSetSelectionMode(oldContent.internalGetSelectionMode());
            oldContent.dispose();
        } else {
            oldBounds = new Rectangle(0, 0, 0, 0);
        }
        int width = this.fContent.computeMinimalWidth();
        if (width > this.fBounds.width) {
            this.getOutline().relayout();
        } else {
            this.setTreeContentIndent(this.fContent, this.computeTreeContentIndent(this));
            this.fContent.layout(this.fBounds.x, this.fBounds.y, this.fBounds.width, -1);
            Rectangle newBounds = this.fContent.getBounds();
            int deltaWidth = this.fBounds.width >= newBounds.width ? 0 : newBounds.width - this.fBounds.width;
            int deltaHeight = newBounds.height - oldBounds.height;
            if (deltaWidth != 0 || deltaHeight != 0) {
                this.resize(deltaWidth, deltaHeight, ResizeMode.CONTENT);
            } else {
                this.getOutline().redraw(this, false);
            }
        }
    }

    @Override
    public GShell getContent() {
        return this.fContent;
    }

    public IViewEntry<?> computeDropOverride(DropTargetEvent event) {
        if (this.fContent instanceof IDropTargetOverride) {
            Rectangle outlineBounds = this.getOutline().getBounds();
            Point outlineOrigin = this.getOutline().toDisplay(outlineBounds.x, outlineBounds.y);
            ArrayList children = new ArrayList();
            OutlineItem[] outlineItemArray = this.fChildren;
            int n = this.fChildren.length;
            int n2 = 0;
            while (n2 < n) {
                OutlineItem child = outlineItemArray[n2];
                children.add((IViewEntry)child.getData());
                ++n2;
            }
            return ((IDropTargetOverride)((Object)this.fContent)).computeOverride(event.x - outlineOrigin.x, event.y - outlineOrigin.y, children);
        }
        return null;
    }

    private int computeTreeContentIndent(OutlineItem item) {
        OutlineItem parent;
        int indent = 0;
        boolean skipFirst = !(item.getContent() instanceof GroupGadget) || item.getContent() instanceof TimeGadget;
        while ((parent = item.getParent()) != null) {
            item = parent;
            if (parent.getContent() instanceof PlanItemGadget) {
                indent += this.getResources().getChildIndent();
                continue;
            }
            if (parent.getContent() instanceof TimeGadget) {
                indent += 0;
                continue;
            }
            if (!(parent.getContent() instanceof GroupGadget)) continue;
            indent += skipFirst ? 0 : this.getResources().getChildIndent();
            skipFirst = false;
        }
        return indent;
    }

    private void setTreeContentIndent(GShell content, int newIndent) {
        if (content instanceof GTreeNode) {
            ((GTreeNode)content).setContentIndent(newIndent);
        }
    }

    @Override
    public void move(int deltaX, int deltaY) {
        if (this.isLayouted()) {
            super.move(deltaX, deltaY);
            if (this.fContent != null && this.fContent.isLayouted()) {
                this.fContent.move(deltaX, deltaY);
            }
        }
    }

    @Override
    public int computeMinimumWidth() {
        int result = 0;
        if (this.fContent != null) {
            if (this.isRowItem()) {
                OutlineItem[] outlineItemArray = this.fChildren;
                int n = this.fChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    OutlineItem child = outlineItemArray[n2];
                    result += child.computeMinimumWidth();
                    ++n2;
                }
            } else {
                result = this.fContent.computeMinimalWidth();
            }
        }
        return Math.max(result, super.computeMinimumWidth());
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        if (wHint != -1 && this.getMinimalWidth() > 0 && wHint < this.getMinimalWidth()) {
            wHint = this.getMinimalWidth();
        }
        if (this.isRowItem()) {
            this.fContent.layout(x, y, wHint, hHint);
            int columnWidthHint = wHint / (this.fChildren.length == 0 ? 1 : this.fChildren.length);
            int width = 0;
            int height = 0;
            x += width;
            int i = 0;
            while (i < this.fChildren.length) {
                OutlineItem child = this.fChildren[i];
                child.layout(x, y, columnWidthHint - 1, hHint);
                x += columnWidthHint;
                width += columnWidthHint;
                height = Math.max(height, child.getHeight());
                ++i;
            }
            return new Point(width, height);
        }
        int width = 0;
        int height = 0;
        if (this.fContent != null) {
            this.fContent.layout(x, y, wHint, hHint);
            width = Math.max(width, this.fContent.getWidth());
            height += this.fContent.getHeight();
            y += this.fContent.getHeight();
        } else if (wHint != -1) {
            width = wHint;
        }
        if (this.fChildren.length > 0 && this.getExpanded()) {
            int i = 0;
            while (i < this.fChildren.length) {
                OutlineItem child = this.fChildren[i];
                if (child instanceof ContentOutlineItem) {
                    this.setTreeContentIndent(((ContentOutlineItem)child).getContent(), this.computeTreeContentIndent(child));
                }
                child.layout(x, y, wHint, hHint);
                width = Math.max(width, child.getWidth());
                int deltaHeight = child.getHeight();
                height += deltaHeight;
                y += deltaHeight;
                ++i;
            }
        }
        return new Point(width, height);
    }

    @Override
    protected void paintContent(PaintEvent event, OutlineResources resources) {
        if (this.fContent != null && resources.getPaintPaneBounds().intersects(this.fContent.getBounds())) {
            this.fContent.paint(event.gc, resources);
        }
        if (resources.debugLayout) {
            Rectangle bounds = this.getTransformation().toViewPort(this.fContent.getBounds());
            event.gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
    }

    @Override
    void clearBounds() {
        super.clearBounds();
        if (this.fContent != null) {
            this.fContent.clearBounds();
        }
    }

    @Override
    protected void resized(OutlineItem resizedChild, int deltaWidth, int deltaHeight, OutlineItem origin, RedrawContext redraw) {
        if (this.isRowItem()) {
            this.checkBounds();
            int height = 0;
            int i = 0;
            while (i < this.fChildren.length) {
                OutlineItem child = this.fChildren[i];
                Rectangle bounds = child.getBounds();
                height = Math.max(height, bounds.height);
                ++i;
            }
            height = Math.max(height, this.fContent.getContentBounds().height);
            deltaHeight = height - this.fBounds.height;
            Rectangles.resize(this.fBounds, deltaWidth, deltaHeight);
            redraw.add(this.fBounds);
            this.fParent.resized(this, deltaWidth, deltaHeight, origin, redraw);
        } else if (this.isColumnItem() && this.fChildren.length == 0) {
            redraw.add(this.fBounds);
            super.resized(resizedChild, deltaWidth, deltaHeight, origin, redraw);
        } else {
            super.resized(resizedChild, deltaWidth, deltaHeight, origin, redraw);
        }
    }

    private boolean isColumnItem() {
        IViewEntry data = (IViewEntry)this.getData();
        return data != null && data.getElement() instanceof ColumnElement;
    }

    private boolean isRowItem() {
        IViewEntry data = (IViewEntry)this.getData();
        return data != null && data.getElement() instanceof RowElement;
    }
}

