/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.util.GCState;
import java.util.EnumSet;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BarPainters {
    public static void paintTwistie(GC gc, Direction dircection, int startX, int startY, int len) {
        switch (dircection) {
            case Left: {
                gc.fillPolygon(new int[]{startX, startY, startX + len, startY + len, startX + len, startY - len});
                break;
            }
            case Right: {
                gc.fillPolygon(new int[]{startX, startY, startX - len, startY + len, startX - len, startY - len});
                break;
            }
            case Top: {
                gc.fillPolygon(new int[]{startX, startY, startX - len, startY + len, startX + len, startY + len});
                break;
            }
            case Bottom: {
                gc.fillPolygon(new int[]{startX, startY, startX - len, startY - len, startX + len, startY - len});
            }
        }
    }

    public static Point align(Rectangle rect, int width, int height, Alignment first, Alignment ... rest) {
        int w = 0;
        int h = 0;
        EnumSet<Alignment[]> set = EnumSet.of(first, rest);
        for (Alignment alignment : set) {
            switch (alignment) {
                case Center: {
                    w = (rect.width - width) / 2;
                    h = (rect.height - height) / 2;
                    break;
                }
                case Top: {
                    w = (rect.width - width) / 2;
                    break;
                }
                case Bottom: {
                    w = (rect.width - width) / 2;
                    h = rect.y + rect.height - height;
                    break;
                }
                case Left: {
                    h = (rect.height - height) / 2;
                    break;
                }
                case Right: {
                    h = (rect.height - height) / 2;
                    w = rect.x + rect.width - width;
                }
            }
        }
        return new Point(rect.x + w, rect.y + h);
    }

    public static void drawString(GC gc, Rectangle bounds, String text, Point point) {
        GCState state = GCState.save(gc, 32);
        try {
            gc.setClipping(bounds);
            gc.drawString(text, point.x, point.y, true);
        }
        finally {
            state.restore();
        }
    }

    public static enum Alignment {
        Top,
        Center,
        Bottom,
        Left,
        Right;

    }

    public static enum Direction {
        Left,
        Top,
        Right,
        Bottom;

    }
}

