/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Events;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ITextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ITextEditorListener;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Transformation;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public abstract class AbstractTextEditor
implements ITextEditor {
    public static final String DATA_KEY = "textEditor";
    private GText fOwner;
    protected StyledText fEditControl;
    private MenuManager fMenuManager;
    private int fStyle;
    private Rectangle fTrimmings;
    private int fWidth;
    private Point fOldSize;
    protected int fMaximumWidth;
    private ListenerList fTextEditorListeners = new ListenerList(1);

    public AbstractTextEditor(Composite parent, final int style) {
        this.fEditControl = this.createStyledText(parent, style & 0xFFFFFFFB);
        this.fEditControl.setFont(parent.getFont());
        this.fEditControl.setData(DATA_KEY, (Object)this);
        this.fStyle = style;
        this.fOldSize = this.fEditControl.getSize();
        this.fWidth = this.fOldSize.x;
        this.fMaximumWidth = -1;
        this.fEditControl.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                AbstractTextEditor.this.fOldSize = AbstractTextEditor.this.fEditControl.getSize();
            }
        });
        this.fEditControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Point newSize;
                if (AbstractTextEditor.this.fOwner == null) {
                    return;
                }
                if (AbstractTextEditor.this.fMaximumWidth == -1) {
                    newSize = AbstractTextEditor.this.fEditControl.computeSize(AbstractTextEditor.this.fWidth, -1);
                } else {
                    newSize = AbstractTextEditor.this.fEditControl.computeSize(AbstractTextEditor.this.fEditControl.getCharCount() != 0 ? -1 : 0, -1);
                    if (newSize.x > AbstractTextEditor.this.fMaximumWidth || (style & 4) != 0) {
                        newSize = AbstractTextEditor.this.fEditControl.computeSize(AbstractTextEditor.this.fMaximumWidth, -1);
                    }
                }
                if (newSize.y != ((AbstractTextEditor)AbstractTextEditor.this).fOldSize.y || newSize.x != ((AbstractTextEditor)AbstractTextEditor.this).fOldSize.x) {
                    AbstractTextEditor.this.fOwner.setText(AbstractTextEditor.this.getTextContent());
                    AbstractTextEditor.this.fEditControl.setSize(newSize.x, newSize.y);
                    int deltaWidth = AbstractTextEditor.this.fOwner.computeMaximumWidth() - ((AbstractTextEditor)AbstractTextEditor.this).fOwner.getBounds().width;
                    int deltaHeight = newSize.y - ((AbstractTextEditor)AbstractTextEditor.this).fOldSize.y;
                    AbstractTextEditor.this.fOwner.resize(-1, -1);
                }
            }
        });
        this.fMenuManager = new MenuManager("#PopupMenu");
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fEditControl.setMenu(this.fMenuManager.createContextMenu((Control)this.fEditControl));
    }

    public void addListener(ITextEditorListener listener) {
        this.fTextEditorListeners.add((Object)listener);
    }

    public void removeListener(ITextEditorListener listener) {
        this.fTextEditorListeners.remove((Object)listener);
    }

    protected void fireContentChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.fTextEditorListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ITextEditorListener)listener).contentChanged(this);
            ++n2;
        }
    }

    protected abstract String getTextContent();

    protected abstract StyledText createStyledText(Composite var1, int var2);

    public abstract void dispose();

    public StyledText getControl() {
        return this.fEditControl;
    }

    @Override
    public void setFocus() {
        this.fEditControl.setFocus();
    }

    @Override
    public Point getSelection() {
        return this.fEditControl.getSelection();
    }

    @Override
    public void setSelection(Point selection) {
        this.fEditControl.setSelection(selection);
    }

    @Override
    public void setFullSelection() {
        this.fEditControl.setSelection(0, this.fEditControl.getCharCount());
    }

    public void addMenuListener(IMenuListener listener) {
        this.fMenuManager.addMenuListener(listener);
    }

    public void removeMenuListener(IMenuListener listener) {
        this.fMenuManager.removeMenuListener(listener);
    }

    protected int getStyle() {
        return this.fStyle;
    }

    public boolean isActive() {
        return this.fOwner != null;
    }

    @Override
    public Gadget getGadget() {
        return this.fOwner;
    }

    @Override
    public GText getOwner() {
        return this.fOwner;
    }

    protected void setOwner(GText newOwner) {
        this.fOwner = newOwner;
        if (this.fOwner != null) {
            Rectangle ownerBounds = this.fOwner.getBounds();
            Rectangle rect = this.fEditControl.computeTrim(ownerBounds.x, ownerBounds.y, ownerBounds.width, ownerBounds.height);
            this.fTrimmings = new Rectangle(rect.x - ownerBounds.x, rect.y - ownerBounds.y, rect.width - ownerBounds.width, rect.height - ownerBounds.height);
        } else {
            this.fTrimmings = null;
        }
    }

    public abstract boolean isOwner(PlanItemGadget var1);

    @Override
    public void adjustBounds(Transformation transformation) {
        Rectangle ownerBounds = transformation.toViewPort(this.fOwner.getBounds());
        Rectangle editBounds = this.fEditControl.getBounds();
        boolean fill = (this.fStyle & 4) != 0;
        int expectedWidth = fill ? this.fOwner.getMaximumWidth() : ownerBounds.width;
        int actualWidth = editBounds.width - this.fTrimmings.width;
        int expectedHeight = ownerBounds.height;
        int actualHeight = editBounds.height - this.fTrimmings.height;
        if (expectedWidth != actualWidth || expectedHeight != actualHeight) {
            Rectangle rect = Rectangles.create(ownerBounds);
            if (fill) {
                rect.width = this.fOwner.getMaximumWidth();
            }
            this.setBounds(rect);
        }
    }

    public void setBounds(Rectangle bounds) {
        this.fEditControl.setBounds(bounds.x + this.fTrimmings.x, bounds.y + this.fTrimmings.y, bounds.width + this.fTrimmings.width, bounds.height + this.fTrimmings.height);
        this.fOldSize = this.fEditControl.getSize();
        this.fWidth = this.fOldSize.x;
    }

    public abstract IViewEntry<?> getEntry();

    public abstract void startEditSession(GText var1, IViewEntry<?> var2, Transformation var3);

    @Override
    public abstract void storeData();

    public abstract void cancelEditSession();

    public abstract void stopEditSession();

    public void forwardMouseDown(MouseEvent e) {
        this.forwardMouseEvent(3, e);
    }

    public void forwardMouseUp(MouseEvent e) {
        this.forwardMouseEvent(4, e);
    }

    public void forwardMouseDoubleClick(MouseEvent e) {
        this.forwardMouseEvent(8, e);
    }

    public void forwardMouseMove(MouseEvent e) {
        this.forwardMouseEvent(5, e);
    }

    private void forwardMouseEvent(int type, MouseEvent e) {
        if (this.fEditControl.isDisposed() || !this.fEditControl.isFocusControl()) {
            return;
        }
        Event newEvent = Events.createEvent(type, e);
        Point edit = this.fEditControl.toControl(this.fEditControl.getParent().toDisplay(e.x, e.y));
        newEvent.x = edit.x;
        newEvent.y = edit.y;
        this.fEditControl.notifyListeners(type, newEvent);
    }
}

