/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class StatusBar
extends Canvas {
    private List fValues = new ArrayList(2);

    public StatusBar(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                StatusBar.this.doPaint(e);
            }
        });
    }

    public Status getItem(int index) {
        return (Status)this.fValues.get(index);
    }

    private void addStatus(Status status) {
        this.fValues.add(status);
        this.redraw();
    }

    public void redraw() {
        this.updateToolTip();
        super.redraw();
    }

    protected void doPaint(PaintEvent event) {
        if (this.fValues.size() == 0) {
            return;
        }
        int sum = 0;
        for (Status status : this.fValues) {
            sum += status.getValue();
        }
        if (sum == 0) {
            return;
        }
        Rectangle area = this.getClientArea();
        float factor = area.width / sum;
        GC gc = event.gc;
        int[] widths = new int[this.fValues.size()];
        int i = 0;
        int rest = area.width;
        for (Status status : this.fValues) {
            widths[i] = Math.round((float)status.getValue() * factor);
            rest -= widths[i];
            ++i;
        }
        i = 0;
        while (rest > 0) {
            int n = i++;
            widths[n] = widths[n] + 1;
            --rest;
            if (i != widths.length) continue;
            i = 0;
        }
        int x = 0;
        int w = 0;
        while (w < widths.length) {
            gc.setBackground(((Status)this.fValues.get(w)).getColor());
            gc.fillRectangle(x, 0, widths[w], area.height);
            x += widths[w];
            ++w;
        }
    }

    private void updateToolTip() {
        StringBuffer text = new StringBuffer();
        int last = this.fValues.size() - 1;
        int i = 0;
        while (i < this.fValues.size()) {
            Status status = (Status)this.fValues.get(i);
            text.append(status.getName());
            text.append("(");
            text.append(status.getValue());
            text.append(")");
            if (i < last) {
                text.append("/");
            }
            ++i;
        }
        if (text.length() > 0) {
            this.setToolTipText(text.toString());
        }
    }

    public static class Status {
        private StatusBar fBar;
        private String fName;
        private int fValue;
        private Color fColor;

        public Status(StatusBar bar, String name, int value, Color color) {
            this.fBar = bar;
            this.fName = name;
            this.fValue = value;
            this.fColor = color;
            this.fBar.addStatus(this);
        }

        public String getName() {
            return this.fName;
        }

        public void setValue(int value) {
            this.fValue = value;
            this.fBar.redraw();
        }

        public int getValue() {
            return this.fValue;
        }

        public Color getColor() {
            return this.fColor;
        }
    }
}

