/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets;

import com.ibm.team.apt.internal.ide.ui.util.UI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SingleListSelectionDialog
extends SelectionDialog {
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private Object fInputElement;
    private CheckboxTableViewer fViewer;
    private ILabelProvider fLabelProvider;
    private IStructuredContentProvider fContentProvider;
    private final String fHelpContextId;
    private Object fCurrentSelection;

    public SingleListSelectionDialog(Shell parentShell, String title, String message, String helpContextId, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, Object input) {
        super(parentShell);
        this.fHelpContextId = helpContextId;
        this.setTitle(title);
        this.setMessage(message);
        this.fInputElement = input;
        this.fContentProvider = contentProvider;
        this.fLabelProvider = labelProvider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.fViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fViewer.getTable().setLayoutData((Object)data);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (SingleListSelectionDialog.this.fCurrentSelection != null) {
                    SingleListSelectionDialog.this.fViewer.setChecked(SingleListSelectionDialog.this.fCurrentSelection, false);
                }
                SingleListSelectionDialog.this.fCurrentSelection = event.getElement();
                SingleListSelectionDialog.this.fViewer.setChecked(SingleListSelectionDialog.this.fCurrentSelection, event.getChecked());
                SingleListSelectionDialog.this.fViewer.setSelection((ISelection)new StructuredSelection(SingleListSelectionDialog.this.fCurrentSelection));
            }
        });
        this.fViewer.setInput(this.fInputElement);
        List initialSelection = this.getInitialElementSelections();
        if (!initialSelection.isEmpty()) {
            this.fCurrentSelection = initialSelection.get(0);
            this.fViewer.setChecked(this.fCurrentSelection, true);
        }
        UI.hookHelpListener((Control)composite, this.fHelpContextId);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        Object[] children = this.fContentProvider.getElements(this.fInputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.fViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            this.setResult(list);
        }
        super.okPressed();
    }
}

