/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets;

import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.ide.ui.util.BaseLabelProvider;
import com.ibm.team.apt.internal.ide.ui.widgets.InformationBar;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class InformationViewer
extends ContentViewer {
    private InformationBar fInformationBar;
    private Object fCurrentElement;
    private ViewerComparator fComparator;
    private ListenerList fListeners = new ListenerList(1);

    public InformationViewer(Composite parent, int style) {
        this.fInformationBar = new InformationBar(parent, style);
        this.fInformationBar.addLinkListener(new InformationBar.IInformationBarListener(){

            @Override
            public void clicked(String ref) {
                if (InformationViewer.this.fCurrentElement != null) {
                    InformationViewer.this.fireMessageClicked(InformationViewer.this.fCurrentElement, ref);
                }
            }

            @Override
            public void closed() {
                if (InformationViewer.this.fCurrentElement != null) {
                    InformationViewer.this.fireMessageClosed(InformationViewer.this.fCurrentElement);
                }
            }
        });
    }

    public Control getControl() {
        return this.fInformationBar;
    }

    public void refresh() {
        Object[] elements;
        this.fCurrentElement = null;
        if (this.getInput() != null && (elements = ((IStructuredContentProvider)this.getContentProvider()).getElements(this.getInput())).length > 0) {
            if (this.fComparator != null) {
                this.fComparator.sort((Viewer)this, elements);
            }
            this.fCurrentElement = elements[0];
        }
        this.refreshWithCurrentElement();
    }

    protected void refreshWithCurrentElement() {
        if (this.fCurrentElement != null) {
            String message = ((IMessageLabelProvider)this.getLabelProvider()).getText(this.fCurrentElement);
            int type = ((IMessageLabelProvider)this.getLabelProvider()).getType(this.fCurrentElement);
            this.fInformationBar.setMessage(message, type);
        } else {
            this.fInformationBar.setMessage(null, 0);
        }
    }

    protected void fireMessageClosed(Object element) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ((IInformationMessageListener)object).closed(element);
            ++n2;
        }
    }

    protected void fireMessageClicked(Object element, String text) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ((IInformationMessageListener)object).clicked(element, text);
            ++n2;
        }
    }

    public void addInformationMessageListener(IInformationMessageListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeInformationMessageListener(IInformationMessageListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isLegal((boolean)(contentProvider instanceof IStructuredContentProvider));
        super.setContentProvider(contentProvider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isLegal((boolean)(labelProvider instanceof IMessageLabelProvider));
        super.setLabelProvider(labelProvider);
    }

    public void setComparator(ViewerComparator comparator) {
        if (this.fComparator == comparator) {
            return;
        }
        this.fComparator = comparator;
        this.refresh();
    }

    public ViewerComparator getComparator() {
        return this.fComparator;
    }

    public ISelection getSelection() {
        throw new UnsupportedOperationException();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        throw new UnsupportedOperationException();
    }

    public static interface IInformationMessageListener {
        public void clicked(Object var1, String var2);

        public void closed(Object var1);
    }

    public static interface IMessageLabelProvider
    extends IBaseLabelProvider {
        public String getText(Object var1);

        public int getType(Object var1);
    }

    public static class MessageComparator
    extends ViewerComparator {
        public boolean isSorterProperty(Object element, String property) {
            return true;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Message && e2 instanceof Message) {
                return ((Message)e1).compareTo((Message)e2);
            }
            return super.compare(viewer, e1, e2);
        }
    }

    public static class MessageLabelProvider
    extends BaseLabelProvider
    implements IMessageLabelProvider {
        @Override
        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof Message) {
                label.setText(((Message)element).getMessage());
            }
        }

        @Override
        public int getType(Object element) {
            if (element instanceof Message) {
                return MessageLabelProvider.severityToMessageConstant(((Message)element).getSeverity());
            }
            return 0;
        }

        private static int severityToMessageConstant(Severity severity) {
            switch (severity) {
                case NONE: {
                    return 0;
                }
                case INFO: {
                    return 1;
                }
                case WARNING: {
                    return 2;
                }
                case ERROR: {
                    return 3;
                }
            }
            throw new IllegalStateException();
        }
    }
}

