/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets;

import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.util.UITeamFutureAdapter;
import com.ibm.team.apt.internal.ide.ui.widgets.ComboBoxContentProvider;
import com.ibm.team.apt.internal.ide.ui.widgets.ComboBoxLabelProvider;
import com.ibm.team.apt.internal.ide.ui.widgets.IComboBoxPartListener;
import com.ibm.team.apt.internal.ide.ui.widgets.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class ComboBoxPart<C, E> {
    private static final String PENDING = Messages.ComboBoxPart_PENDING;
    private Combo fComboBox;
    private ComboBoxLabelProvider<E> fLabelProvider;
    private ComboBoxContentProvider<C, E> fContentProvider;
    private Comparator<E> fComparator;
    private List<E> fElements;
    private ListenerList fListeners;

    public ComboBoxPart(Composite parent, int flags) {
        this.fComboBox = new Combo(parent, flags);
        this.fListeners = new ListenerList(1);
    }

    public Combo getControl() {
        return this.fComboBox;
    }

    public void setLabelProvider(ComboBoxLabelProvider<E> labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public void setContentProvider(ComboBoxContentProvider<C, E> contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public void setComparator(Comparator<E> comparator) {
        this.fComparator = comparator;
    }

    public void addListener(IComboBoxPartListener<C> listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(IComboBoxPartListener<C> listener) {
        this.fListeners.remove(listener);
    }

    public int getItemCount() {
        return this.fComboBox.getItemCount();
    }

    public void select(int index) {
        this.fComboBox.select(index);
    }

    public E getSelection() {
        if (this.fComboBox.getSelectionIndex() == -1) {
            return null;
        }
        return this.fElements.get(this.fComboBox.getSelectionIndex());
    }

    public Collection<E> getElements() {
        if (this.fElements == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.fElements);
    }

    public void setSelection(E element) {
        int index = this.fElements.indexOf(element);
        if (index != -1) {
            this.fComboBox.select(index);
        }
    }

    public void setInput(final C input) {
        Assert.isNotNull(this.fLabelProvider);
        Assert.isNotNull(this.fContentProvider);
        final E selection = this.fElements != null && this.fComboBox.getSelectionIndex() != -1 && this.fComboBox.getSelectionIndex() < this.fElements.size() ? (E)this.fElements.get(this.fComboBox.getSelectionIndex()) : null;
        this.fComboBox.removeAll();
        if (this.fContentProvider.isDeferred()) {
            final TeamFuture future = new TeamFuture<List<? extends E>>(){

                public List<? extends E> resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ComboBoxPart.this.fContentProvider.getDeferredElements(input, monitor);
                }
            };
            this.fComboBox.setEnabled(false);
            this.fComboBox.add(PENDING, 0);
            this.fComboBox.select(0);
            future.addListener(UITeamFutureAdapter.create(this.fComboBox.getDisplay(), new TeamFutureAdapter<List<? extends E>>(){

                public void resolvingDone(TeamFutureEvent<List<? extends E>> event) {
                    if (ComboBoxPart.this.fComboBox.isDisposed()) {
                        return;
                    }
                    ComboBoxPart.this.fComboBox.remove(0);
                    ComboBoxPart.this.fElements = new ArrayList((Collection)future.getResult());
                    ComboBoxPart.this.updateElements(selection);
                    ComboBoxPart.this.fComboBox.setEnabled(true);
                    ComboBoxPart.this.fireDeferredElementResolved(input);
                }

                public void resolvingFailed(TeamFutureEvent<List<? extends E>> event) {
                }

                public void resolvingCanceled(TeamFutureEvent<List<? extends E>> event) {
                }
            }));
        } else {
            this.fElements = new ArrayList<E>(this.fContentProvider.getElements(input));
            this.updateElements(selection);
        }
    }

    private void updateElements(E selection) {
        int index;
        if (this.fComparator != null) {
            Collections.sort(this.fElements, this.fComparator);
        }
        for (E element : this.fElements) {
            this.fComboBox.add(this.fLabelProvider.getText(element));
            this.fComboBox.setData(String.valueOf(this.fComboBox.getItemCount() - 1), element);
        }
        if (selection != null && (index = this.fElements.indexOf(selection)) != -1) {
            this.fComboBox.select(index);
        }
    }

    private void fireDeferredElementResolved(C element) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IComboBoxPartListener listener = (IComboBoxPartListener)listeners[i];
            listener.deferredElementResolved(element);
            ++i;
        }
    }
}

