/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.widgets.Messages;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AnimatedLoadingLabel
extends Composite {
    private static final String LOADING_1 = Messages.AnimatedLoadingLabel_LOADING_1;
    private static final String LOADING_2 = Messages.AnimatedLoadingLabel_LOADING_2;
    private static final String LOADING_3 = Messages.AnimatedLoadingLabel_LOADING_3;
    private static final String[] LABELS = new String[]{LOADING_1, LOADING_2, LOADING_3};
    private Label fLabel;
    private volatile boolean fRunning;

    public AnimatedLoadingLabel(Composite parent, int style) {
        this(parent, style, 0x1000000, 0x1000000);
    }

    public AnimatedLoadingLabel(Composite parent, int style, int hAlignment, int vAlignment) {
        super(parent, style);
        this.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        this.fLabel = new Label((Composite)this, 0);
        GridData gridData = new GridData(hAlignment, vAlignment, true, true);
        this.fLabel.setLayoutData((Object)gridData);
        this.fLabel.setForeground(PlanningUIPlugin.getDefault().getMidShadow());
        this.fLabel.setBackground(parent.getBackground());
        this.updateWidthHint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fLabel.setFont(font);
        this.updateWidthHint();
    }

    public void start(int milliseconds) {
        this.fRunning = true;
        this.getDisplay().timerExec(milliseconds, (Runnable)new Animation());
    }

    public void stop() {
        this.fRunning = false;
        this.fLabel.setText("");
    }

    private void updateWidthHint() {
        GC gc = new GC((Drawable)this.getDisplay());
        try {
            gc.setFont(this.fLabel.getFont());
            ((GridData)this.fLabel.getLayoutData()).widthHint = gc.textExtent((String)AnimatedLoadingLabel.LOADING_3).x + this.fLabel.getBorderWidth() * 2;
        }
        finally {
            gc.dispose();
        }
    }

    private class Animation
    implements Runnable {
        private int fIndex;

        private Animation() {
        }

        @Override
        public void run() {
            if (!AnimatedLoadingLabel.this.isDisposed() && AnimatedLoadingLabel.this.fRunning) {
                AnimatedLoadingLabel.this.fLabel.setText(LABELS[this.fIndex++]);
                if (this.fIndex == 3) {
                    this.fIndex = 0;
                }
                AnimatedLoadingLabel.this.getDisplay().timerExec(500, (Runnable)this);
            }
        }
    }
}

