/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.ide.ui.util.ImagePool;
import com.ibm.team.apt.internal.ide.ui.util.Messages;
import com.ibm.team.apt.internal.ide.ui.util.SWTUtil;
import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.account.CollaborationAccountEvent;
import com.ibm.team.collaboration.core.account.ICollaborationAccountListener;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.core.session.CollaborationSessionEvent;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.core.session.CollaborationUserEvent;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.collaboration.core.session.ICollaborationUserListener;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.internal.SharedItemChangeEvent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class UserLabelProvider
extends TypeLabelProvider
implements IPropertyChangeListener {
    Color fActiveColor = null;
    private Font fBoldFont = null;
    Color fInactiveColor = null;
    private Font fItalicFont = null;
    private Font fNormalFont = null;
    private final CollaborationServiceListener fServiceListener = new CollaborationServiceListener();
    private Set<ITeamRepository> fContributorChangeRepos = new HashSet<ITeamRepository>();
    private Set<ITeamRepository> fTeamChangeRepos = new HashSet<ITeamRepository>();
    private boolean fIsDisposed = false;
    private Display fDisplay;
    private ITeamRepositoryService.IRepositoryServiceListener fRepoListener = new ITeamRepositoryService.IRepositoryServiceListener(){

        public void addedRepository(ITeamRepository repositiory) {
        }

        public void removedRepository(ITeamRepository repository) {
            if (UserLabelProvider.this.fContributorChangeRepos.contains(repository)) {
                UserLabelProvider.this.fContributorChangeRepos.remove(repository);
            }
            if (UserLabelProvider.this.fTeamChangeRepos.contains(repository)) {
                UserLabelProvider.this.fTeamChangeRepos.remove(repository);
            }
        }
    };
    private ISharedItemChangeListener fChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            final HashMap<UUID, IItem> map = new HashMap<UUID, IItem>();
            for (SharedItemChangeEvent event : events) {
                if (event.getBeforeState() == null || event.getAfterState() == null) continue;
                map.put(event.getSharedItem().getItemId(), event.getSharedItem());
            }
            if (map.isEmpty()) {
                return;
            }
            SWTUtil.greedyExec(UserLabelProvider.this.fDisplay, new Runnable(){

                @Override
                public void run() {
                    UserLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)UserLabelProvider.this, map.values().toArray()));
                }
            });
        }
    };

    private static final FontDescriptor getNormalFontDescriptor() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getDescriptor("org.eclipse.jface.defaultfont");
    }

    public UserLabelProvider() {
        this.fDisplay = Display.getCurrent();
        if (this.fDisplay == null) {
            throw new IllegalStateException("Must be called from the UI thread");
        }
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepoListener);
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.addPresenceListener((ICollaborationPresenceListener)this.fServiceListener);
        service.addSessionListener((ICollaborationSessionListener)this.fServiceListener);
        service.addUserListener((ICollaborationUserListener)this.fServiceListener);
        service.getAccountManager().addAccountListener((ICollaborationAccountListener)this.fServiceListener);
        this.fActiveColor = new Color((Device)this.fDisplay, CollaborationUI.getForegroundColor((CollaborationPresenceStatus)CollaborationPresenceStatus.STATUS_AVAILABLE, (boolean)true));
        this.fInactiveColor = new Color((Device)this.fDisplay, CollaborationUI.getForegroundColor((CollaborationPresenceStatus)CollaborationPresenceStatus.STATUS_OFFLINE, (boolean)true));
    }

    private void doContributor(ViewerLabel label, IContributor contributor) {
        String contributorLabel = contributor.getName();
        if (contributor.isArchived()) {
            contributorLabel = String.valueOf(contributorLabel) + Messages.UserLabelProvider_1;
        }
        label.setText(contributorLabel);
        ImageDescriptor descriptor = null;
        CollaborationPresenceStatus status = CollaborationCore.getCollaborationService().getPresenceStatus((IContributorHandle)contributor);
        if (status.isUnkown() || status.isOffline()) {
            descriptor = ImagePool.STATUS_OFFLINE;
        } else {
            int style = CollaborationUI.getFontStyle((CollaborationPresenceStatus)status);
            if (style == 1) {
                label.setFont(this.getBoldFont());
            } else if (style == 2) {
                label.setFont(this.getItalicFont());
            } else {
                label.setFont(this.getNormalFont());
            }
            label.setForeground(this.getForegroundColor(status));
            descriptor = CollaborationUI.getImageDescriptor((CollaborationPresenceStatus)status, (boolean)true);
        }
        if (descriptor != null) {
            Image image;
            ImageDescriptor overlayDescriptor = CollaborationUI.getOverlayDescriptor((IContributorHandle)contributor);
            ImageDescriptor archivedDesciptor = null;
            if (contributor.isArchived()) {
                archivedDesciptor = ImagePool.ARCHIVED_CONTRIBUTOR;
            }
            if (overlayDescriptor != null) {
                Image image2 = this.getImage(descriptor);
                if (image2 != null) {
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[3];
                    imageDescriptorArray[1] = overlayDescriptor;
                    imageDescriptorArray[2] = archivedDesciptor;
                    descriptor = new OverlayIcon(descriptor, image2, imageDescriptorArray, new Point(16, 16), 16512);
                }
            } else if (archivedDesciptor != null && (image = this.getImage(descriptor)) != null) {
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                imageDescriptorArray[1] = archivedDesciptor;
                descriptor = new OverlayIcon(descriptor, image, imageDescriptorArray, new Point(16, 16), 16512);
            }
            label.setImage(this.getImage(descriptor));
        }
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (this.fIsDisposed) {
            return;
        }
        this.registerListener((IItem)element);
        if (element instanceof IContributor) {
            this.doContributor(label, (IContributor)element);
        }
    }

    private void registerListener(IItem item) {
        Object origin = item.getOrigin();
        if (!(origin instanceof ITeamRepository)) {
            return;
        }
        ITeamRepository repo = (ITeamRepository)origin;
        if (item instanceof IContributor) {
            if (this.fContributorChangeRepos.contains(repo)) {
                return;
            }
            this.fContributorChangeRepos.add(repo);
            repo.itemManager().addItemChangeListener(IContributor.ITEM_TYPE, this.fChangeListener);
        } else if (item instanceof ITeamArea) {
            if (this.fTeamChangeRepos.contains(repo)) {
                return;
            }
            this.fTeamChangeRepos.add(repo);
            repo.itemManager().addItemChangeListener(ITeamArea.ITEM_TYPE, this.fChangeListener);
        }
    }

    private void fireUserLabelProviderChanged(final IContributorHandle handle) {
        if (handle != null && !this.fDisplay.isDisposed()) {
            Object origin = handle.getOrigin();
            if (origin instanceof ITeamRepository) {
                final ITeamRepository repository = (ITeamRepository)origin;
                Job job = new Job(Messages.UserLabelProvider_2){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            final IItem item = repository.itemManager().fetchPartialItem((IItemHandle)handle, 0, CollaborationUser.CONTRIBUTOR_PROPERTIES, monitor);
                            if (item != null && !UserLabelProvider.this.fDisplay.isDisposed()) {
                                UserLabelProvider.this.fDisplay.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (UserLabelProvider.this.fIsDisposed) {
                                            return;
                                        }
                                        UserLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)UserLabelProvider.this, (Object)item));
                                    }
                                });
                            }
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                job.setSystem(true);
                job.schedule();
            }
        } else if (!this.fDisplay.isDisposed()) {
            this.fDisplay.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (UserLabelProvider.this.fIsDisposed) {
                        return;
                    }
                    UserLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)UserLabelProvider.this, null));
                }
            });
        }
    }

    private Font getBoldFont() {
        if (this.fBoldFont == null) {
            this.fBoldFont = (Font)this.getResources().get((DeviceResourceDescriptor)UserLabelProvider.getNormalFontDescriptor().withStyle(1));
        }
        return this.fBoldFont;
    }

    private Color getForegroundColor(CollaborationPresenceStatus status) {
        Assert.isNotNull((Object)status);
        CollaborationPresenceStatus standard = status.getStandard();
        if (CollaborationPresenceStatus.STATUS_AVAILABLE.equals((Object)standard) || CollaborationPresenceStatus.STATUS_AWAY.equals((Object)standard)) {
            return this.fActiveColor;
        }
        return this.fInactiveColor;
    }

    private Font getItalicFont() {
        if (this.fItalicFont == null) {
            this.fItalicFont = (Font)this.getResources().get((DeviceResourceDescriptor)UserLabelProvider.getNormalFontDescriptor().withStyle(2));
        }
        return this.fItalicFont;
    }

    private Font getNormalFont() {
        if (this.fNormalFont == null) {
            this.fNormalFont = (Font)this.getResources().get((DeviceResourceDescriptor)UserLabelProvider.getNormalFontDescriptor());
        }
        return this.fNormalFont;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Assert.isNotNull((Object)event);
        if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
            this.fBoldFont = null;
            this.fItalicFont = null;
            this.fNormalFont = null;
            this.fireUserLabelProviderChanged(null);
        }
    }

    public void dispose() {
        if (this.fIsDisposed) {
            return;
        }
        this.fIsDisposed = true;
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fRepoListener);
        for (ITeamRepository repo : this.fTeamChangeRepos) {
            repo.itemManager().purgeItemChangeListener(this.fChangeListener);
        }
        for (ITeamRepository repo : this.fContributorChangeRepos) {
            repo.itemManager().purgeItemChangeListener(this.fChangeListener);
        }
        if (this.fActiveColor != null && !this.fActiveColor.isDisposed()) {
            this.fActiveColor.dispose();
            this.fActiveColor = null;
        }
        if (this.fInactiveColor != null && !this.fInactiveColor.isDisposed()) {
            this.fInactiveColor.dispose();
            this.fInactiveColor = null;
        }
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.removeSessionListener((ICollaborationSessionListener)this.fServiceListener);
        service.removePresenceListener((ICollaborationPresenceListener)this.fServiceListener);
        service.removeUserListener((ICollaborationUserListener)this.fServiceListener);
        service.getAccountManager().removeAccountListener((ICollaborationAccountListener)this.fServiceListener);
        super.dispose();
    }

    private final class CollaborationServiceListener
    implements ICollaborationSessionListener,
    ICollaborationPresenceListener,
    ICollaborationAccountListener,
    ICollaborationUserListener {
        CollaborationServiceListener() {
        }

        public void accountNotification(CollaborationAccountEvent event) {
            UserLabelProvider.this.fireUserLabelProviderChanged(null);
        }

        public void presenceNotification(CollaborationPresenceEvent event) {
            IContributorHandle handle = event.getUser().getContributor();
            if (handle != null) {
                UserLabelProvider.this.fireUserLabelProviderChanged(handle);
            } else {
                UserLabelProvider.this.fireUserLabelProviderChanged(null);
            }
        }

        public void sessionNotification(CollaborationSessionEvent event) {
            int type = event.getType();
            if (type == 0 || type == 1) {
                UserLabelProvider.this.fireUserLabelProviderChanged(null);
            }
        }

        public void userNotification(CollaborationUserEvent event) {
            IContributorHandle handle = event.getUser().getContributor();
            if (handle != null) {
                UserLabelProvider.this.fireUserLabelProviderChanged(handle);
            } else {
                UserLabelProvider.this.fireUserLabelProviderChanged(null);
            }
        }
    }
}

