/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class UI {
    public static boolean syncExec(Control control, Runnable runnable) {
        return UI.exec(control, runnable, true);
    }

    public static boolean asyncExec(Control control, Runnable runnable) {
        return UI.exec(control, runnable, false);
    }

    private static boolean exec(final Control control, final Runnable runnable, boolean sync) {
        if (control.isDisposed()) {
            return false;
        }
        Display display = control.getDisplay();
        if (sync && display == Display.getCurrent()) {
            runnable.run();
            return true;
        }
        final boolean[] result = new boolean[1];
        Runnable real = new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed()) {
                    result[0] = false;
                    return;
                }
                result[0] = true;
                runnable.run();
            }
        };
        if (sync) {
            display.syncExec(real);
        } else {
            display.asyncExec(real);
        }
        return result[0];
    }

    public static boolean syncExec(Display display, Runnable runnable) {
        return UI.exec(display, runnable, true);
    }

    public static boolean asyncExec(Display display, Runnable runnable) {
        return UI.exec(display, runnable, false);
    }

    private static boolean exec(Display display, Runnable runnable, boolean sync) {
        if (display.isDisposed()) {
            return false;
        }
        if (sync) {
            display.syncExec(runnable);
        } else {
            display.asyncExec(runnable);
        }
        return true;
    }

    public static void hookHelpListener(Control control, String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, contextId);
    }

    public static IProgressService getProgressService(IWorkbenchPart part) {
        return part.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
    }

    public static FontData[] modifyFont(FontData[] data, int height, int style) {
        FontData[] newData = new FontData[data.length];
        int i = 0;
        while (i < data.length) {
            FontData fontData = data[i];
            newData[i] = new FontData(fontData.getName(), fontData.getHeight() + height, fontData.getStyle() | style);
            ++i;
        }
        return newData;
    }

    public static int height(Font font) {
        if (font == null) {
            return 0;
        }
        FontData[] datas = font.getFontData();
        int height = 0;
        FontData[] fontDataArray = datas;
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            height = Math.max(height, data.getHeight());
            ++n2;
        }
        return height;
    }

    public static void showAndDisposeMenu(Menu menu, Point location) {
        if (menu == null) {
            return;
        }
        if (location == null) {
            location = menu.getDisplay().getCursorLocation();
        }
        menu.setLocation(location);
        menu.setVisible(true);
        Display display = menu.getDisplay();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!menu.isDisposed()) {
            menu.dispose();
        }
    }

    public static String safeString(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("&", "&&");
    }

    public static boolean hasStyle(int style, int flag) {
        return (style & flag) == flag;
    }

    public static int removeStyles(int style, int flag, int ... rest) {
        style &= ~flag;
        int[] nArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            style &= ~i;
            ++n2;
        }
        return style;
    }
}

