/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.util.IExecutionContext;
import com.ibm.team.apt.internal.ide.ui.util.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public abstract class TeamRunnable
implements IRunnableWithProgress {
    private IStatus fStatus;

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void execute(IRunnableContext context, boolean fork, boolean cancelable, IExecutionContext tec) {
        try {
            context.run(fork, cancelable, (IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e) {
            this.fStatus = new Status(4, PlanningUIPlugin.getPluginId(), 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : Messages.TeamRunnable_FAILURE_UNKNOWN_PROBLEM, (Throwable)e);
            tec.handleStatus(this.fStatus);
        }
        catch (InterruptedException e) {
            this.fStatus = Status.CANCEL_STATUS;
            tec.handleStatus(this.fStatus);
        }
    }

    public void execute(IRunnableContext context, boolean fork, boolean cancelable) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
        try {
            context.run(fork, cancelable, (IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TeamRepositoryException) {
                throw (TeamRepositoryException)cause;
            }
            throw e;
        }
    }

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.execute(monitor);
        }
        catch (TeamRepositoryException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected abstract void execute(IProgressMonitor var1) throws TeamRepositoryException, InvocationTargetException, InterruptedException;
}

