/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.ide.ui.util.ITeamExecutionContext;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IStatus;

public abstract class TeamExecutionContext
implements ITeamExecutionContext {
    @Override
    public void handleStatus(IStatus status) {
        TeamExecutionContext.dispatch(status, this);
    }

    static void dispatch(IStatus status, ITeamExecutionContext context) {
        switch (status.getSeverity()) {
            case 0: {
                context.handleOK(status);
                break;
            }
            case 1: {
                context.handleInfo(status);
                break;
            }
            case 2: {
                context.handleWarning(status);
                break;
            }
            case 4: {
                Throwable e = status.getException();
                if (e instanceof NotLoggedInException) {
                    context.handleNotLoggedIn(status, (NotLoggedInException)e);
                }
                if (e instanceof TeamRepositoryException) {
                    context.handleTeamRepositoryException(status, (TeamRepositoryException)e);
                    break;
                }
                context.handleError(status);
                break;
            }
            case 8: {
                context.handleCancel(status);
            }
        }
    }
}

