/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.ide.ui.teamload.Messages;
import com.ibm.team.apt.internal.ide.ui.util.IMessageContext;
import com.ibm.team.apt.internal.ide.ui.util.ITeamExecutionContext;
import com.ibm.team.apt.internal.ide.ui.util.IterationSelectionDialog;
import com.ibm.team.apt.internal.ide.ui.util.PixelConverter;
import com.ibm.team.apt.internal.ide.ui.util.TeamCallable;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MemberAreaConfigurationPart
extends Composite {
    private final IRunnableContext fContext;
    private final ITeamExecutionContext fTeamContext;
    private final IMessageContext fMessageContext;
    private volatile boolean fInitialized;
    private volatile IProjectAreaHandle fProjectAreaHandle;
    private volatile IProcessArea fProcessArea;
    private volatile IDevelopmentLine fDevelopmentLine;
    private volatile IIteration fIteration;
    private Label fProcessAreaLabel;
    private Text fProcessAreaTextPart;
    private Button fBrowseProcessArea;
    private Button fUseCurrentIteration;
    private Text fIterationTextPart;
    private Button fBrowseIteration;

    public MemberAreaConfigurationPart(Composite parent, int style, IProjectAreaHandle projectAreaHandle, IProcessArea processArea, IDevelopmentLine devLine, IIteration iteration, IRunnableContext context, ITeamExecutionContext teamContext, IMessageContext messageContext) {
        super(parent, style);
        this.fProjectAreaHandle = projectAreaHandle;
        this.fProcessArea = processArea;
        this.fDevelopmentLine = devLine;
        this.fIteration = iteration;
        Assert.isNotNull((Object)context);
        this.fContext = context;
        Assert.isNotNull((Object)teamContext);
        this.fTeamContext = teamContext;
        Assert.isNotNull((Object)messageContext);
        this.fMessageContext = messageContext;
        this.createContents();
    }

    public IProcessArea getProcessArea() {
        return this.fProcessArea;
    }

    public IIteration getIteration() {
        return this.fIteration;
    }

    public IDevelopmentLine getDevelopmentLine() {
        return this.fDevelopmentLine;
    }

    public boolean isInitialized() {
        return this.fInitialized;
    }

    public void updateMessage() {
        IIteration iteration;
        String message = null;
        ConnectedProjectAreaRegistry projectAreaRegistry = ConnectedProjectAreaRegistry.getDefault();
        if (!projectAreaRegistry.isConnectedProjectArea(this.fProjectAreaHandle)) {
            message = Messages.TeamLoadDialog_MSG_DISCONNECTED_PROJECT_AREA;
        } else if (!this.useCurrentIteration() && (iteration = (IIteration)this.fIterationTextPart.getData()) == null) {
            message = Messages.TeamLoadDialog_MSG_SELECT_ITERATION;
        }
        if (message != null) {
            this.fMessageContext.updateStatus((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), message));
        } else {
            this.fMessageContext.updateStatus(Status.OK_STATUS);
        }
    }

    private boolean useCurrentIteration() {
        if (this.fUseCurrentIteration != null) {
            return this.fUseCurrentIteration.getSelection();
        }
        return false;
    }

    private <T> void execute(TeamCallable<T> callable) {
        callable.execute(this.fContext, true, true, this.fTeamContext);
    }

    private void createContents() {
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        this.fProcessAreaLabel = new Label((Composite)this, 16384);
        this.fProcessAreaLabel.setText(Messages.MemberAreaConfigurationPart_LABEL_TEAM_AREA);
        this.fProcessAreaTextPart = new Text((Composite)this, 2056);
        this.fProcessAreaTextPart.setBackground(this.getBackground());
        this.fProcessAreaTextPart.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        PixelConverter pixelConverter = new PixelConverter((Control)this.fProcessAreaTextPart);
        GridData gridData = (GridData)this.fProcessAreaTextPart.getLayoutData();
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(30);
        this.fBrowseProcessArea = new Button((Composite)this, 8);
        this.fBrowseProcessArea.setText(Messages.MemberAreaConfigurationPart_TEAM_AREA_BROWSE);
        this.fBrowseProcessArea.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.fBrowseProcessArea.setEnabled(this.fProjectAreaHandle != null);
        this.fBrowseProcessArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessAreaSelectionDialog selDlg = new ProcessAreaSelectionDialog(MemberAreaConfigurationPart.this.getShell(), false);
                selDlg.setInput((Object)ConnectedProjectAreaRegistry.getDefault());
                if (selDlg.open() == 0) {
                    IProcessArea selection = selDlg.getSelectedProcessArea();
                    MemberAreaConfigurationPart.this.updateProcessArea(selection);
                }
            }
        });
        Label label = new Label((Composite)this, 16384);
        label.setText(Messages.MemberAreaConfigurationPart_LABEL_ITERATION);
        this.fUseCurrentIteration = new Button((Composite)this, 32);
        GridDataFactory.fillDefaults().span(2, 0).grab(true, false).applyTo((Control)this.fUseCurrentIteration);
        this.fUseCurrentIteration.setText(Messages.TeamLoadDialog_CHECK_CURRENT_ITERATION);
        this.fUseCurrentIteration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MemberAreaConfigurationPart.this.fUseCurrentIteration.getSelection()) {
                    MemberAreaConfigurationPart.this.fIteration = null;
                }
                MemberAreaConfigurationPart.this.updateIterationControls(MemberAreaConfigurationPart.this.fIteration, false);
            }
        });
        this.fUseCurrentIteration.setSelection(this.fIteration == null);
        new Label((Composite)this, 0);
        this.fIterationTextPart = new Text((Composite)this, 2056);
        this.fIterationTextPart.setBackground(this.getBackground());
        this.fIterationTextPart.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        if (this.fIteration != null) {
            this.fIterationTextPart.setText(this.fIteration.getLabel());
            this.fIterationTextPart.setData((Object)this.fIteration);
        }
        this.fBrowseIteration = new Button((Composite)this, 8);
        this.fBrowseIteration.setText(Messages.MemberAreaConfigurationPart_ITERATION_BROWSE);
        this.fBrowseIteration.setEnabled(this.fProcessArea != null);
        this.fBrowseIteration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IterationSelectionDialog dialog = new IterationSelectionDialog(MemberAreaConfigurationPart.this.getShell(), (IIterationHandle)MemberAreaConfigurationPart.this.fIteration, false);
                dialog.setInput(MemberAreaConfigurationPart.this.fProcessArea);
                if (dialog.open() == 0) {
                    MemberAreaConfigurationPart.this.fIteration = (IIteration)dialog.getResult()[0];
                    MemberAreaConfigurationPart.this.updateIterationControls(MemberAreaConfigurationPart.this.fIteration, true);
                }
            }
        });
        this.updateIterationControls(this.fIteration, true);
        this.execute(new TeamCallable<1Result>(){

            @Override
            protected 1Result execute(IProgressMonitor monitor) throws TeamRepositoryException {
                class Result {
                    IDevelopmentLine iterationContainer;
                    String processAreaLabel;
                    IIteration iteration;

                    Result() {
                    }
                }
                Result result = new Result();
                if (MemberAreaConfigurationPart.this.fProcessArea != null) {
                    if (MemberAreaConfigurationPart.this.fProcessArea instanceof ITeamArea) {
                        result.iterationContainer = PlanningClientPlugin.getAuditableClient((IItemHandle)MemberAreaConfigurationPart.this.fProcessArea).getDevelopmentLine((ITeamAreaHandle)((ITeamArea)MemberAreaConfigurationPart.this.fProcessArea), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else if (MemberAreaConfigurationPart.this.fProcessArea instanceof IProjectArea && MemberAreaConfigurationPart.this.fDevelopmentLine != null) {
                        result.iterationContainer = MemberAreaConfigurationPart.this.fDevelopmentLine;
                    }
                    if (result.iterationContainer != null && MemberAreaConfigurationPart.this.fIteration == null) {
                        result.iteration = MemberAreaConfigurationPart.this.retrieveCurrentIteration(result.iterationContainer, monitor);
                    }
                    result.processAreaLabel = MemberAreaConfigurationPart.processAreaToString(MemberAreaConfigurationPart.this.fProcessArea, monitor);
                }
                return result;
            }

            @Override
            protected void processResult(1Result result) {
                if (MemberAreaConfigurationPart.this.fProcessArea != null) {
                    MemberAreaConfigurationPart.this.fDevelopmentLine = result.iterationContainer;
                    MemberAreaConfigurationPart.this.fProcessAreaTextPart.setText(result.processAreaLabel);
                    if (result.iteration != null) {
                        MemberAreaConfigurationPart.this.fIteration = result.iteration;
                        MemberAreaConfigurationPart.this.updateIterationControls(result.iteration, true);
                    }
                } else {
                    MemberAreaConfigurationPart.this.fUseCurrentIteration.setSelection(false);
                    MemberAreaConfigurationPart.this.fUseCurrentIteration.setEnabled(false);
                }
                MemberAreaConfigurationPart.this.fInitialized = true;
                MemberAreaConfigurationPart.this.updateMessage();
            }
        });
    }

    private void updateProcessArea(final IProcessArea processArea) {
        this.execute(new TeamCallable<2Result>(){

            @Override
            protected 2Result execute(IProgressMonitor monitor) throws TeamRepositoryException {
                class Result {
                    public IProcessArea processArea;
                    public IDevelopmentLine iterationContainer;
                    public IDevelopmentLine devLine;
                    public String processAreaLabel;
                    public IIteration iteration;

                    Result() {
                    }
                }
                Result result = new Result();
                if (processArea instanceof ITeamArea) {
                    IDevelopmentLine developmentLine;
                    result.processArea = processArea;
                    result.iterationContainer = developmentLine = PlanningClientPlugin.getAuditableClient((IItemHandle)processArea).getDevelopmentLine((ITeamAreaHandle)((ITeamArea)processArea), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.iteration = MemberAreaConfigurationPart.this.fDevelopmentLine != null && MemberAreaConfigurationPart.this.fDevelopmentLine.sameItemId((IItemHandle)developmentLine) ? MemberAreaConfigurationPart.this.fIteration : MemberAreaConfigurationPart.this.retrieveCurrentIteration(developmentLine, monitor);
                } else if (processArea instanceof IProjectArea) {
                    IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)processArea).itemManager();
                    result.processArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)processArea, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ((IProjectArea)result.processArea).getIterationTypes();
                    IDevelopmentLineHandle projectDevelopmentLine = ((IProjectArea)result.processArea).getProjectDevelopmentLine();
                    if (projectDevelopmentLine != null) {
                        result.devLine = (IDevelopmentLine)manager.fetchCompleteItem((IItemHandle)projectDevelopmentLine, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        IDevelopmentLineHandle[] lines = ((IProjectArea)result.processArea).getDevelopmentLines();
                        if (lines.length > 0) {
                            result.devLine = (IDevelopmentLine)manager.fetchCompleteItem((IItemHandle)lines[0], 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    if (result.devLine != null) {
                        result.iterationContainer = result.devLine;
                        result.iteration = MemberAreaConfigurationPart.this.retrieveCurrentIteration(result.iterationContainer, monitor);
                    }
                }
                result.processAreaLabel = MemberAreaConfigurationPart.processAreaToString(result.processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return result;
            }

            @Override
            protected void processResult(2Result result) {
                MemberAreaConfigurationPart.this.fProcessArea = result.processArea;
                MemberAreaConfigurationPart.this.fDevelopmentLine = result.iterationContainer;
                MemberAreaConfigurationPart.this.fIteration = result.iteration;
                MemberAreaConfigurationPart.this.updateControls(result.processArea, result.processAreaLabel);
                MemberAreaConfigurationPart.this.updateIterationControls(result.iteration, true);
            }
        });
    }

    private void updateControls(IProcessArea processArea, String label) {
        if (processArea == null) {
            this.fProcessAreaTextPart.setText("");
            this.fUseCurrentIteration.setEnabled(false);
            this.fIterationTextPart.setEnabled(false);
            this.fBrowseIteration.setEnabled(false);
        } else {
            this.fProcessAreaTextPart.setText(label);
            this.fUseCurrentIteration.setEnabled(true);
            this.fIterationTextPart.setEnabled(true);
            this.fBrowseIteration.setEnabled(true);
        }
        this.updateMessage();
    }

    private void updateIterationControls(IIteration iteration, boolean updateIterationText) {
        boolean useCurrentIteration = this.fUseCurrentIteration.getSelection();
        if (iteration != null) {
            this.fIterationTextPart.setText(iteration.getLabel());
            this.fIterationTextPart.setData((Object)iteration);
        } else if (updateIterationText) {
            this.fIterationTextPart.setText("");
            this.fIterationTextPart.setData(null);
        }
        this.fIterationTextPart.setEnabled(!useCurrentIteration);
        this.fBrowseIteration.setEnabled(!useCurrentIteration);
        this.updateMessage();
    }

    private static String processAreaToString(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea instanceof IProjectArea) {
            return ((IProjectArea)processArea).getName();
        }
        StringBuilder result = new StringBuilder();
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)processArea).itemManager();
        IProjectArea projectArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)processArea.getProjectArea(), 0, monitor);
        ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
        MemberAreaConfigurationPart.teamAreaToString(result, (ITeamArea)processArea, hierarchy, manager, monitor);
        result.trimToSize();
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    private static void teamAreaToString(StringBuilder result, ITeamArea teamArea, ITeamAreaHierarchy hierarchy, IItemManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamAreaHandle parent = hierarchy.getParent((ITeamAreaHandle)teamArea);
        if (parent != null) {
            ITeamArea resolvedParent = (ITeamArea)manager.fetchCompleteItem((IItemHandle)parent, 0, monitor);
            MemberAreaConfigurationPart.teamAreaToString(result, resolvedParent, hierarchy, manager, monitor);
        }
        result.append(teamArea.getName());
        result.append("/");
    }

    private IIteration retrieveCurrentIteration(IDevelopmentLine devLine, IProgressMonitor monitor) {
        IIteration currentIteration = null;
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)devLine);
        try {
            currentIteration = Iterations.getCurrentPlanLeafIteration((IDevelopmentLineHandle)devLine, (IAuditableCommon)auditableClient, (IProgressMonitor)subMonitor);
        }
        catch (TeamRepositoryException tre) {
            tre.printStackTrace();
        }
        return currentIteration;
    }
}

