/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.util.IterationStructure;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.util.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.UIJob;

public class IterationSelectionDialog
extends ElementTreeSelectionDialog {
    private final boolean fShowCheckBox;
    private Button fExcludeIterationsNotInRelease;
    private static IterationContentProvider fIterationContentProvider;

    public IterationSelectionDialog(Shell parent, IIterationHandle toReveal, boolean showCheckBox) {
        this(parent, toReveal, false, showCheckBox);
    }

    public IterationSelectionDialog(Shell parent, boolean showDevLinesOnly, boolean showCheckBox) {
        this(parent, null, showDevLinesOnly, showCheckBox);
    }

    public IterationSelectionDialog(Shell parent, IIterationHandle toReveal, final boolean showDevLinesOnly, boolean showCheckBox) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new IterationContentProvider(toReveal, showDevLinesOnly));
        this.fShowCheckBox = showCheckBox;
        this.setMessage(showDevLinesOnly ? Messages.IterationSelectionDialog_MSG_SELECT_TIMELINE : Messages.IterationSelectionDialog_MSG_SELECT_ITERATION);
        this.setTitle(showDevLinesOnly ? Messages.IterationSelectionDialog_TITLE_SELECT_TIMELINE : Messages.IterationSelectionDialog_SELECT_ITERATION);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (showDevLinesOnly) {
                    if (selection.length == 0) {
                        return new Status(4, PlanningUIPlugin.getPluginId(), Messages.IterationSelectionDialog_MSG_SELECT_DEV_LINE);
                    }
                    return new Status(0, PlanningUIPlugin.getPluginId(), "");
                }
                if (selection.length == 0 || !(selection[0] instanceof IIteration)) {
                    return new Status(4, PlanningUIPlugin.getPluginId(), Messages.IterationSelectionDialog_MSG_SELECT_ITERATION);
                }
                IIteration iteration = (IIteration)selection[0];
                if (IterationSelectionDialog.this.fExcludeIterationsNotInRelease != null && IterationSelectionDialog.this.fExcludeIterationsNotInRelease.getSelection() && !iteration.hasDeliverable() || IterationSelectionDialog.this.fExcludeIterationsNotInRelease == null && !iteration.hasDeliverable()) {
                    return new Status(4, PlanningUIPlugin.getPluginId(), Messages.IterationSelectionDialog_NO_RELEASE_SCHEDULED);
                }
                return new Status(0, PlanningUIPlugin.getPluginId(), "");
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Control result = super.createDialogArea(parent);
        UI.hookHelpListener(result, "com.ibm.team.apt.ide.ui.dialog_select_iteration");
        if (this.fShowCheckBox) {
            this.fExcludeIterationsNotInRelease = new Button(parent, 32);
            this.fExcludeIterationsNotInRelease.setText(Messages.IterationSelectionDialog_EXCLUDE_ITERATIONS_WITHOUT_RELEASE);
            this.fExcludeIterationsNotInRelease.setSelection(true);
            this.fExcludeIterationsNotInRelease.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fIterationContentProvider.setFetched(false);
                    fIterationContentProvider.fViewer.refresh();
                }
            });
            GridDataFactory.swtDefaults().indent(11, 0).span(3, 0).applyTo((Control)this.fExcludeIterationsNotInRelease);
        }
        return result;
    }

    protected void updateStatus(IStatus status) {
        if (this.getTreeViewer() != null && this.getTreeViewer().getContentProvider() != null) {
            IterationContentProvider contentProvider = (IterationContentProvider)this.getTreeViewer().getContentProvider();
            if (contentProvider.getFetched()) {
                super.updateStatus(status);
            } else if (status.getSeverity() == 4) {
                this.getButton(0).setEnabled(false);
            } else {
                super.updateStatus(status);
            }
        } else {
            super.updateStatus(status);
        }
    }

    private static class IterationContentProvider
    implements ITreeContentProvider,
    IDeferredWorkbenchAdapter {
        private DeferredTreeContentManager fManager;
        private StandardLabelProvider fLabelProvider;
        private Viewer fViewer;
        private Object fInput;
        private boolean fShowDevLinesOnly;
        private IIterationHandle fToResolve;
        private IterationStructure fIterationStructure;
        private boolean fFetched;

        public IterationContentProvider(IIterationHandle toResolve, boolean showDevLinesOnly) {
            this.fShowDevLinesOnly = showDevLinesOnly;
            this.fToResolve = toResolve;
            fIterationContentProvider = this;
        }

        public synchronized boolean getFetched() {
            return this.fFetched;
        }

        public void setFetched(boolean fetched) {
            this.fFetched = fetched;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = viewer;
            if (this.fManager == null) {
                this.fManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)viewer){

                    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                        return this;
                    }
                };
            }
            if (this.fLabelProvider == null) {
                this.fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
            }
            this.fInput = newInput;
        }

        public void dispose() {
            this.fManager = null;
            if (this.fLabelProvider != null) {
                this.fLabelProvider.dispose();
            }
        }

        public Object[] getElements(Object inputElement) {
            if (this.fManager == null) {
                return new Object[]{new Object()};
            }
            return this.getChildren(inputElement);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IDevelopmentLine && this.fIterationStructure != null) {
                return !this.fShowDevLinesOnly && ((IDevelopmentLine)element).getIterations().length > 0;
            }
            if (element instanceof IIteration && this.fIterationStructure != null) {
                return this.getIterations(((IIteration)element).getChildren()).length > 0;
            }
            return true;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDevelopmentLineHandle && this.fIterationStructure != null) {
                IDevelopmentLine devLine = this.fIterationStructure.getDevelopmentLine((IDevelopmentLineHandle)parentElement);
                return this.fIterationStructure.getIterations(devLine.getIterations()).toArray();
            }
            if (parentElement instanceof IIteration && this.fIterationStructure != null) {
                return this.getIterations(((IIteration)parentElement).getChildren());
            }
            return this.fManager.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof IDevelopmentLine && this.fInput instanceof IProjectArea) {
                return this.fInput;
            }
            if (element instanceof IIteration && this.fIterationStructure != null) {
                IIterationHandle parent = ((IIteration)element).getParent();
                if (parent == null) {
                    return this.fInput;
                }
                return this.fIterationStructure.getIterations(new IIterationHandle[]{parent});
            }
            return null;
        }

        public void fetchDeferredChildren(Object element, IElementCollector collector, IProgressMonitor monitor) {
            try {
                IItemManager manager;
                IItemManager iItemManager = manager = element instanceof IItemHandle ? PlanningClientPlugin.getTeamRepository((IItemHandle)((IItemHandle)element)).itemManager() : null;
                if (element instanceof IProjectAreaHandle && !(element instanceof IProjectArea)) {
                    element = manager.fetchCompleteItem((IItemHandle)((IProjectAreaHandle)element), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (element instanceof IProjectArea) {
                    this.fIterationStructure = IterationStructure.create((IProjectAreaHandle)((IProjectArea)element), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ItemList developmentLines = this.fIterationStructure.getDevelopmentLines(false);
                    if (developmentLines.size() == 1) {
                        element = developmentLines.get(0);
                    } else {
                        ItemCollections.sort((ItemList)developmentLines, (Comparator)new Comparator<IDevelopmentLine>(){
                            private Collator collator = CollatorCache.getInstance();

                            @Override
                            public int compare(IDevelopmentLine o1, IDevelopmentLine o2) {
                                return this.collator.compare(o1.getName(), o2.getName());
                            }
                        });
                        collector.add(developmentLines.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        return;
                    }
                }
                try {
                    if (element instanceof ITeamAreaHandle) {
                        ITeamAreaHandle handle = (ITeamAreaHandle)element;
                        element = PlanningClientPlugin.getAuditableClient((IItemHandle)handle).getDevelopmentLine(handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (element instanceof IDevelopmentLineHandle && !(element instanceof IDevelopmentLine)) {
                        element = manager.fetchCompleteItem((IItemHandle)((IDevelopmentLineHandle)element), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (element instanceof IDevelopmentLine) {
                        IDevelopmentLine line = (IDevelopmentLine)element;
                        if (this.fIterationStructure == null) {
                            this.fIterationStructure = IterationStructure.create((IProjectAreaHandle)line.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        collector.add((Object[])this.getIterations(line.getIterations()), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        new UIJob(Messages.IterationSelectionDialog_JOB_SET_SELECTION){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (fToResolve != null) {
                                    fViewer.setSelection((ISelection)new StructuredSelection((Object)fIterationStructure.getIteration(fToResolve)), true);
                                } else {
                                    fViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                                }
                                fFetched = true;
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    } else if (element instanceof IIteration) {
                        IIteration iteration = (IIteration)element;
                        collector.add((Object[])this.getIterations(iteration.getChildren()), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
            finally {
                collector.done();
                monitor.done();
            }
        }

        public IIteration[] getIterations(IIterationHandle[] handles) {
            ItemList iterations = this.fIterationStructure.getIterations(handles);
            ArrayList<IIteration> result = new ArrayList<IIteration>();
            for (IIteration iteration : iterations) {
                if (!this.fIterationStructure.showIteration((IIterationHandle)iteration) || iteration.isArchived()) continue;
                result.add(iteration);
            }
            return result.toArray(new IIteration[result.size()]);
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return this.fLabelProvider.getText(o);
        }
    }

    private static class LabelProvider
    extends StandardLabelProvider {
        public LabelProvider() {
            super((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        }

        public void updateLabel(ViewerLabel label, Object element) {
            super.updateLabel(label, element);
        }
    }
}

