/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextStyleRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.TextStyle;

public class HtmlStyle {
    private static final Pattern PATTERN = Pattern.compile("<span +class=\"([\\.0-9a-zA-Z]*)\">(.*)</span>");
    private final String fContent;
    private final Map<String, TextStyle> fStyles;
    private String fTextValue;
    private List<TextStyleRange> fStyleRanges = new ArrayList<TextStyleRange>();

    public static HtmlStyle parse(String content, Map<String, TextStyle> styles) {
        return new HtmlStyle(content, styles);
    }

    private HtmlStyle(String content, Map<String, TextStyle> styles) {
        this.fContent = content;
        this.fStyles = styles;
        this.init();
    }

    protected void init() {
        StringBuilder text = new StringBuilder();
        int beginIndex = 0;
        Matcher matcher = PATTERN.matcher(this.fContent);
        while (matcher.find()) {
            int start = matcher.start();
            text.append(this.fContent.subSequence(beginIndex, start));
            if (this.fStyles.containsKey(matcher.group(1))) {
                TextStyle style = this.fStyles.get(matcher.group(1));
                TextStyleRange range = new TextStyleRange(text.length(), matcher.group(2).length(), style);
                this.fStyleRanges.add(range);
            }
            text.append(matcher.group(2));
            beginIndex = matcher.end();
        }
        text.append(this.fContent.substring(beginIndex));
        this.fTextValue = text.toString();
    }

    public TextStyleRange[] getStyleRanges() {
        return this.fStyleRanges.toArray(new TextStyleRange[0]);
    }

    public String getTextValue() {
        return this.fTextValue;
    }
}

