/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class GCState {
    public static final int ADVANCED = 1;
    public static final int ALPHA = 2;
    public static final int ANTIALIAS = 4;
    public static final int BACKGROUND = 8;
    public static final int BACKGROUNDPATTERN = 16;
    public static final int CLIPPING = 32;
    public static final int FILLRULE = 64;
    public static final int FONT = 128;
    public static final int FOREGROUND = 256;
    public static final int FOREGROUNDPATTERN = 512;
    public static final int INTERPOLATION = 1024;
    public static final int LINEATTRIBUTES = 2048;
    public static final int LINECAP = 4096;
    public static final int LINEDASHS = 8192;
    public static final int LINEJOIN = 16384;
    public static final int LINESTYLE = 32768;
    public static final int LINEWIDTH = 65536;
    public static final int TEXTANTIALIAS = 131072;
    public static final int MODE = 262144;
    public static final int TRANSFORM = 524288;
    public static final int COLORS = 264;
    public static final int FONT_COLORS = 392;
    private final GC fGc;
    private final int fFlags;
    private boolean fAdvanced;
    private int fAlpha;
    private int fAntialias;
    private Color fBackground;
    private Pattern fBackgroundPattern;
    private Rectangle fClipping;
    private int fFillRule;
    private Font fFont;
    private Color fForeground;
    private Pattern fForegroundPattern;
    private int fInterpolation;
    private LineAttributes fLineAttributes;
    private int fLineCap;
    private int[] fLineDashs;
    private int fLineJoin;
    private int fLineStyle;
    private int fLineWidth;
    private int fTextAntialias;
    private boolean fMode;
    private Transform fTransform;

    private GCState(GC gc, int flags) {
        this.fGc = gc;
        this.fFlags = flags;
    }

    public static GCState save(GC gc, int flags) {
        if (GCState.hasBit(flags, 2, 4, 16, 32, 512, 2048, 1024, 131072, 524288)) {
            flags |= 1;
        }
        GCState state = new GCState(gc, flags);
        if ((flags & 1) != 0) {
            state.fAdvanced = gc.getAdvanced();
        }
        if ((flags & 2) != 0) {
            state.fAlpha = gc.getAlpha();
        }
        if ((flags & 4) != 0) {
            state.fAntialias = gc.getAntialias();
        }
        if ((flags & 8) != 0) {
            state.fBackground = gc.getBackground();
        }
        if ((flags & 0x10) != 0) {
            state.fBackgroundPattern = gc.getBackgroundPattern();
        }
        if ((flags & 0x20) != 0) {
            state.fClipping = gc.getClipping();
        }
        if ((flags & 0x40) != 0) {
            state.fFillRule = gc.getFillRule();
        }
        if ((flags & 0x80) != 0) {
            state.fFont = gc.getFont();
        }
        if ((flags & 0x100) != 0) {
            state.fForeground = gc.getForeground();
        }
        if ((flags & 0x200) != 0) {
            state.fForegroundPattern = gc.getForegroundPattern();
        }
        if ((flags & 0x400) != 0) {
            state.fInterpolation = gc.getInterpolation();
        }
        if ((flags & 0x800) != 0) {
            state.fLineAttributes = gc.getLineAttributes();
        }
        if ((flags & 0x1000) != 0) {
            state.fLineCap = gc.getLineCap();
        }
        if ((flags & 0x2000) != 0) {
            state.fLineDashs = gc.getLineDash();
        }
        if ((flags & 0x4000) != 0) {
            state.fLineJoin = gc.getLineJoin();
        }
        if ((flags & 0x8000) != 0) {
            state.fLineStyle = gc.getLineStyle();
        }
        if ((flags & 0x10000) != 0) {
            state.fLineWidth = gc.getLineWidth();
        }
        if ((flags & 0x20000) != 0) {
            state.fTextAntialias = gc.getTextAntialias();
        }
        if ((flags & 0x80000) != 0) {
            state.fTransform = new Transform(gc.getDevice());
            gc.getTransform(state.fTransform);
        }
        if ((flags & 0x40000) != 0) {
            state.fMode = gc.getXORMode();
        }
        return state;
    }

    private static boolean hasBit(int mask, int flag, int ... rest) {
        boolean has = false;
        has |= (mask & flag) != 0;
        int[] nArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            has |= (mask & i) != 0;
            ++n2;
        }
        return has;
    }

    public void restore() {
        if ((this.fFlags & 1) != 0 && this.fAdvanced != this.fGc.getAdvanced()) {
            this.fGc.setAdvanced(this.fAdvanced);
        }
        if ((this.fFlags & 2) != 0) {
            this.fGc.setAlpha(this.fAlpha);
        }
        if ((this.fFlags & 4) != 0) {
            this.fGc.setAntialias(this.fAntialias);
        }
        if ((this.fFlags & 8) != 0) {
            this.fGc.setBackground(this.fBackground);
        }
        if ((this.fFlags & 0x10) != 0) {
            this.fGc.setBackgroundPattern(this.fBackgroundPattern);
        }
        if ((this.fFlags & 0x20) != 0) {
            this.fGc.setClipping(this.fClipping);
        }
        if ((this.fFlags & 0x40) != 0) {
            this.fGc.setFillRule(this.fFillRule);
        }
        if ((this.fFlags & 0x80) != 0) {
            this.fGc.setFont(this.fFont);
        }
        if ((this.fFlags & 0x100) != 0) {
            this.fGc.setForeground(this.fForeground);
        }
        if ((this.fFlags & 0x200) != 0) {
            this.fGc.setForegroundPattern(this.fForegroundPattern);
        }
        if ((this.fFlags & 0x400) != 0) {
            this.fGc.setInterpolation(this.fInterpolation);
        }
        if ((this.fFlags & 0x800) != 0) {
            this.fGc.setLineAttributes(this.fLineAttributes);
        }
        if ((this.fFlags & 0x1000) != 0) {
            this.fGc.setLineCap(this.fLineCap);
        }
        if ((this.fFlags & 0x2000) != 0) {
            this.fGc.setLineDash(this.fLineDashs);
        }
        if ((this.fFlags & 0x4000) != 0) {
            this.fGc.setLineJoin(this.fLineJoin);
        }
        if ((this.fFlags & 0x8000) != 0) {
            this.fGc.setLineStyle(this.fLineStyle);
        }
        if ((this.fFlags & 0x10000) != 0) {
            this.fGc.setLineWidth(this.fLineWidth);
        }
        if ((this.fFlags & 0x20000) != 0) {
            this.fGc.setTextAntialias(this.fTextAntialias);
        }
        if ((this.fFlags & 0x80000) != 0 && this.fTransform != null && !this.fTransform.isDisposed()) {
            this.fGc.setTransform(this.fTransform);
            this.fTransform.dispose();
            this.fTransform = null;
        }
        if ((this.fFlags & 0x40000) != 0) {
            this.fGc.setXORMode(this.fMode);
        }
    }

    public boolean isAdvanced() {
        Assert.isTrue(((this.fFlags & 1) != 0 ? 1 : 0) != 0);
        return this.fAdvanced;
    }

    public int getAlpha() {
        Assert.isTrue(((this.fFlags & 2) != 0 ? 1 : 0) != 0);
        return this.fAlpha;
    }

    public int getAntialias() {
        Assert.isTrue(((this.fFlags & 4) != 0 ? 1 : 0) != 0);
        return this.fAntialias;
    }

    public Color getBackground() {
        Assert.isTrue(((this.fFlags & 8) != 0 ? 1 : 0) != 0);
        return this.fBackground;
    }

    public Pattern getBackgroundPattern() {
        Assert.isTrue(((this.fFlags & 0x10) != 0 ? 1 : 0) != 0);
        return this.fBackgroundPattern;
    }

    public Rectangle getClipping() {
        Assert.isTrue(((this.fFlags & 0x20) != 0 ? 1 : 0) != 0);
        return this.fClipping;
    }

    public int getFillRule() {
        Assert.isTrue(((this.fFlags & 0x40) != 0 ? 1 : 0) != 0);
        return this.fFillRule;
    }

    public Font getFont() {
        Assert.isTrue(((this.fFlags & 0x80) != 0 ? 1 : 0) != 0);
        return this.fFont;
    }

    public Color getForeground() {
        Assert.isTrue(((this.fFlags & 0x100) != 0 ? 1 : 0) != 0);
        return this.fForeground;
    }

    public Pattern getForegroundPattern() {
        Assert.isTrue(((this.fFlags & 0x200) != 0 ? 1 : 0) != 0);
        return this.fForegroundPattern;
    }

    public int getInterpolation() {
        Assert.isTrue(((this.fFlags & 0x400) != 0 ? 1 : 0) != 0);
        return this.fInterpolation;
    }

    public LineAttributes getLineAttributes() {
        Assert.isTrue(((this.fFlags & 0x800) != 0 ? 1 : 0) != 0);
        return this.fLineAttributes;
    }

    public int getLineCap() {
        Assert.isTrue(((this.fFlags & 0x1000) != 0 ? 1 : 0) != 0);
        return this.fLineCap;
    }

    public int[] getLineDashs() {
        Assert.isTrue(((this.fFlags & 0x2000) != 0 ? 1 : 0) != 0);
        return this.fLineDashs;
    }

    public int getLineJoin() {
        Assert.isTrue(((this.fFlags & 0x4000) != 0 ? 1 : 0) != 0);
        return this.fLineJoin;
    }

    public int getLineStyle() {
        Assert.isTrue(((this.fFlags & 0x8000) != 0 ? 1 : 0) != 0);
        return this.fLineStyle;
    }

    public int getLineWidth() {
        Assert.isTrue(((this.fFlags & 0x10000) != 0 ? 1 : 0) != 0);
        return this.fLineWidth;
    }

    public int getTextAntialias() {
        Assert.isTrue(((this.fFlags & 0x20000) != 0 ? 1 : 0) != 0);
        return this.fTextAntialias;
    }

    public boolean isMode() {
        Assert.isTrue(((this.fFlags & 0x40000) != 0 ? 1 : 0) != 0);
        return this.fMode;
    }
}

