/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.util.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketTimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler fgInstance = new ExceptionHandler();

    public static void log(Throwable t, String message) {
        PlanningUIPlugin.log((IStatus)new Status(4, PlanningUI.getPluginId(), 4, message, t));
    }

    public static void handle(CoreException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    public static void handle(TeamRepositoryException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    public static void handle(InvocationTargetException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    protected void perform(CoreException e, Shell shell, String title, String message) {
        PlanningUIPlugin.log(e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e, e.getMessage(), shell, title, message);
        }
    }

    protected void perform(TeamRepositoryException e, Shell shell, String title, String message) {
        ITeamRepository repository;
        Throwable cause = e.getCause();
        ITeamRepository iTeamRepository = repository = e.getOrigin() instanceof ITeamRepository ? (ITeamRepository)e.getOrigin() : null;
        if (cause instanceof CoreException) {
            this.perform((CoreException)cause, shell, title, message);
        } else if (cause instanceof SocketTimeoutException) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)(repository != null ? NLS.bind((String)Messages.ExceptionHandler_TIME_OUT_WITH_NAME, (Object)repository.getName(), (Object[])new Object[0]) : Messages.ExceptionHandler_TIME_OUT));
        } else if (e instanceof NotLoggedInException) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)(repository != null ? NLS.bind((String)Messages.ExceptionHandler_NOT_LOGGED_IN_WITH_NAME, (Object)repository.getName(), (Object[])new Object[0]) : Messages.ExceptionHandler_NOT_LOGGED_IN));
        } else {
            PlanningUIPlugin.log(e);
            this.displayMessageDialog(e, e.getMessage(), shell, title, message);
        }
    }

    protected void perform(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            this.perform((CoreException)target, shell, title, message);
        } else if (target instanceof TeamRepositoryException) {
            this.perform((TeamRepositoryException)target, shell, title, message);
        } else {
            PlanningUIPlugin.log(e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                this.displayMessageDialog(e, e.getMessage(), shell, title, message);
            } else {
                this.displayMessageDialog(e, target.getMessage(), shell, title, message);
            }
        }
    }

    private void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write(Messages.ExceptionHandler_FAILURE_CHECK_LOG);
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }
}

