/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class DisplayRunnable
implements Runnable {
    private Display fDisplay;
    private Control fControl;
    private volatile boolean fExecuted;

    public DisplayRunnable(Display display) {
        Assert.isNotNull((Object)display);
        this.fDisplay = display;
    }

    public DisplayRunnable(Control control) {
        Assert.isNotNull((Object)control);
        this.fControl = control;
    }

    public boolean syncExec() {
        return this.exec(true);
    }

    public boolean asyncExec() {
        return this.exec(false);
    }

    protected boolean exec(boolean sync) {
        Display display = this.fDisplay;
        if (this.fControl != null) {
            display = this.fControl.getDisplay();
        }
        if (sync) {
            display.syncExec((Runnable)this);
        } else {
            display.asyncExec((Runnable)this);
        }
        return this.fExecuted;
    }

    @Override
    public final void run() {
        if (this.fControl != null && this.fControl.isDisposed()) {
            this.fExecuted = false;
            return;
        }
        this.fExecuted = true;
        this.execute();
    }

    protected abstract void execute();
}

