/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.util.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UITeamFutureAdapter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class DeferredContentDialog
extends Dialog {
    private TeamFuture<?> fFuture;
    private String fTitle;
    private ControlEnableState fControlEnableState;
    private ImageLoader fProgressImageLoader;
    private CLabel fLabel;
    private IStatus fLastStatus;
    private Color fNormalMsgAreaBackground;
    private boolean fStatusLineAboveButtons = true;

    public <T> DeferredContentDialog(Shell parent, TeamFuture<T> future) {
        super(parent);
        Assert.isLegal((future != null ? 1 : 0) != 0);
        this.fLastStatus = new Status(0, "org.eclipse.jface", 0, "", null);
        future.addListener(UITeamFutureAdapter.create(parent.getDisplay(), new TeamFutureAdapter<T>(){

            public void resolvingFailed(TeamFutureEvent<T> event) {
                if (this.processResolving(event)) {
                    DeferredContentDialog.this.updateStatus(event.getTeamFuture().getStatus());
                }
            }

            public void resolvingCanceled(TeamFutureEvent<T> event) {
                if (this.processResolving(event)) {
                    DeferredContentDialog.this.close();
                }
            }

            public void resolvingDone(TeamFutureEvent<T> event) {
                if (this.processResolving(event)) {
                    DeferredContentDialog.this.futureResolved();
                }
            }

            private boolean processResolving(TeamFutureEvent<T> event) {
                event.getTeamFuture().removeListener((ITeamFutureListener)this);
                if (!DeferredContentDialog.this.isContentCreated() || DeferredContentDialog.this.fControlEnableState == null) {
                    return false;
                }
                DeferredContentDialog.this.stopAnimation();
                DeferredContentDialog.this.fControlEnableState.restore();
                return true;
            }
        }));
        this.fFuture = future;
    }

    private boolean isContentCreated() {
        return this.fLabel != null;
    }

    public void setTitle(String title) {
        this.fTitle = title != null ? title : "";
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(this.fTitle);
        }
    }

    public void setStatusLineAboveButtons(boolean aboveButtons) {
        this.fStatusLineAboveButtons = aboveButtons;
    }

    protected void updateStatus(IStatus status) {
        this.fLastStatus = status;
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.updateButtonsEnableState(status);
            this.setErrorStatus(status);
        }
    }

    public IStatus getStatus() {
        return this.fLastStatus;
    }

    protected TeamFuture<?> getFuture() {
        return this.fFuture;
    }

    protected abstract void futureResolved();

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!status.matches(4));
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        super.create();
        if (this.fLastStatus != null) {
            if (this.fLastStatus.matches(4)) {
                this.fLastStatus = new Status(4, this.fLastStatus.getPlugin(), this.fLastStatus.getCode(), "", this.fLastStatus.getException());
            }
            this.updateStatus(this.fLastStatus);
        }
        TeamFuture<?> teamFuture = this.fFuture;
        synchronized (teamFuture) {
            if (!this.fFuture.isResolved()) {
                this.fControlEnableState = ControlEnableState.disable((Control)this.getDialogArea());
                this.startAnimation(Messages.DeferredContentDialog_JOB_FETCHING_DATA);
                this.getButton(0).setEnabled(false);
            } else {
                IStatus status = this.fFuture.getStatus();
                if (status.isOK()) {
                    this.futureResolved();
                } else if (status.getSeverity() == 8) {
                    this.close();
                } else {
                    this.updateStatus(status);
                }
            }
        }
    }

    public int open() {
        IStatus status = this.fFuture.getStatus();
        if (status != null && status.getSeverity() == 8) {
            return 1;
        }
        return super.open();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.fStatusLineAboveButtons ? 1 : 2;
        layout.marginHeight = 0;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fLabel = new CLabel(composite, 16384);
        this.fLabel.setLayoutData((Object)new GridData(768));
        this.fNormalMsgAreaBackground = this.fLabel.getBackground();
        Control buttons = super.createButtonBar(composite);
        GridData gd = new GridData(768);
        gd.horizontalSpan = layout.numColumns;
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        DeferredContentDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void startAnimation(String message) {
        this.fLabel.setText(message);
    }

    private void stopAnimation() {
        this.updateStatus(this.fLastStatus);
    }

    private void setErrorStatus(IStatus status) {
        String message;
        if (status != null && !status.isOK() && (message = status.getMessage()) != null && message.length() > 0) {
            this.fLabel.setText(message);
            this.fLabel.setBackground(JFaceColors.getErrorBackground((Display)this.getShell().getDisplay()));
            return;
        }
        this.fLabel.setText("");
        this.fLabel.setBackground(this.fNormalMsgAreaBackground);
    }
}

