/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class BlockingItemResolver {
    IProgressService fProgressService = null;

    public BlockingItemResolver() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            this.fProgressService = workbench.getProgressService();
        }
    }

    public BlockingItemResolver(IProgressService progressService) {
        this.fProgressService = progressService;
    }

    public <T extends IItem> T resolvePartial(IItemHandle handle, ItemProfile profile) throws InvocationTargetException, InterruptedException {
        return this.resolvePartial(handle, profile.getProperties());
    }

    public <T extends IItem> T resolvePartial(final IItemHandle handle, final Collection properties) throws InvocationTargetException, InterruptedException {
        final IItem[] resolvedItemReference = new IItem[1];
        this.doResolve(new TeamRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws TeamRepositoryException {
                ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)handle);
                IItemManager manager = repository.itemManager();
                resolvedItemReference[0] = manager.fetchPartialItem(handle, 0, properties, monitor);
            }
        });
        return (T)resolvedItemReference[0];
    }

    public <T extends IItem> T resolveComplete(final IItemHandle handle) throws InvocationTargetException, InterruptedException {
        final IItem[] resolvedItemReference = new IItem[1];
        this.doResolve(new TeamRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws TeamRepositoryException {
                ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)handle);
                IItemManager manager = repository.itemManager();
                resolvedItemReference[0] = manager.fetchCompleteItem(handle, 0, monitor);
            }
        });
        return (T)resolvedItemReference[0];
    }

    private void doResolve(final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.fProgressService == null || Job.getJobManager().currentJob() != null || ModalContext.isModalContextThread((Thread)Thread.currentThread())) {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        } else if (Display.getCurrent() != null) {
            this.fProgressService.run(true, true, runnable);
        } else {
            final Exception[] exceptionReference = new Exception[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        BlockingItemResolver.this.fProgressService.run(true, true, runnable);
                    }
                    catch (Exception e) {
                        exceptionReference[0] = e;
                    }
                }
            });
            if (exceptionReference[0] != null) {
                if (exceptionReference[0] instanceof InvocationTargetException) {
                    throw new InvocationTargetException(exceptionReference[0]);
                }
                if (exceptionReference[0] instanceof InterruptedException) {
                    throw (InterruptedException)exceptionReference[0];
                }
            }
        }
    }
}

