/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.ide.ui.util.BaseLabelProvider;
import com.ibm.team.jface.labelProviders.IElementRemovedListener;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;

public class AntispamLabelProvider
extends BaseLabelProvider {
    private Map<Object, ViewerLabel> labels = new HashMap<Object, ViewerLabel>();
    private IElementRemovedNotifier notifier;
    private IViewerLabelProvider vlp;
    private IElementRemovedListener elementRemovedListener = new IElementRemovedListener(){

        public void handleElementRemoved(Object element) {
            AntispamLabelProvider.this.labels.remove(element);
        }
    };
    private ILabelProviderListener nestedListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            if (elements == null) {
                for (Map.Entry entry : AntispamLabelProvider.this.labels.entrySet()) {
                    entry.setValue(null);
                }
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>(elements.length);
                int idx = 0;
                while (idx < elements.length) {
                    Object next = elements[idx];
                    if (AntispamLabelProvider.this.labels.containsKey(next)) {
                        arrayList.add(next);
                        AntispamLabelProvider.this.labels.put(next, null);
                    }
                    ++idx;
                }
                elements = arrayList.toArray();
            }
            AntispamLabelProvider.this.fireChangeEvent(elements);
        }
    };

    public AntispamLabelProvider(IViewerLabelProvider spammy, IElementRemovedNotifier ern) {
        this.notifier = ern;
        this.notifier.addElementRemovedListener(this.elementRemovedListener);
        spammy.addListener(this.nestedListener);
        this.vlp = spammy;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.notifier.removeElementRemoveListener(this.elementRemovedListener);
        this.vlp.removeListener(this.nestedListener);
        this.vlp.dispose();
    }

    @Override
    public void updateLabel(ViewerLabel label, Object element) {
        ViewerLabel existingLabel = this.labels.get(element);
        if (existingLabel != null) {
            this.copyLabel(label, existingLabel);
        } else {
            this.vlp.updateLabel(label, element);
            existingLabel = new ViewerLabel("", null);
            this.copyLabel(existingLabel, label);
            this.labels.put(element, existingLabel);
        }
    }

    private void copyLabel(ViewerLabel label, ViewerLabel existingLabel) {
        label.setText(existingLabel.getText());
        label.setBackground(existingLabel.getBackground());
        label.setForeground(existingLabel.getForeground());
        label.setImage(existingLabel.getImage());
        label.setFont(existingLabel.getFont());
        label.setTooltipText(existingLabel.getTooltipText());
        label.setTooltipShift(existingLabel.getTooltipShift());
        label.setTooltipForegroundColor(existingLabel.getTooltipForegroundColor());
        label.setTooltipBackgroundColor(existingLabel.getTooltipBackgroundColor());
    }
}

